# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorConfigPolicyArgs', 'MonitorConfigPolicy']

@pulumi.input_type
class MonitorConfigPolicyArgs:
    def __init__(__self__, *,
                 policy_type: pulumi.Input[_builtins.str],
                 tag_policy: Optional[pulumi.Input['MonitorConfigPolicyTagPolicyArgs']] = None):
        """
        The set of arguments for constructing a MonitorConfigPolicy resource.
        :param pulumi.Input[_builtins.str] policy_type: The monitor config policy type Valid values are `tag`.
        :param pulumi.Input['MonitorConfigPolicyTagPolicyArgs'] tag_policy: Config for a tag policy. Only set if `policy_type` is `tag`.
        """
        pulumi.set(__self__, "policy_type", policy_type)
        if tag_policy is not None:
            pulumi.set(__self__, "tag_policy", tag_policy)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[_builtins.str]:
        """
        The monitor config policy type Valid values are `tag`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter(name="tagPolicy")
    def tag_policy(self) -> Optional[pulumi.Input['MonitorConfigPolicyTagPolicyArgs']]:
        """
        Config for a tag policy. Only set if `policy_type` is `tag`.
        """
        return pulumi.get(self, "tag_policy")

    @tag_policy.setter
    def tag_policy(self, value: Optional[pulumi.Input['MonitorConfigPolicyTagPolicyArgs']]):
        pulumi.set(self, "tag_policy", value)


@pulumi.input_type
class _MonitorConfigPolicyState:
    def __init__(__self__, *,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_policy: Optional[pulumi.Input['MonitorConfigPolicyTagPolicyArgs']] = None):
        """
        Input properties used for looking up and filtering MonitorConfigPolicy resources.
        :param pulumi.Input[_builtins.str] policy_type: The monitor config policy type Valid values are `tag`.
        :param pulumi.Input['MonitorConfigPolicyTagPolicyArgs'] tag_policy: Config for a tag policy. Only set if `policy_type` is `tag`.
        """
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if tag_policy is not None:
            pulumi.set(__self__, "tag_policy", tag_policy)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monitor config policy type Valid values are `tag`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter(name="tagPolicy")
    def tag_policy(self) -> Optional[pulumi.Input['MonitorConfigPolicyTagPolicyArgs']]:
        """
        Config for a tag policy. Only set if `policy_type` is `tag`.
        """
        return pulumi.get(self, "tag_policy")

    @tag_policy.setter
    def tag_policy(self, value: Optional[pulumi.Input['MonitorConfigPolicyTagPolicyArgs']]):
        pulumi.set(self, "tag_policy", value)


@pulumi.type_token("datadog:index/monitorConfigPolicy:MonitorConfigPolicy")
class MonitorConfigPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_policy: Optional[pulumi.Input[Union['MonitorConfigPolicyTagPolicyArgs', 'MonitorConfigPolicyTagPolicyArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Datadog monitor config policy resource. This can be used to create and manage Datadog monitor config policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        test = datadog.MonitorConfigPolicy("test",
            policy_type="tag",
            tag_policy={
                "tag_key": "env",
                "tag_key_required": False,
                "valid_tag_values": [
                    "staging",
                    "prod",
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_type: The monitor config policy type Valid values are `tag`.
        :param pulumi.Input[Union['MonitorConfigPolicyTagPolicyArgs', 'MonitorConfigPolicyTagPolicyArgsDict']] tag_policy: Config for a tag policy. Only set if `policy_type` is `tag`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorConfigPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog monitor config policy resource. This can be used to create and manage Datadog monitor config policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        test = datadog.MonitorConfigPolicy("test",
            policy_type="tag",
            tag_policy={
                "tag_key": "env",
                "tag_key_required": False,
                "valid_tag_values": [
                    "staging",
                    "prod",
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param MonitorConfigPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorConfigPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_policy: Optional[pulumi.Input[Union['MonitorConfigPolicyTagPolicyArgs', 'MonitorConfigPolicyTagPolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorConfigPolicyArgs.__new__(MonitorConfigPolicyArgs)

            if policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'policy_type'")
            __props__.__dict__["policy_type"] = policy_type
            __props__.__dict__["tag_policy"] = tag_policy
        super(MonitorConfigPolicy, __self__).__init__(
            'datadog:index/monitorConfigPolicy:MonitorConfigPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            tag_policy: Optional[pulumi.Input[Union['MonitorConfigPolicyTagPolicyArgs', 'MonitorConfigPolicyTagPolicyArgsDict']]] = None) -> 'MonitorConfigPolicy':
        """
        Get an existing MonitorConfigPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_type: The monitor config policy type Valid values are `tag`.
        :param pulumi.Input[Union['MonitorConfigPolicyTagPolicyArgs', 'MonitorConfigPolicyTagPolicyArgsDict']] tag_policy: Config for a tag policy. Only set if `policy_type` is `tag`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorConfigPolicyState.__new__(_MonitorConfigPolicyState)

        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["tag_policy"] = tag_policy
        return MonitorConfigPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[_builtins.str]:
        """
        The monitor config policy type Valid values are `tag`.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="tagPolicy")
    def tag_policy(self) -> pulumi.Output[Optional['outputs.MonitorConfigPolicyTagPolicy']]:
        """
        Config for a tag policy. Only set if `policy_type` is `tag`.
        """
        return pulumi.get(self, "tag_policy")

