# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 subdomain: pulumi.Input[_builtins.str],
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[_builtins.str] subdomain: Your PagerDuty account’s personalized subdomain name.
        :param pulumi.Input[_builtins.str] api_token: Your PagerDuty API token.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schedules: Array of your schedule URLs.
        """
        pulumi.set(__self__, "subdomain", subdomain)
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> pulumi.Input[_builtins.str]:
        """
        Your PagerDuty account’s personalized subdomain name.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subdomain", value)

    @_builtins.property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your PagerDuty API token.
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_token", value)

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of your schedule URLs.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "schedules", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subdomain: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[_builtins.str] api_token: Your PagerDuty API token.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schedules: Array of your schedule URLs.
        :param pulumi.Input[_builtins.str] subdomain: Your PagerDuty account’s personalized subdomain name.
        """
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if subdomain is not None:
            pulumi.set(__self__, "subdomain", subdomain)

    @_builtins.property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your PagerDuty API token.
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_token", value)

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of your schedule URLs.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "schedules", value)

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your PagerDuty account’s personalized subdomain name.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subdomain", value)


@pulumi.type_token("datadog:pagerduty/integration:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subdomain: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog - PagerDuty resource. This can be used to create and manage Datadog - PagerDuty integration. See also [PagerDuty Integration Guide](https://www.pagerduty.com/docs/guides/datadog-integration-guide/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Note: Until terraform-provider-datadog version 2.1.0, service objects under the services key were specified inside the datadog_integration_pagerduty resource. This was incompatible with multi-configuration-file setups, where users wanted to have individual service objects controlled from different Terraform configuration files. The recommended approach now is specifying service objects as individual resources using datadog_integration_pagerduty_service_object.
        # Services as Individual Resources
        pd = datadog.pagerduty.Integration("pd",
            schedules=[
                "https://ddog.pagerduty.com/schedules/X123VF",
                "https://ddog.pagerduty.com/schedules/X321XX",
            ],
            subdomain="ddog",
            api_token="38457822378273432587234242874")
        testing_foo = datadog.pagerduty.ServiceObject("testing_foo",
            service_name="testing_foo",
            service_key="9876543210123456789",
            opts = pulumi.ResourceOptions(depends_on=[pd]))
        testing_bar = datadog.pagerduty.ServiceObject("testing_bar",
            service_name="testing_bar",
            service_key="54321098765432109876",
            opts = pulumi.ResourceOptions(depends_on=[pd]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_token: Your PagerDuty API token.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schedules: Array of your schedule URLs.
        :param pulumi.Input[_builtins.str] subdomain: Your PagerDuty account’s personalized subdomain name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog - PagerDuty resource. This can be used to create and manage Datadog - PagerDuty integration. See also [PagerDuty Integration Guide](https://www.pagerduty.com/docs/guides/datadog-integration-guide/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Note: Until terraform-provider-datadog version 2.1.0, service objects under the services key were specified inside the datadog_integration_pagerduty resource. This was incompatible with multi-configuration-file setups, where users wanted to have individual service objects controlled from different Terraform configuration files. The recommended approach now is specifying service objects as individual resources using datadog_integration_pagerduty_service_object.
        # Services as Individual Resources
        pd = datadog.pagerduty.Integration("pd",
            schedules=[
                "https://ddog.pagerduty.com/schedules/X123VF",
                "https://ddog.pagerduty.com/schedules/X321XX",
            ],
            subdomain="ddog",
            api_token="38457822378273432587234242874")
        testing_foo = datadog.pagerduty.ServiceObject("testing_foo",
            service_name="testing_foo",
            service_key="9876543210123456789",
            opts = pulumi.ResourceOptions(depends_on=[pd]))
        testing_bar = datadog.pagerduty.ServiceObject("testing_bar",
            service_name="testing_bar",
            service_key="54321098765432109876",
            opts = pulumi.ResourceOptions(depends_on=[pd]))
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subdomain: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["api_token"] = None if api_token is None else pulumi.Output.secret(api_token)
            __props__.__dict__["schedules"] = schedules
            if subdomain is None and not opts.urn:
                raise TypeError("Missing required property 'subdomain'")
            __props__.__dict__["subdomain"] = subdomain
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Integration, __self__).__init__(
            'datadog:pagerduty/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_token: Optional[pulumi.Input[_builtins.str]] = None,
            schedules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            subdomain: Optional[pulumi.Input[_builtins.str]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_token: Your PagerDuty API token.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schedules: Array of your schedule URLs.
        :param pulumi.Input[_builtins.str] subdomain: Your PagerDuty account’s personalized subdomain name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["api_token"] = api_token
        __props__.__dict__["schedules"] = schedules
        __props__.__dict__["subdomain"] = subdomain
        return Integration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Your PagerDuty API token.
        """
        return pulumi.get(self, "api_token")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Array of your schedule URLs.
        """
        return pulumi.get(self, "schedules")

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> pulumi.Output[_builtins.str]:
        """
        Your PagerDuty account’s personalized subdomain name.
        """
        return pulumi.get(self, "subdomain")

