# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RumRetentionFiltersOrderArgs', 'RumRetentionFiltersOrder']

@pulumi.input_type
class RumRetentionFiltersOrderArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 retention_filter_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a RumRetentionFiltersOrder resource.
        :param pulumi.Input[_builtins.str] application_id: RUM application ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] retention_filter_ids: RUM retention filter ID list. The order of IDs in this attribute defines the order of RUM retention filters.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "retention_filter_ids", retention_filter_ids)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        RUM application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="retentionFilterIds")
    def retention_filter_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        RUM retention filter ID list. The order of IDs in this attribute defines the order of RUM retention filters.
        """
        return pulumi.get(self, "retention_filter_ids")

    @retention_filter_ids.setter
    def retention_filter_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "retention_filter_ids", value)


@pulumi.input_type
class _RumRetentionFiltersOrderState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_filter_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RumRetentionFiltersOrder resources.
        :param pulumi.Input[_builtins.str] application_id: RUM application ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] retention_filter_ids: RUM retention filter ID list. The order of IDs in this attribute defines the order of RUM retention filters.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if retention_filter_ids is not None:
            pulumi.set(__self__, "retention_filter_ids", retention_filter_ids)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RUM application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="retentionFilterIds")
    def retention_filter_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        RUM retention filter ID list. The order of IDs in this attribute defines the order of RUM retention filters.
        """
        return pulumi.get(self, "retention_filter_ids")

    @retention_filter_ids.setter
    def retention_filter_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "retention_filter_ids", value)


@pulumi.type_token("datadog:index/rumRetentionFiltersOrder:RumRetentionFiltersOrder")
class RumRetentionFiltersOrder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_filter_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog RumRetentionFiltersOrder resource. This is used to manage the order of Datadog RUM retention filters. Please note that retention_filter_ids should contain all IDs of retention filters, including the default ones created internally for a given RUM application.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/rumRetentionFiltersOrder:RumRetentionFiltersOrder testing_rum_retention_filters_order "<application_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: RUM application ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] retention_filter_ids: RUM retention filter ID list. The order of IDs in this attribute defines the order of RUM retention filters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RumRetentionFiltersOrderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog RumRetentionFiltersOrder resource. This is used to manage the order of Datadog RUM retention filters. Please note that retention_filter_ids should contain all IDs of retention filters, including the default ones created internally for a given RUM application.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/rumRetentionFiltersOrder:RumRetentionFiltersOrder testing_rum_retention_filters_order "<application_id>"
        ```

        :param str resource_name: The name of the resource.
        :param RumRetentionFiltersOrderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RumRetentionFiltersOrderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_filter_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RumRetentionFiltersOrderArgs.__new__(RumRetentionFiltersOrderArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if retention_filter_ids is None and not opts.urn:
                raise TypeError("Missing required property 'retention_filter_ids'")
            __props__.__dict__["retention_filter_ids"] = retention_filter_ids
        super(RumRetentionFiltersOrder, __self__).__init__(
            'datadog:index/rumRetentionFiltersOrder:RumRetentionFiltersOrder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            retention_filter_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'RumRetentionFiltersOrder':
        """
        Get an existing RumRetentionFiltersOrder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: RUM application ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] retention_filter_ids: RUM retention filter ID list. The order of IDs in this attribute defines the order of RUM retention filters.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RumRetentionFiltersOrderState.__new__(_RumRetentionFiltersOrderState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["retention_filter_ids"] = retention_filter_ids
        return RumRetentionFiltersOrder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        RUM application ID.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="retentionFilterIds")
    def retention_filter_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        RUM retention filter ID list. The order of IDs in this attribute defines the order of RUM retention filters.
        """
        return pulumi.get(self, "retention_filter_ids")

