# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SyntheticsPrivateLocationArgs', 'SyntheticsPrivateLocation']

@pulumi.input_type
class SyntheticsPrivateLocationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['SyntheticsPrivateLocationMetadataArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SyntheticsPrivateLocation resource.
        :param pulumi.Input[_builtins.str] name: Synthetics private location name.
        :param pulumi.Input[_builtins.str] api_key: API key used to generate the private location configuration.
        :param pulumi.Input[_builtins.str] description: Description of the private location. Defaults to `""`.
        :param pulumi.Input['SyntheticsPrivateLocationMetadataArgs'] metadata: The private location metadata
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics private location.
        """
        pulumi.set(__self__, "name", name)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Synthetics private location name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key used to generate the private location configuration.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the private location. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SyntheticsPrivateLocationMetadataArgs']]:
        """
        The private location metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SyntheticsPrivateLocationMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to associate with your synthetics private location.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SyntheticsPrivateLocationState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['SyntheticsPrivateLocationMetadataArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SyntheticsPrivateLocation resources.
        :param pulumi.Input[_builtins.str] api_key: API key used to generate the private location configuration.
        :param pulumi.Input[_builtins.str] config: Configuration skeleton for the private location. See installation instructions of the private location on how to use this configuration.
        :param pulumi.Input[_builtins.str] description: Description of the private location. Defaults to `""`.
        :param pulumi.Input['SyntheticsPrivateLocationMetadataArgs'] metadata: The private location metadata
        :param pulumi.Input[_builtins.str] name: Synthetics private location name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics private location.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API key used to generate the private location configuration.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration skeleton for the private location. See installation instructions of the private location on how to use this configuration.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the private location. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SyntheticsPrivateLocationMetadataArgs']]:
        """
        The private location metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SyntheticsPrivateLocationMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Synthetics private location name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to associate with your synthetics private location.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("datadog:index/syntheticsPrivateLocation:SyntheticsPrivateLocation")
class SyntheticsPrivateLocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['SyntheticsPrivateLocationMetadataArgs', 'SyntheticsPrivateLocationMetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog synthetics private location resource. This can be used to create and manage Datadog synthetics private locations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        private_location = datadog.SyntheticsPrivateLocation("private_location",
            name="First private location",
            description="Description of the private location",
            tags=[
                "foo:bar",
                "env:test",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Synthetics private locations can be imported using their string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsPrivateLocation:SyntheticsPrivateLocation bar pl:private-location-name-abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: API key used to generate the private location configuration.
        :param pulumi.Input[_builtins.str] description: Description of the private location. Defaults to `""`.
        :param pulumi.Input[Union['SyntheticsPrivateLocationMetadataArgs', 'SyntheticsPrivateLocationMetadataArgsDict']] metadata: The private location metadata
        :param pulumi.Input[_builtins.str] name: Synthetics private location name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics private location.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyntheticsPrivateLocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog synthetics private location resource. This can be used to create and manage Datadog synthetics private locations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        private_location = datadog.SyntheticsPrivateLocation("private_location",
            name="First private location",
            description="Description of the private location",
            tags=[
                "foo:bar",
                "env:test",
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Synthetics private locations can be imported using their string ID, e.g.

        ```sh
        $ pulumi import datadog:index/syntheticsPrivateLocation:SyntheticsPrivateLocation bar pl:private-location-name-abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param SyntheticsPrivateLocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyntheticsPrivateLocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['SyntheticsPrivateLocationMetadataArgs', 'SyntheticsPrivateLocationMetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyntheticsPrivateLocationArgs.__new__(SyntheticsPrivateLocationArgs)

            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["description"] = description
            __props__.__dict__["metadata"] = metadata
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["config"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "config"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SyntheticsPrivateLocation, __self__).__init__(
            'datadog:index/syntheticsPrivateLocation:SyntheticsPrivateLocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            config: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Union['SyntheticsPrivateLocationMetadataArgs', 'SyntheticsPrivateLocationMetadataArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SyntheticsPrivateLocation':
        """
        Get an existing SyntheticsPrivateLocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: API key used to generate the private location configuration.
        :param pulumi.Input[_builtins.str] config: Configuration skeleton for the private location. See installation instructions of the private location on how to use this configuration.
        :param pulumi.Input[_builtins.str] description: Description of the private location. Defaults to `""`.
        :param pulumi.Input[Union['SyntheticsPrivateLocationMetadataArgs', 'SyntheticsPrivateLocationMetadataArgsDict']] metadata: The private location metadata
        :param pulumi.Input[_builtins.str] name: Synthetics private location name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to associate with your synthetics private location.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyntheticsPrivateLocationState.__new__(_SyntheticsPrivateLocationState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["config"] = config
        __props__.__dict__["description"] = description
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return SyntheticsPrivateLocation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API key used to generate the private location configuration.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[_builtins.str]:
        """
        Configuration skeleton for the private location. See installation instructions of the private location on how to use this configuration.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the private location. Defaults to `""`.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional['outputs.SyntheticsPrivateLocationMetadata']]:
        """
        The private location metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Synthetics private location name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of tags to associate with your synthetics private location.
        """
        return pulumi.get(self, "tags")

