# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str],
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 send_user_invitation: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] email: Email address for user.
        :param pulumi.Input[_builtins.bool] disabled: Whether the user is disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: User's name. Should be set only for password authentication, as it is overridden by Google or SAML authentication.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: A list of role IDs to assign to the user.
        :param pulumi.Input[_builtins.bool] send_user_invitation: Whether an invitation email should be sent when the user is created. Defaults to `true`.
        """
        pulumi.set(__self__, "email", email)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if send_user_invitation is not None:
            pulumi.set(__self__, "send_user_invitation", send_user_invitation)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        Email address for user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user is disabled. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User's name. Should be set only for password authentication, as it is overridden by Google or SAML authentication.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of role IDs to assign to the user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="sendUserInvitation")
    def send_user_invitation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an invitation email should be sent when the user is created. Defaults to `true`.
        """
        return pulumi.get(self, "send_user_invitation")

    @send_user_invitation.setter
    def send_user_invitation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_user_invitation", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 send_user_invitation: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_invitation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 verified: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.bool] disabled: Whether the user is disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] email: Email address for user.
        :param pulumi.Input[_builtins.str] name: User's name. Should be set only for password authentication, as it is overridden by Google or SAML authentication.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: A list of role IDs to assign to the user.
        :param pulumi.Input[_builtins.bool] send_user_invitation: Whether an invitation email should be sent when the user is created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] user_invitation_id: The ID of the user invitation that was sent when creating the user.
        :param pulumi.Input[_builtins.bool] verified: Returns `true` if the user is verified.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if send_user_invitation is not None:
            pulumi.set(__self__, "send_user_invitation", send_user_invitation)
        if user_invitation_id is not None:
            pulumi.set(__self__, "user_invitation_id", user_invitation_id)
        if verified is not None:
            pulumi.set(__self__, "verified", verified)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user is disabled. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address for user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User's name. Should be set only for password authentication, as it is overridden by Google or SAML authentication.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of role IDs to assign to the user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="sendUserInvitation")
    def send_user_invitation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an invitation email should be sent when the user is created. Defaults to `true`.
        """
        return pulumi.get(self, "send_user_invitation")

    @send_user_invitation.setter
    def send_user_invitation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send_user_invitation", value)

    @_builtins.property
    @pulumi.getter(name="userInvitationId")
    def user_invitation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the user invitation that was sent when creating the user.
        """
        return pulumi.get(self, "user_invitation_id")

    @user_invitation_id.setter
    def user_invitation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_invitation_id", value)

    @_builtins.property
    @pulumi.getter
    def verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Returns `true` if the user is verified.
        """
        return pulumi.get(self, "verified")

    @verified.setter
    def verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verified", value)


@pulumi.type_token("datadog:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 send_user_invitation: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Datadog user resource. This can be used to create and manage Datadog users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Source a role
        ro_role = datadog.get_role(filter="Datadog Read Only Role")
        # Create a new Datadog user
        foo = datadog.User("foo",
            email="new@example.com",
            roles=[ro_role.id])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/user:User example_user 6f1b44c0-30b2-11eb-86bc-279f7c1ebaa4
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disabled: Whether the user is disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] email: Email address for user.
        :param pulumi.Input[_builtins.str] name: User's name. Should be set only for password authentication, as it is overridden by Google or SAML authentication.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: A list of role IDs to assign to the user.
        :param pulumi.Input[_builtins.bool] send_user_invitation: Whether an invitation email should be sent when the user is created. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog user resource. This can be used to create and manage Datadog users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Source a role
        ro_role = datadog.get_role(filter="Datadog Read Only Role")
        # Create a new Datadog user
        foo = datadog.User("foo",
            email="new@example.com",
            roles=[ro_role.id])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/user:User example_user 6f1b44c0-30b2-11eb-86bc-279f7c1ebaa4
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 send_user_invitation: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["disabled"] = disabled
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["name"] = name
            __props__.__dict__["roles"] = roles
            __props__.__dict__["send_user_invitation"] = send_user_invitation
            __props__.__dict__["user_invitation_id"] = None
            __props__.__dict__["verified"] = None
        super(User, __self__).__init__(
            'datadog:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            send_user_invitation: Optional[pulumi.Input[_builtins.bool]] = None,
            user_invitation_id: Optional[pulumi.Input[_builtins.str]] = None,
            verified: Optional[pulumi.Input[_builtins.bool]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] disabled: Whether the user is disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] email: Email address for user.
        :param pulumi.Input[_builtins.str] name: User's name. Should be set only for password authentication, as it is overridden by Google or SAML authentication.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: A list of role IDs to assign to the user.
        :param pulumi.Input[_builtins.bool] send_user_invitation: Whether an invitation email should be sent when the user is created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] user_invitation_id: The ID of the user invitation that was sent when creating the user.
        :param pulumi.Input[_builtins.bool] verified: Returns `true` if the user is verified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["email"] = email
        __props__.__dict__["name"] = name
        __props__.__dict__["roles"] = roles
        __props__.__dict__["send_user_invitation"] = send_user_invitation
        __props__.__dict__["user_invitation_id"] = user_invitation_id
        __props__.__dict__["verified"] = verified
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the user is disabled. Defaults to `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        Email address for user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        User's name. Should be set only for password authentication, as it is overridden by Google or SAML authentication.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of role IDs to assign to the user.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="sendUserInvitation")
    def send_user_invitation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether an invitation email should be sent when the user is created. Defaults to `true`.
        """
        return pulumi.get(self, "send_user_invitation")

    @_builtins.property
    @pulumi.getter(name="userInvitationId")
    def user_invitation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the user invitation that was sent when creating the user.
        """
        return pulumi.get(self, "user_invitation_id")

    @_builtins.property
    @pulumi.getter
    def verified(self) -> pulumi.Output[_builtins.bool]:
        """
        Returns `true` if the user is verified.
        """
        return pulumi.get(self, "verified")

