# To access placeholders...
```py
>>> from tcrutils.dr import placeholders # Contains individual placeholders (in their callable form)
# OR
>>> from tcrutils.dr import placeholder_sets # Contains presets of placeholders, for example MATH, DISCORD (dict form)
```
```py
# You can pass the placeholders to DynamicResponseBuilder
# TODO: Add example
```

# Dependencies
Placeholder dependency is a requirement for a certain context(s) to be present.
Dependencies may depend on other dependencies (`DependencyName`)or directly on contexts (`'ctx'`) or a (`! text description`)

Standard logic operators apply (`&&` or `||`).

This applies mostly to hikari library.

```txt
!in_guild: (A context must have .guild_id != None) || (event must be of guild-related type)
EventOrContext: 'event' || 'ctx'
```

Dependencies in placeholder list will refer the above list.

# Placeholder list markings

`{placeholder|arg1|arg2|...}` <- `...` means accepts unlimited number of arguments
`{placeholder|arg1|arg2?}` <-- `?` means optional, no `?` means required
`{placeholder|$noping}` <-- `$` means a switch, a boolean present/not present, can be inserted anywhere into the arguments and will be first removed, from the list (setting the flag to True if it was removed or False if it wasnt there to be removed) so any arguments will be in order `{name|arg1|switch|arg2 (NOT 3 BECAUSE SWITCH IS SKIPPED!)}`
For example:
`{placeholder|switch}` evaluates to the placeholder with its switch set to True
`{placeholder}` evaluates to the placeholder with its switch set to False (the switch `switch` is missing!)
All switches are inherently optional (therefore defaulting to False)

# Placeholders
The below list will assume the placeholder_sets.ALL option along with all its aliases. You can import placeholders individually or in other groups.

> [!NOTE]
> GitHub does not display the following table in fullwidth. For ease of use get something like the VSCode markdown viewer

| `{name}`                  | Description                                                                                                                                                               | Usage                                           | Example                               | Result                                                                           | Alias(es)                        | Dependencies                        | Notes                                                                       |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------- | ------------------------------------- | -------------------------------------------------------------------------------- | -------------------------------- | ----------------------------------- | --------------------------------------------------------------------------- |
| **DISCORD**               |                                                                                                                                                                           |                                                 |                                       |                                                                                  |                                  |                                     |                                                                             |
| **Author**                |                                                                                                                                                                           |                                                 |                                       |                                                                                  |                                  |                                     |                                                                             |
| `{username}`              | Return author's username (the unique throughout Discord one)                                                                                                              | `{username}`                                    | Hi {username}                         | Hi anamoyee                                                                      | `{user_name}`, `{user name}`     | `EventOrContext`                    | `TODO:` No support for non-author users yet                                 |
| `{globalname}`            | Return author's global name (the non-unique throughout Discord one)                                                                                                       | `{globalname}`                                  | Hai {globalname}                      | Hai anamoyee :3                                                                  | `{global_name}`, `{global name}` | `EventOrContext`                    | `TODO:` No support for non-author users yet                                 |
| `{nickname}`              | Return author's nickname, but if not found return author's global name but if not found return author's username                                                          | `{nickname}`                                    | Hewwo {nickname}                      | Hewwo anya                                                                       | `{nick_name}`, `{nick name}`     | `EventOrContext`                    | `TODO:` No support for non-author users yet                                 |
| `{mention}`               | Return mention of a user and add it to `ctxs['user_mentions']`                                                                                                            | `{mention\|user?: Snowflake = Author\|$noping}` | Hello {mention}                       | Hello <@507642999992352779>                                                      | `{@}`                            | `EventOrContext && 'user_mentions'` |                                                                             |
| `{@@}`                    | Alias for `{mention\|noping}`.                                                                                                                                            | `{@@}`                                          | Hello {@@}                            | Hello <@507642999992352779>                                                      | *None*                           | `EventOrContext && 'user_mentions'` | Still requires `'user_mentions'` due to internal structuring.               |
| `{discrim}`               | Return the author's discriminator (9999 for example). This will return '0' for users without discriminator. This is always 4-digit zero-filled, unless it's '0'.          | `{discrim}`                                     | Your number is {discrim}              | Your number is 0418                                                              | `{discriminator}`                | `EventOrContext`                    | `TODO:` No support for non-author users yet                                 |
| `{tag}`                   | Return `@{username}` if `{discrim} == 0` else `{username}#{discrim}`                                                                                                      | `{tag}`                                         | Hey {tag}                             | Hey RoboTop#2012                                                                 | *None*                           | `EventOrContext`                    | `TODO:` No support for non-author users yet                                 |
| `{id`}                    | Return the author's Discord ID                                                                                                                                            | `{id}`                                          | Your ID is {id}                       | Your ID is 507642999992352779                                                    | *None*                           | `EventOrContext`                    | `TODO:` No support for non-author users yet                                 |
| `{bot}`                   | Return `true` if user is a bot (or a webhook) else `false`                                                                                                                | `{bot}`                                         | It is {bot} that you are a bot.       | It is false that you are a bot.                                                  | `{isbot}`                        | `EventOrContext`                    |                                                                             |
| `{human}`                 | Return `true` if user is a human else `false`                                                                                                                             | `{human}`                                       | It is {human} that you are a human.   | It is true that you are a human.                                                 | `{ishuman}`                      | `EventOrContext`                    |                                                                             |
| `{roles}`                 | Return the number of roles that user has, or `0` if triggered in a non-guild context                                                                                      | `{roles}`                                       | You have {roles} roles                | You have 69 roles                                                                | *None*                           | `EventOrContext`                    | `TODO:` No support for non-author users yet                                 |
| `{avatar}`                | Return the url to the user's avatar. (protip: can be attached with `{attach}`)                                                                                            | `{avatar}`                                      | Here's a URL to your avatar: {avatar} | Here's a link to your avatar: https://cdn.discordapp.com/avatars/...             | *None*                           | `EventOrContext`                    | `TODO:` No support for non-author users yet                                 |
| `{color}`                 | Return a hex formatted color of user's topmost, colored role. If no role is found return #000000. If `nohash` switch is specified the `'#'` symbol will be omitted        | `{color\|$nohash}`                              | Your color is {color}                 | Your color is #FF8000                                                            | `{rolecolor}`                    | `EventOrContext`                    |                                                                             |
| **Server**                |                                                                                                                                                                           |                                                 |                                       |                                                                                  |                                  |                                     | All placeholders from this category are found in the `{server\|}` container |
| `{server}`                |                                                                                                                                                                           |                                                 |                                       |                                                                                  |                                  |                                     |                                                                             |
| **TEXT**                  |                                                                                                                                                                           |                                                 |                                       |                                                                                  |                                  |                                     |                                                                             |
| `{#}`                     | Discard any arguments and return an empty string (a comment)                                                                                                              | `{#\| your comment text (will not be visible)}` | Absolutely fucking nothing: {#\|}     | Absolutely fucking nothing:&nbsp;                                                      | `{//}`, `{comment}`              | *None*                              |                                                                             |
| `{var}` (setting a value) | When two (or more, but any more are discarded) arguments are passed, a variable is set. First argument is the name of it and second is the value.                         | `{var\|varname\|varvalue}`                      | {var\|this user's name\|{username}}   | *No output*                                                                      | *None*                           | `'__var'` (built-in)                |                                                                             |
| `{var}` (getting a value) | When one argument to `{var}` is passed or `{variablename}` is used literally (like, if there was a placeholder called variablename), a value of that variable is returned | `{var\|varname}` OR `{varname}`                 | Hello {this user's name}              | Hello anamoyee *(assuming `{var\|this user's name\|{username}}` was ran prioir)* | *None*                           | `'__var'` (built-in)                | If value is not found, return an empty string                               |
|                           |                                                                                                                                                                           |                                                 |                                       |                                                                                  |                                  |                                     |                                                                             |
