# -*- coding: utf-8 -*-
"""
@Project : VientianeArena
@File    : path
@Author  : YL_top01
@Date    : 2025/8/25 16:04
"""



# Built-in modules
# (无内置模块)

# Third-party modules
# (无第三方依赖)

# Local modules
from yltop.recording.errors.base import BaseCustomError
from yltop.recording.errors.errors import ErrorMessage


class InvalidPathError(BaseCustomError, Exception):
    """基础路径错误"""

    def __init__(self, obj, detail=True, location=True):
        msg = self._generate_message(
            obj,
            ErrorMessage.path_error(),
            detail,
            location
        )
        super().__init__(obj, msg)


class PathFormatError(InvalidPathError):
    """路径格式非法"""

    def __init__(self, path: str):
        message = ErrorMessage.path_format_error(path)
        super().__init__(path, message)


class PathNotExistsError(InvalidPathError):
    """路径不存在"""

    def __init__(self, path: str):
        message = ErrorMessage.path_not_exists_error(path)
        super().__init__(path, message)

