# -*- coding: utf-8 -*-
"""
@Project : yltop_project
@File    : test_limit
@Author  : YL_top01
@Date    : 2025/10/5 19:54
"""

# Built-in modules
# (无内置模块)

# Third-party modules
# (无第三方依赖)

# Local modules
# (无本地依赖)

# 假设你把上面的代码保存为了 limit.py

from src.yltop.umodules.limit import LimitedPath, LimitedTime, TimeFormat

# --- 1. 使用 LimitedPath ---

# 创建一个路径对象
path1 = LimitedPath("/home/user/project/main.py")

print(f"路径: {path1}")
print(f"路径层级数: {path1.layer_count}")
print(f"路径根目录: {path1.root}")
print(f"文件名: {path1.name}")
print(f"父目录: {path1.parent}")
print(f"父目录的层级数: {path1.parent.layer_count}")
print(f"路径是否存在: {path1.exists()}")

print("-" * 20)

path2 = LimitedPath("data/config.yaml")
print(f"相对路径: {path2}")
print(f"它的绝对路径: {path2._path_obj.resolve()}") # 直接访问内部的 Path 对象
print(f"它的层级数: {path2.layer_count}")


# --- 2. 使用 LimitedTime ---

# 创建一个时间对象
try:
    time1 = LimitedTime("2025-10-05")
    print(f"\n原始时间字符串: {time1}")
    print(f"年: {time1.year}, 月: {time1.month}, 日: {time1.day}")

    # 格式化为不同样式
    print(f"格式化 (DOT_STYLE): {time1.format(TimeFormat.DOT_STYLE)}")
    print(f"格式化 (SLASH): {time1.format(TimeFormat.SLASH)}")
    print(f"格式化 (EMPTY_FORMATTING): {time1.format(TimeFormat.EMPTY_FORMATTING)}")

    # 尝试一个无效的格式
    invalid_time = LimitedTime("2025/13/05") # 月份 13 是无效的
except ValueError as e:
    print(f"\n捕获到错误: {e}")