# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-08-15 10:45
from __future__ import unicode_literals
from leprikon.models.activities import ActivityModel, ActivityType

from django.db import migrations, models
import django.db.models.deletion
import djangocms_text_ckeditor.fields
import leprikon.models.fields
import leprikon.models.startend
import leprikon.models.times


def migrate_journals(apps, schema_editor):
    Journal = apps.get_model("leprikon", "Journal")
    JournalEntry = apps.get_model("leprikon", "JournalEntry")
    Subject = apps.get_model("leprikon", "Subject")
    SubjectRegistrationParticipant = apps.get_model("leprikon", "SubjectRegistrationParticipant")

    for subject in Subject.objects.filter(
        id__in=JournalEntry.objects.values_list("subject_id", flat=True)
    ).select_related("subject_type"):
        journal = Journal.objects.create(
            subject=subject,
            risks=subject.risks,
            plan=subject.plan,
            evaluation=subject.evaluation,
        )
        if subject.subject_type.subject_type == ActivityModel.COURSE:
            journal.participants.set(
                SubjectRegistrationParticipant.objects.filter(
                    registration__approved__isnull=False,
                    registration__courseregistration__course_history__course_id=subject.id,
                )
            )
        else:
            journal.participants.set(
                SubjectRegistrationParticipant.objects.filter(
                    registration__approved__isnull=False,
                    registration__subject=subject,
                )
            )
        journal.leaders.set(subject.leaders.all())
        subject.journal_entries.update(journal=journal)


class Migration(migrations.Migration):

    dependencies = [
        ("leprikon", "0062_refund_offers"),
    ]

    operations = [
        migrations.CreateModel(
            name="Journal",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(blank=True, default="", max_length=150, verbose_name="journal name")),
                ("risks", djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name="risks")),
                ("plan", djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name="plan")),
                ("evaluation", djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name="evaluation")),
                (
                    "participants",
                    models.ManyToManyField(
                        blank=True,
                        related_name="journals",
                        to="leprikon.SubjectRegistrationParticipant",
                        verbose_name="participants",
                    ),
                ),
                (
                    "leaders",
                    models.ManyToManyField(
                        blank=True, related_name="journals", to="leprikon.Leader", verbose_name="leaders"
                    ),
                ),
            ],
            options={
                "verbose_name": "journal",
                "verbose_name_plural": "journal",
            },
            bases=(leprikon.models.times.TimesMixin, models.Model),
        ),
        migrations.CreateModel(
            name="JournalTime",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "day_of_week",
                    models.IntegerField(
                        choices=[
                            (1, "Monday"),
                            (2, "Tuesday"),
                            (3, "Wednesday"),
                            (4, "Thursday"),
                            (5, "Friday"),
                            (6, "Saturday"),
                            (7, "Sunday"),
                        ],
                        verbose_name="day of week",
                    ),
                ),
                ("start", models.TimeField(blank=True, null=True, verbose_name="start time")),
                ("end", models.TimeField(blank=True, null=True, verbose_name="end time")),
                (
                    "journal",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="times",
                        to="leprikon.Journal",
                        verbose_name="journal",
                    ),
                ),
            ],
            options={
                "verbose_name": "time",
                "verbose_name_plural": "times",
                "ordering": ("day_of_week", "start"),
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.CreateModel(
            name="SubjectTime",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "day_of_week",
                    models.IntegerField(
                        choices=[
                            (1, "Monday"),
                            (2, "Tuesday"),
                            (3, "Wednesday"),
                            (4, "Thursday"),
                            (5, "Friday"),
                            (6, "Saturday"),
                            (7, "Sunday"),
                        ],
                        verbose_name="day of week",
                    ),
                ),
                ("start", models.TimeField(blank=True, null=True, verbose_name="start time")),
                ("end", models.TimeField(blank=True, null=True, verbose_name="end time")),
            ],
            options={
                "verbose_name": "time",
                "verbose_name_plural": "times",
                "ordering": ("day_of_week", "start"),
            },
            bases=(leprikon.models.startend.StartEndMixin, models.Model),
        ),
        migrations.AddField(
            model_name="subjecttime",
            name="subject",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="times",
                to="leprikon.Subject",
                verbose_name="course",
            ),
        ),
        migrations.AddField(
            model_name="journal",
            name="subject",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="journals",
                to="leprikon.Subject",
                verbose_name="subject",
            ),
        ),
        migrations.AddField(
            model_name="journalentry",
            name="journal",
            field=models.ForeignKey(
                default=None,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="journal_entries",
                to="leprikon.Journal",
                verbose_name="journal",
            ),
            preserve_default=False,
        ),
        migrations.RunSQL(
            sql="INSERT INTO leprikon_subjecttime SELECT * FROM leprikon_coursetime;",
            reverse_sql="INSERT INTO leprikon_coursetime SELECT * FROM leprikon_subjecttime;",
        ),
        migrations.RemoveField(
            model_name="coursetime",
            name="course",
        ),
        migrations.DeleteModel(
            name="CourseTime",
        ),
        migrations.RunPython(migrate_journals),
    ]
