# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2022-01-04 16:35
from __future__ import unicode_literals

from django.db import migrations
import django.db.models.deletion
import leprikon.models.fields


def add_subject_type_page(apps, schema_editor):
    SubjectType = apps.get_model("leprikon", "SubjectType")
    Page = apps.get_model("cms", "Page")

    for subject_type in SubjectType.objects.all():
        subject_type.page = Page.objects.filter(
            application_urls="LeprikonSubjectTypeApp",
            application_namespace=subject_type.slug,
            publisher_is_draft=True,
        ).first()
        if subject_type.page:
            subject_type.save()


class Migration(migrations.Migration):

    dependencies = [
        ("cms", "0022_auto_20180620_1551"),
        ("leprikon", "0064_journals_cleanup"),
    ]

    operations = [
        migrations.AddField(
            model_name="subjecttype",
            name="page",
            field=leprikon.models.fields.UniquePageField(
                blank=True,
                help_text="Select page, where the activities will be listed. New activity type requires a new page. If You assign an existing page, the current content of the page will be replaced with the new list of activities.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="leprikon_activity_type",
                to="cms.Page",
                verbose_name="page",
            ),
            preserve_default=False,
        ),
        migrations.RunPython(add_subject_type_page),
    ]
