# Generated by Django 3.2.20 on 2023-07-13 14:29

from django.db import migrations, models
import django.db.models.deletion


def copy_course_variant_values(apps, schema_editor):
    CourseVariant = apps.get_model("leprikon", "CourseVariant")

    for cv in CourseVariant.objects.all():
        cv.school_year_division_id = cv.school_year_division_old_id
        cv.allow_period_selection = cv.allow_period_selection_old
        cv.save()


class Migration(migrations.Migration):
    dependencies = [
        ("leprikon", "0077_place_description"),
    ]

    operations = [
        migrations.RenameField(
            model_name="coursevariant",
            old_name="allow_period_selection",
            new_name="allow_period_selection_old",
        ),
        migrations.RenameField(
            model_name="coursevariant",
            old_name="school_year_division",
            new_name="school_year_division_old",
        ),
        migrations.AddField(
            model_name="subjectvariant",
            name="allow_period_selection",
            field=models.BooleanField(
                default=False,
                help_text="allow user to choose school year periods on registration form",
                verbose_name="allow period selection",
            ),
        ),
        migrations.AddField(
            model_name="subjectvariant",
            name="school_year_division",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="variants",
                to="leprikon.schoolyeardivision",
                verbose_name="school year division",
            ),
        ),
        migrations.RunPython(copy_course_variant_values),
        migrations.DeleteModel(name="CourseVariant"),
    ]
