# Generated by Django 3.2.20 on 2023-09-06 14:30

from django.db import migrations, models


def copy_min_due_date_days(apps, schema_editor):
    Event = apps.get_model("leprikon", "Event")
    for event in Event.objects.iterator():
        event.min_due_date_days = event.min_due_date_days_old
        event.save()


class Migration(migrations.Migration):
    dependencies = [
        ("leprikon", "0080_delete_courseregistrationhistory"),
    ]

    operations = [
        migrations.RenameField(
            model_name="subject",
            old_name="min_due_date_days",
            new_name="min_due_date_days_old",
        ),
        migrations.AddField(
            model_name="event",
            name="min_due_date_days",
            field=models.PositiveIntegerField(default=3, verbose_name="minimal number of days to due date"),
        ),
        migrations.AddField(
            model_name="orderable",
            name="min_due_date_days",
            field=models.PositiveIntegerField(default=3, verbose_name="minimal number of days to due date"),
        ),
        migrations.AddField(
            model_name="schoolyearperiod",
            name="min_due_date_days",
            field=models.PositiveIntegerField(default=14, verbose_name="minimal number of days to due date"),
        ),
        migrations.RunPython(copy_min_due_date_days),
        migrations.RemoveField(
            model_name="subject",
            name="min_due_date_days_old",
        ),
    ]
