# Generated by Django 3.2.25 on 2025-07-28 17:43

from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("leprikon", "0090_alter_registration_calendar_event"),
    ]

    operations = [
        migrations.AddField(
            model_name="calendarevent",
            name="blocks_all_resources",
            field=models.BooleanField(
                default=False,
                help_text="If checked, the event will block all resources, not just the selected ones.",
                verbose_name="blocks all resources",
            ),
        ),
        migrations.CreateModel(
            name="CalendarExport",
            fields=[
                ("id", models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ("name", models.CharField(max_length=255, verbose_name="name")),
                ("export_past_days", models.PositiveSmallIntegerField(default=30, verbose_name="export past days")),
                (
                    "limit_events_count",
                    models.PositiveSmallIntegerField(
                        default=1000,
                        help_text="Limit the number of events to export. Huge exports may fail to import to Your calendar.",
                        verbose_name="limit events count",
                    ),
                ),
                (
                    "resources",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Select resources to export calendar events for. Leave empty to export events for all resources.",
                        related_name="calendar_exports",
                        to="leprikon.Resource",
                        verbose_name="resources",
                    ),
                ),
            ],
            options={
                "verbose_name": "calendar export",
                "verbose_name_plural": "calendar exports",
            },
        ),
    ]
