# Generated by Django 3.2.25 on 2025-08-28 08:38

from datetime import datetime, time, timedelta
from django.db import migrations, models
import django.utils.timezone


def set_effective_times(apps, schema_editor):
    CalendarEvent = apps.get_model("leprikon", "CalendarEvent")
    for event in CalendarEvent.objects.all():
        if event.start_time is None or event.end_time is None:
            event.start_time = None
            event.end_time = None
            event.effective_start = django.utils.timezone.make_aware(
                datetime.combine(event.start_date, time(0)),
            )
            event.effective_end = django.utils.timezone.make_aware(
                datetime.combine(event.end_date, time(0)) + timedelta(days=1),
            )
        else:
            event.effective_start = django.utils.timezone.make_aware(
                datetime.combine(event.start_date, event.start_time) - event.preparation_time,
            )
            event.effective_end = django.utils.timezone.make_aware(
                datetime.combine(event.end_date, event.end_time) + event.recovery_time,
            )
        event.save()


class Migration(migrations.Migration):

    dependencies = [
        ("leprikon", "0091_calendar_updates"),
    ]

    operations = [
        migrations.AddField(
            model_name="calendarevent",
            name="effective_end",
            field=models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name="effective end"),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="calendarevent",
            name="effective_start",
            field=models.DateTimeField(
                default=django.utils.timezone.now, editable=False, verbose_name="effective start"
            ),
            preserve_default=False,
        ),
        migrations.RunPython(set_effective_times, reverse_code=migrations.RunPython.noop),
    ]
