from django.utils.translation import gettext_lazy as _

from ..models.donation import Donation
from .activities import PDFMixin
from .generic import DetailView, ListView


class DonationViewMixin:
    model = Donation

    def get_queryset(self):
        return super().get_queryset().filter(donor=self.request.user)


class DonationListView(DonationViewMixin, ListView):
    template_name = "leprikon/donations.html"
    paginate_by = 20

    def get_title(self):
        return _("Donations")


class DonationPdfView(DonationViewMixin, PDFMixin, DetailView):
    pass
