"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.aws_account_managed import AWSAccountManaged
from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment AWSAccountManaged on AWSAccount_v1 {
  name
  uid
  alias
  premiumSupport
  organization {
    ou
    tags
  }
  quotaLimits {
    name
    quotas {
      serviceCode
      quotaCode
      value
    }
  }
  securityContact {
    name
    title
    email
    phoneNumber
  }
  supportedDeploymentRegions
}

fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query AWSAccountManagerAccounts {
  accounts: awsaccounts_v1 {
    ...AWSAccountManaged
    resourcesDefaultRegion
    automationToken {
      ...VaultSecret
    }
    disable {
      integrations
    }
    automationRole {
      awsAccountManager
    }
    # for the requests via "payer account"
    account_requests {
      path
      name
      description
      accountOwner {
        name
        email
      }
      organization {
        ou
        tags
        payerAccount {
          path
        }
      }
      quotaLimits {
        path
      }
      resourcesDefaultRegion
      supportedDeploymentRegions
      uid
      additionalFeatures
      accountFileTargetPath
    }
    organization_accounts {
      ...AWSAccountManaged
    }
    organizationAccountTags
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class AWSAutomationRoleV1(ConfiguredBaseModel):
    aws_account_manager: Optional[str] = Field(..., alias="awsAccountManager")


class OwnerV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    email: str = Field(..., alias="email")


class AWSOrganizationV1_AWSAccountV1(ConfiguredBaseModel):
    path: str = Field(..., alias="path")


class AWSOrganizationV1(ConfiguredBaseModel):
    ou: str = Field(..., alias="ou")
    tags: Json = Field(..., alias="tags")
    payer_account: AWSOrganizationV1_AWSAccountV1 = Field(..., alias="payerAccount")


class AWSQuotaLimitsV1(ConfiguredBaseModel):
    path: str = Field(..., alias="path")


class AWSAccountRequestV1(ConfiguredBaseModel):
    path: str = Field(..., alias="path")
    name: str = Field(..., alias="name")
    description: str = Field(..., alias="description")
    account_owner: OwnerV1 = Field(..., alias="accountOwner")
    organization: AWSOrganizationV1 = Field(..., alias="organization")
    quota_limits: Optional[list[AWSQuotaLimitsV1]] = Field(..., alias="quotaLimits")
    resources_default_region: str = Field(..., alias="resourcesDefaultRegion")
    supported_deployment_regions: Optional[list[str]] = Field(..., alias="supportedDeploymentRegions")
    uid: Optional[str] = Field(..., alias="uid")
    additional_features: Optional[Json] = Field(..., alias="additionalFeatures")
    account_file_target_path: Optional[str] = Field(..., alias="accountFileTargetPath")


class AWSAccountV1(AWSAccountManaged):
    resources_default_region: str = Field(..., alias="resourcesDefaultRegion")
    automation_token: VaultSecret = Field(..., alias="automationToken")
    disable: Optional[DisableClusterAutomationsV1] = Field(..., alias="disable")
    automation_role: Optional[AWSAutomationRoleV1] = Field(..., alias="automationRole")
    account_requests: Optional[list[AWSAccountRequestV1]] = Field(..., alias="account_requests")
    organization_accounts: Optional[list[AWSAccountManaged]] = Field(..., alias="organization_accounts")
    organization_account_tags: Optional[Json] = Field(..., alias="organizationAccountTags")


class AWSAccountManagerAccountsQueryData(ConfiguredBaseModel):
    accounts: Optional[list[AWSAccountV1]] = Field(..., alias="accounts")


def query(query_func: Callable, **kwargs: Any) -> AWSAccountManagerAccountsQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        AWSAccountManagerAccountsQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return AWSAccountManagerAccountsQueryData(**raw_data)
