"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.jumphost_common_fields import CommonJumphostFields
from reconcile.gql_definitions.fragments.resource_values import ResourceValues
from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment CommonJumphostFields on ClusterJumpHost_v1 {
  hostname
  knownHosts
  user
  port
  remotePort
  identity {
    ...VaultSecret
  }
}

fragment ResourceValues on ResourceValues_v1 {
  cpu
  memory
}

fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query Namespaces {
  namespaces: namespaces_v1 {
    path
    name
    delete
    labels
    clusterAdmin
    managedRoles
    app {
      path
      name
      serviceOwners {
        name
        email
      }
    }
    openshiftResources {
      provider
      ... on NamespaceOpenshiftResourceResource_v1 {
        path {
          content
        }
      }
      ... on NamespaceOpenshiftResourceResourceTemplate_v1 {
        path {
          content
        }
      }
      ... on NamespaceOpenshiftResourceRoute_v1 {
        path {
          content
        }
      }
      ... on NamespaceOpenshiftResourcePrometheusRule_v1 {
        path {
          content
        }
      }
    }
    managedExternalResources
    externalResources {
      provider
      provisioner {
        name
      }
      ... on NamespaceTerraformProviderResourceAWS_v1 {
        resources {
          provider
          ... on NamespaceTerraformResourceRDS_v1 {
            identifier
            output_resource_name
            defaults
            replica_source
          }
          ... on NamespaceTerraformResourceECR_v1 {
            region
            identifier
            output_resource_name
            mirror {
              url
              pullCredentials {
                ...VaultSecret
              }
              tags
              tagsExclude
            }
          }
        }
      }
    }
    cluster {
      name
      serverUrl
      insecureSkipTLSVerify
      jumpHost {
        ...CommonJumphostFields
      }
      automationToken {
        ...VaultSecret
      }
      clusterAdminAutomationToken {
        ...VaultSecret
      }
      internal
      disable {
        integrations
      }
    }
    managedResourceNames {
      resource
      resourceNames
    }
    limitRanges {
      name
      limits {
        default {
          ...ResourceValues
        }
        defaultRequest {
          ...ResourceValues
        }
        max {
          ...ResourceValues
        }
        maxLimitRequestRatio {
          ...ResourceValues
        }
        min {
          ...ResourceValues
        }
        type
      }
    }
    quota {
      quotas {
        name
        resources {
          limits {
            ...ResourceValues
          }
          requests {
            ...ResourceValues
          }
          pods
        }
        scopes
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class OwnerV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    email: str = Field(..., alias="email")


class AppV1(ConfiguredBaseModel):
    path: str = Field(..., alias="path")
    name: str = Field(..., alias="name")
    service_owners: Optional[list[OwnerV1]] = Field(..., alias="serviceOwners")


class NamespaceOpenshiftResourceV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class ResourceV1(ConfiguredBaseModel):
    content: str = Field(..., alias="content")


class NamespaceOpenshiftResourceResourceV1(NamespaceOpenshiftResourceV1):
    path: Optional[ResourceV1] = Field(..., alias="path")


class NamespaceOpenshiftResourceResourceTemplateV1_ResourceV1(ConfiguredBaseModel):
    content: str = Field(..., alias="content")


class NamespaceOpenshiftResourceResourceTemplateV1(NamespaceOpenshiftResourceV1):
    path: Optional[NamespaceOpenshiftResourceResourceTemplateV1_ResourceV1] = Field(..., alias="path")


class NamespaceOpenshiftResourceRouteV1_ResourceV1(ConfiguredBaseModel):
    content: str = Field(..., alias="content")


class NamespaceOpenshiftResourceRouteV1(NamespaceOpenshiftResourceV1):
    path: Optional[NamespaceOpenshiftResourceRouteV1_ResourceV1] = Field(..., alias="path")


class NamespaceOpenshiftResourcePrometheusRuleV1_ResourceV1(ConfiguredBaseModel):
    content: str = Field(..., alias="content")


class NamespaceOpenshiftResourcePrometheusRuleV1(NamespaceOpenshiftResourceV1):
    path: Optional[NamespaceOpenshiftResourcePrometheusRuleV1_ResourceV1] = Field(..., alias="path")


class ExternalResourcesProvisionerV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class NamespaceExternalResourceV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")
    provisioner: ExternalResourcesProvisionerV1 = Field(..., alias="provisioner")


class NamespaceTerraformResourceAWSV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class NamespaceTerraformResourceRDSV1(NamespaceTerraformResourceAWSV1):
    identifier: str = Field(..., alias="identifier")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    defaults: str = Field(..., alias="defaults")
    replica_source: Optional[str] = Field(..., alias="replica_source")


class ContainerImageMirrorV1(ConfiguredBaseModel):
    url: str = Field(..., alias="url")
    pull_credentials: Optional[VaultSecret] = Field(..., alias="pullCredentials")
    tags: Optional[list[str]] = Field(..., alias="tags")
    tags_exclude: Optional[list[str]] = Field(..., alias="tagsExclude")


class NamespaceTerraformResourceECRV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    mirror: Optional[ContainerImageMirrorV1] = Field(..., alias="mirror")


class NamespaceTerraformProviderResourceAWSV1(NamespaceExternalResourceV1):
    resources: list[Union[NamespaceTerraformResourceRDSV1, NamespaceTerraformResourceECRV1, NamespaceTerraformResourceAWSV1]] = Field(..., alias="resources")


class DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    server_url: str = Field(..., alias="serverUrl")
    insecure_skip_tls_verify: Optional[bool] = Field(..., alias="insecureSkipTLSVerify")
    jump_host: Optional[CommonJumphostFields] = Field(..., alias="jumpHost")
    automation_token: Optional[VaultSecret] = Field(..., alias="automationToken")
    cluster_admin_automation_token: Optional[VaultSecret] = Field(..., alias="clusterAdminAutomationToken")
    internal: Optional[bool] = Field(..., alias="internal")
    disable: Optional[DisableClusterAutomationsV1] = Field(..., alias="disable")


class ManagedResourceNamesV1(ConfiguredBaseModel):
    resource: str = Field(..., alias="resource")
    resource_names: list[str] = Field(..., alias="resourceNames")


class LimitRangeItemV1(ConfiguredBaseModel):
    default: Optional[ResourceValues] = Field(..., alias="default")
    default_request: Optional[ResourceValues] = Field(..., alias="defaultRequest")
    max: Optional[ResourceValues] = Field(..., alias="max")
    max_limit_request_ratio: Optional[ResourceValues] = Field(..., alias="maxLimitRequestRatio")
    min: Optional[ResourceValues] = Field(..., alias="min")
    q_type: Optional[str] = Field(..., alias="type")


class LimitRangeV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    limits: list[LimitRangeItemV1] = Field(..., alias="limits")


class ResourceQuotaItemResourcesV1(ConfiguredBaseModel):
    limits: Optional[ResourceValues] = Field(..., alias="limits")
    requests: Optional[ResourceValues] = Field(..., alias="requests")
    pods: Optional[int] = Field(..., alias="pods")


class ResourceQuotaItemV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    resources: ResourceQuotaItemResourcesV1 = Field(..., alias="resources")
    scopes: Optional[list[str]] = Field(..., alias="scopes")


class ResourceQuotaV1(ConfiguredBaseModel):
    quotas: list[ResourceQuotaItemV1] = Field(..., alias="quotas")


class NamespaceV1(ConfiguredBaseModel):
    path: str = Field(..., alias="path")
    name: str = Field(..., alias="name")
    delete: Optional[bool] = Field(..., alias="delete")
    labels: Optional[Json] = Field(..., alias="labels")
    cluster_admin: Optional[bool] = Field(..., alias="clusterAdmin")
    managed_roles: Optional[bool] = Field(..., alias="managedRoles")
    app: AppV1 = Field(..., alias="app")
    openshift_resources: Optional[list[Union[NamespaceOpenshiftResourceResourceV1, NamespaceOpenshiftResourceResourceTemplateV1, NamespaceOpenshiftResourceRouteV1, NamespaceOpenshiftResourcePrometheusRuleV1, NamespaceOpenshiftResourceV1]]] = Field(..., alias="openshiftResources")
    managed_external_resources: Optional[bool] = Field(..., alias="managedExternalResources")
    external_resources: Optional[list[Union[NamespaceTerraformProviderResourceAWSV1, NamespaceExternalResourceV1]]] = Field(..., alias="externalResources")
    cluster: ClusterV1 = Field(..., alias="cluster")
    managed_resource_names: Optional[list[ManagedResourceNamesV1]] = Field(..., alias="managedResourceNames")
    limit_ranges: Optional[LimitRangeV1] = Field(..., alias="limitRanges")
    quota: Optional[ResourceQuotaV1] = Field(..., alias="quota")


class NamespacesQueryData(ConfiguredBaseModel):
    namespaces: Optional[list[NamespaceV1]] = Field(..., alias="namespaces")


def query(query_func: Callable, **kwargs: Any) -> NamespacesQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        NamespacesQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return NamespacesQueryData(**raw_data)
