# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppsecAapSelectedHostnamesArgs', 'AppsecAapSelectedHostnames']

@pulumi.input_type
class AppsecAapSelectedHostnamesArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.int],
                 security_policy_id: pulumi.Input[_builtins.str],
                 evaluated_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protected_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AppsecAapSelectedHostnames resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] evaluated_hosts: List of hostnames to be evaluated
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protected_hosts: List of hostnames to be protected
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if evaluated_hosts is not None:
            pulumi.set(__self__, "evaluated_hosts", evaluated_hosts)
        if protected_hosts is not None:
            pulumi.set(__self__, "protected_hosts", protected_hosts)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="evaluatedHosts")
    def evaluated_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of hostnames to be evaluated
        """
        return pulumi.get(self, "evaluated_hosts")

    @evaluated_hosts.setter
    def evaluated_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "evaluated_hosts", value)

    @_builtins.property
    @pulumi.getter(name="protectedHosts")
    def protected_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of hostnames to be protected
        """
        return pulumi.get(self, "protected_hosts")

    @protected_hosts.setter
    def protected_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protected_hosts", value)


@pulumi.input_type
class _AppsecAapSelectedHostnamesState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 evaluated_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protected_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppsecAapSelectedHostnames resources.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] evaluated_hosts: List of hostnames to be evaluated
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protected_hosts: List of hostnames to be protected
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if evaluated_hosts is not None:
            pulumi.set(__self__, "evaluated_hosts", evaluated_hosts)
        if protected_hosts is not None:
            pulumi.set(__self__, "protected_hosts", protected_hosts)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="evaluatedHosts")
    def evaluated_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of hostnames to be evaluated
        """
        return pulumi.get(self, "evaluated_hosts")

    @evaluated_hosts.setter
    def evaluated_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "evaluated_hosts", value)

    @_builtins.property
    @pulumi.getter(name="protectedHosts")
    def protected_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of hostnames to be protected
        """
        return pulumi.get(self, "protected_hosts")

    @protected_hosts.setter
    def protected_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protected_hosts", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.type_token("akamai:index/appsecAapSelectedHostnames:AppsecAapSelectedHostnames")
class AppsecAapSelectedHostnames(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 evaluated_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protected_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a AppsecAapSelectedHostnames resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] evaluated_hosts: List of hostnames to be evaluated
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protected_hosts: List of hostnames to be protected
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppsecAapSelectedHostnamesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppsecAapSelectedHostnames resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppsecAapSelectedHostnamesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppsecAapSelectedHostnamesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 evaluated_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protected_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppsecAapSelectedHostnamesArgs.__new__(AppsecAapSelectedHostnamesArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["evaluated_hosts"] = evaluated_hosts
            __props__.__dict__["protected_hosts"] = protected_hosts
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
        super(AppsecAapSelectedHostnames, __self__).__init__(
            'akamai:index/appsecAapSelectedHostnames:AppsecAapSelectedHostnames',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            evaluated_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            protected_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppsecAapSelectedHostnames':
        """
        Get an existing AppsecAapSelectedHostnames resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] evaluated_hosts: List of hostnames to be evaluated
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protected_hosts: List of hostnames to be protected
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppsecAapSelectedHostnamesState.__new__(_AppsecAapSelectedHostnamesState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["evaluated_hosts"] = evaluated_hosts
        __props__.__dict__["protected_hosts"] = protected_hosts
        __props__.__dict__["security_policy_id"] = security_policy_id
        return AppsecAapSelectedHostnames(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="evaluatedHosts")
    def evaluated_hosts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of hostnames to be evaluated
        """
        return pulumi.get(self, "evaluated_hosts")

    @_builtins.property
    @pulumi.getter(name="protectedHosts")
    def protected_hosts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of hostnames to be protected
        """
        return pulumi.get(self, "protected_hosts")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

