# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppsecAdvancedSettingsRequestBodyArgs', 'AppsecAdvancedSettingsRequestBody']

@pulumi.input_type
class AppsecAdvancedSettingsRequestBodyArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.int],
                 request_body_inspection_limit: pulumi.Input[_builtins.str],
                 request_body_inspection_limit_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppsecAdvancedSettingsRequestBody resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] request_body_inspection_limit: Request body inspection size limit in KB allowed values are 'default', 8, 16, 32
        :param pulumi.Input[_builtins.bool] request_body_inspection_limit_override: Indicates if the Request body inspection size should be overridden at policy
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "request_body_inspection_limit", request_body_inspection_limit)
        if request_body_inspection_limit_override is not None:
            pulumi.set(__self__, "request_body_inspection_limit_override", request_body_inspection_limit_override)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="requestBodyInspectionLimit")
    def request_body_inspection_limit(self) -> pulumi.Input[_builtins.str]:
        """
        Request body inspection size limit in KB allowed values are 'default', 8, 16, 32
        """
        return pulumi.get(self, "request_body_inspection_limit")

    @request_body_inspection_limit.setter
    def request_body_inspection_limit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "request_body_inspection_limit", value)

    @_builtins.property
    @pulumi.getter(name="requestBodyInspectionLimitOverride")
    def request_body_inspection_limit_override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the Request body inspection size should be overridden at policy
        """
        return pulumi.get(self, "request_body_inspection_limit_override")

    @request_body_inspection_limit_override.setter
    def request_body_inspection_limit_override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "request_body_inspection_limit_override", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.input_type
class _AppsecAdvancedSettingsRequestBodyState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 request_body_inspection_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 request_body_inspection_limit_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppsecAdvancedSettingsRequestBody resources.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] request_body_inspection_limit: Request body inspection size limit in KB allowed values are 'default', 8, 16, 32
        :param pulumi.Input[_builtins.bool] request_body_inspection_limit_override: Indicates if the Request body inspection size should be overridden at policy
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if request_body_inspection_limit is not None:
            pulumi.set(__self__, "request_body_inspection_limit", request_body_inspection_limit)
        if request_body_inspection_limit_override is not None:
            pulumi.set(__self__, "request_body_inspection_limit_override", request_body_inspection_limit_override)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="requestBodyInspectionLimit")
    def request_body_inspection_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Request body inspection size limit in KB allowed values are 'default', 8, 16, 32
        """
        return pulumi.get(self, "request_body_inspection_limit")

    @request_body_inspection_limit.setter
    def request_body_inspection_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_body_inspection_limit", value)

    @_builtins.property
    @pulumi.getter(name="requestBodyInspectionLimitOverride")
    def request_body_inspection_limit_override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the Request body inspection size should be overridden at policy
        """
        return pulumi.get(self, "request_body_inspection_limit_override")

    @request_body_inspection_limit_override.setter
    def request_body_inspection_limit_override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "request_body_inspection_limit_override", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.type_token("akamai:index/appsecAdvancedSettingsRequestBody:AppsecAdvancedSettingsRequestBody")
class AppsecAdvancedSettingsRequestBody(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 request_body_inspection_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 request_body_inspection_limit_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a AppsecAdvancedSettingsRequestBody resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] request_body_inspection_limit: Request body inspection size limit in KB allowed values are 'default', 8, 16, 32
        :param pulumi.Input[_builtins.bool] request_body_inspection_limit_override: Indicates if the Request body inspection size should be overridden at policy
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppsecAdvancedSettingsRequestBodyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppsecAdvancedSettingsRequestBody resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppsecAdvancedSettingsRequestBodyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppsecAdvancedSettingsRequestBodyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 request_body_inspection_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 request_body_inspection_limit_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppsecAdvancedSettingsRequestBodyArgs.__new__(AppsecAdvancedSettingsRequestBodyArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if request_body_inspection_limit is None and not opts.urn:
                raise TypeError("Missing required property 'request_body_inspection_limit'")
            __props__.__dict__["request_body_inspection_limit"] = request_body_inspection_limit
            __props__.__dict__["request_body_inspection_limit_override"] = request_body_inspection_limit_override
            __props__.__dict__["security_policy_id"] = security_policy_id
        super(AppsecAdvancedSettingsRequestBody, __self__).__init__(
            'akamai:index/appsecAdvancedSettingsRequestBody:AppsecAdvancedSettingsRequestBody',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            request_body_inspection_limit: Optional[pulumi.Input[_builtins.str]] = None,
            request_body_inspection_limit_override: Optional[pulumi.Input[_builtins.bool]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppsecAdvancedSettingsRequestBody':
        """
        Get an existing AppsecAdvancedSettingsRequestBody resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] request_body_inspection_limit: Request body inspection size limit in KB allowed values are 'default', 8, 16, 32
        :param pulumi.Input[_builtins.bool] request_body_inspection_limit_override: Indicates if the Request body inspection size should be overridden at policy
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppsecAdvancedSettingsRequestBodyState.__new__(_AppsecAdvancedSettingsRequestBodyState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["request_body_inspection_limit"] = request_body_inspection_limit
        __props__.__dict__["request_body_inspection_limit_override"] = request_body_inspection_limit_override
        __props__.__dict__["security_policy_id"] = security_policy_id
        return AppsecAdvancedSettingsRequestBody(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="requestBodyInspectionLimit")
    def request_body_inspection_limit(self) -> pulumi.Output[_builtins.str]:
        """
        Request body inspection size limit in KB allowed values are 'default', 8, 16, 32
        """
        return pulumi.get(self, "request_body_inspection_limit")

    @_builtins.property
    @pulumi.getter(name="requestBodyInspectionLimitOverride")
    def request_body_inspection_limit_override(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the Request body inspection size should be overridden at policy
        """
        return pulumi.get(self, "request_body_inspection_limit_override")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

