# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClientlistListArgs', 'ClientlistList']

@pulumi.input_type
class ClientlistListArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['ClientlistListItemArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ClientlistList resource.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID for which client list is assigned.
        :param pulumi.Input[_builtins.int] group_id: Group ID for which client list is assigned.
        :param pulumi.Input[_builtins.str] type: The type of the client list. Valid types: [IP GEO ASN TLS_FINGERPRINT FILE_HASH]
        :param pulumi.Input[Sequence[pulumi.Input['ClientlistListItemArgs']]] items: Set of items containing item information.
        :param pulumi.Input[_builtins.str] name: The name of the client list.
        :param pulumi.Input[_builtins.str] notes: The client list notes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The client list tags.
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "type", type)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Contract ID for which client list is assigned.
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.int]:
        """
        Group ID for which client list is assigned.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the client list. Valid types: [IP GEO ASN TLS_FINGERPRINT FILE_HASH]
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClientlistListItemArgs']]]]:
        """
        Set of items containing item information.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClientlistListItemArgs']]]]):
        pulumi.set(self, "items", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the client list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client list notes.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The client list tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClientlistListState:
    def __init__(__self__, *,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['ClientlistListItemArgs']]]] = None,
                 items_count: Optional[pulumi.Input[_builtins.int]] = None,
                 list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ClientlistList resources.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID for which client list is assigned.
        :param pulumi.Input[_builtins.int] group_id: Group ID for which client list is assigned.
        :param pulumi.Input[Sequence[pulumi.Input['ClientlistListItemArgs']]] items: Set of items containing item information.
        :param pulumi.Input[_builtins.int] items_count: The number of items that a client list contains.
        :param pulumi.Input[_builtins.str] list_id: The ID of the client list.
        :param pulumi.Input[_builtins.str] name: The name of the client list.
        :param pulumi.Input[_builtins.str] notes: The client list notes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The client list tags.
        :param pulumi.Input[_builtins.str] type: The type of the client list. Valid types: [IP GEO ASN TLS_FINGERPRINT FILE_HASH]
        :param pulumi.Input[_builtins.int] version: The current version of the client list.
        """
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if items_count is not None:
            pulumi.set(__self__, "items_count", items_count)
        if list_id is not None:
            pulumi.set(__self__, "list_id", list_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contract ID for which client list is assigned.
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Group ID for which client list is assigned.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClientlistListItemArgs']]]]:
        """
        Set of items containing item information.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClientlistListItemArgs']]]]):
        pulumi.set(self, "items", value)

    @_builtins.property
    @pulumi.getter(name="itemsCount")
    def items_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of items that a client list contains.
        """
        return pulumi.get(self, "items_count")

    @items_count.setter
    def items_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "items_count", value)

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the client list.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "list_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the client list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client list notes.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The client list tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the client list. Valid types: [IP GEO ASN TLS_FINGERPRINT FILE_HASH]
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The current version of the client list.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("akamai:index/clientlistList:ClientlistList")
class ClientlistList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClientlistListItemArgs', 'ClientlistListItemArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ClientlistList resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID for which client list is assigned.
        :param pulumi.Input[_builtins.int] group_id: Group ID for which client list is assigned.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClientlistListItemArgs', 'ClientlistListItemArgsDict']]]] items: Set of items containing item information.
        :param pulumi.Input[_builtins.str] name: The name of the client list.
        :param pulumi.Input[_builtins.str] notes: The client list notes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The client list tags.
        :param pulumi.Input[_builtins.str] type: The type of the client list. Valid types: [IP GEO ASN TLS_FINGERPRINT FILE_HASH]
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientlistListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ClientlistList resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ClientlistListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientlistListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClientlistListItemArgs', 'ClientlistListItemArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientlistListArgs.__new__(ClientlistListArgs)

            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["items"] = items
            __props__.__dict__["name"] = name
            __props__.__dict__["notes"] = notes
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["items_count"] = None
            __props__.__dict__["list_id"] = None
            __props__.__dict__["version"] = None
        super(ClientlistList, __self__).__init__(
            'akamai:index/clientlistList:ClientlistList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.int]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClientlistListItemArgs', 'ClientlistListItemArgsDict']]]]] = None,
            items_count: Optional[pulumi.Input[_builtins.int]] = None,
            list_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notes: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'ClientlistList':
        """
        Get an existing ClientlistList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID for which client list is assigned.
        :param pulumi.Input[_builtins.int] group_id: Group ID for which client list is assigned.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClientlistListItemArgs', 'ClientlistListItemArgsDict']]]] items: Set of items containing item information.
        :param pulumi.Input[_builtins.int] items_count: The number of items that a client list contains.
        :param pulumi.Input[_builtins.str] list_id: The ID of the client list.
        :param pulumi.Input[_builtins.str] name: The name of the client list.
        :param pulumi.Input[_builtins.str] notes: The client list notes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The client list tags.
        :param pulumi.Input[_builtins.str] type: The type of the client list. Valid types: [IP GEO ASN TLS_FINGERPRINT FILE_HASH]
        :param pulumi.Input[_builtins.int] version: The current version of the client list.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientlistListState.__new__(_ClientlistListState)

        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["items"] = items
        __props__.__dict__["items_count"] = items_count
        __props__.__dict__["list_id"] = list_id
        __props__.__dict__["name"] = name
        __props__.__dict__["notes"] = notes
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return ClientlistList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Contract ID for which client list is assigned.
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.int]:
        """
        Group ID for which client list is assigned.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> pulumi.Output[Optional[Sequence['outputs.ClientlistListItem']]]:
        """
        Set of items containing item information.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="itemsCount")
    def items_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of items that a client list contains.
        """
        return pulumi.get(self, "items_count")

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the client list.
        """
        return pulumi.get(self, "list_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the client list.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The client list notes.
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The client list tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the client list. Valid types: [IP GEO ASN TLS_FINGERPRINT FILE_HASH]
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The current version of the client list.
        """
        return pulumi.get(self, "version")

