# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudAccessKeyArgs', 'CloudAccessKey']

@pulumi.input_type
class CloudAccessKeyArgs:
    def __init__(__self__, *,
                 access_key_name: pulumi.Input[_builtins.str],
                 authentication_method: pulumi.Input[_builtins.str],
                 contract_id: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.int],
                 network_configuration: pulumi.Input['CloudAccessKeyNetworkConfigurationArgs'],
                 credentials_a: Optional[pulumi.Input['CloudAccessKeyCredentialsAArgs']] = None,
                 credentials_b: Optional[pulumi.Input['CloudAccessKeyCredentialsBArgs']] = None,
                 timeouts: Optional[pulumi.Input['CloudAccessKeyTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a CloudAccessKey resource.
        :param pulumi.Input[_builtins.str] access_key_name: Name of the access key.
        :param pulumi.Input[_builtins.str] authentication_method: The type of cloud provider signing process used to authenticate API requests. Two options are available: "AWS4_HMAC_SHA256" or "GOOG4_HMAC_SHA256".
        :param pulumi.Input[_builtins.str] contract_id: The unique identifier for the contract assigned to the access key
        :param pulumi.Input[_builtins.int] group_id: The unique identifier assigned to the access control group assigned to the access key
        :param pulumi.Input['CloudAccessKeyNetworkConfigurationArgs'] network_configuration: The secure networks that you assigned the access key to during creation
        :param pulumi.Input['CloudAccessKeyCredentialsAArgs'] credentials_a: The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        :param pulumi.Input['CloudAccessKeyCredentialsBArgs'] credentials_b: The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        """
        pulumi.set(__self__, "access_key_name", access_key_name)
        pulumi.set(__self__, "authentication_method", authentication_method)
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "network_configuration", network_configuration)
        if credentials_a is not None:
            pulumi.set(__self__, "credentials_a", credentials_a)
        if credentials_b is not None:
            pulumi.set(__self__, "credentials_b", credentials_b)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="accessKeyName")
    def access_key_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the access key.
        """
        return pulumi.get(self, "access_key_name")

    @access_key_name.setter
    def access_key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_key_name", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Input[_builtins.str]:
        """
        The type of cloud provider signing process used to authenticate API requests. Two options are available: "AWS4_HMAC_SHA256" or "GOOG4_HMAC_SHA256".
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authentication_method", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier for the contract assigned to the access key
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.int]:
        """
        The unique identifier assigned to the access control group assigned to the access key
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Input['CloudAccessKeyNetworkConfigurationArgs']:
        """
        The secure networks that you assigned the access key to during creation
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: pulumi.Input['CloudAccessKeyNetworkConfigurationArgs']):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="credentialsA")
    def credentials_a(self) -> Optional[pulumi.Input['CloudAccessKeyCredentialsAArgs']]:
        """
        The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        """
        return pulumi.get(self, "credentials_a")

    @credentials_a.setter
    def credentials_a(self, value: Optional[pulumi.Input['CloudAccessKeyCredentialsAArgs']]):
        pulumi.set(self, "credentials_a", value)

    @_builtins.property
    @pulumi.getter(name="credentialsB")
    def credentials_b(self) -> Optional[pulumi.Input['CloudAccessKeyCredentialsBArgs']]:
        """
        The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        """
        return pulumi.get(self, "credentials_b")

    @credentials_b.setter
    def credentials_b(self, value: Optional[pulumi.Input['CloudAccessKeyCredentialsBArgs']]):
        pulumi.set(self, "credentials_b", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudAccessKeyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudAccessKeyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _CloudAccessKeyState:
    def __init__(__self__, *,
                 access_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_a: Optional[pulumi.Input['CloudAccessKeyCredentialsAArgs']] = None,
                 credentials_b: Optional[pulumi.Input['CloudAccessKeyCredentialsBArgs']] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input['CloudAccessKeyNetworkConfigurationArgs']] = None,
                 primary_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['CloudAccessKeyTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering CloudAccessKey resources.
        :param pulumi.Input[_builtins.str] access_key_name: Name of the access key.
        :param pulumi.Input[_builtins.int] access_key_uid: The unique identifier Akamai assigns to an access key.
        :param pulumi.Input[_builtins.str] authentication_method: The type of cloud provider signing process used to authenticate API requests. Two options are available: "AWS4_HMAC_SHA256" or "GOOG4_HMAC_SHA256".
        :param pulumi.Input[_builtins.str] contract_id: The unique identifier for the contract assigned to the access key
        :param pulumi.Input['CloudAccessKeyCredentialsAArgs'] credentials_a: The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        :param pulumi.Input['CloudAccessKeyCredentialsBArgs'] credentials_b: The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        :param pulumi.Input[_builtins.int] group_id: The unique identifier assigned to the access control group assigned to the access key
        :param pulumi.Input['CloudAccessKeyNetworkConfigurationArgs'] network_configuration: The secure networks that you assigned the access key to during creation
        :param pulumi.Input[_builtins.str] primary_guid: Value of `version_guid` field for credentials marked as primary
        """
        if access_key_name is not None:
            pulumi.set(__self__, "access_key_name", access_key_name)
        if access_key_uid is not None:
            pulumi.set(__self__, "access_key_uid", access_key_uid)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if credentials_a is not None:
            pulumi.set(__self__, "credentials_a", credentials_a)
        if credentials_b is not None:
            pulumi.set(__self__, "credentials_b", credentials_b)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if primary_guid is not None:
            pulumi.set(__self__, "primary_guid", primary_guid)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="accessKeyName")
    def access_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the access key.
        """
        return pulumi.get(self, "access_key_name")

    @access_key_name.setter
    def access_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_name", value)

    @_builtins.property
    @pulumi.getter(name="accessKeyUid")
    def access_key_uid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier Akamai assigns to an access key.
        """
        return pulumi.get(self, "access_key_uid")

    @access_key_uid.setter
    def access_key_uid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "access_key_uid", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of cloud provider signing process used to authenticate API requests. Two options are available: "AWS4_HMAC_SHA256" or "GOOG4_HMAC_SHA256".
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_method", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the contract assigned to the access key
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="credentialsA")
    def credentials_a(self) -> Optional[pulumi.Input['CloudAccessKeyCredentialsAArgs']]:
        """
        The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        """
        return pulumi.get(self, "credentials_a")

    @credentials_a.setter
    def credentials_a(self, value: Optional[pulumi.Input['CloudAccessKeyCredentialsAArgs']]):
        pulumi.set(self, "credentials_a", value)

    @_builtins.property
    @pulumi.getter(name="credentialsB")
    def credentials_b(self) -> Optional[pulumi.Input['CloudAccessKeyCredentialsBArgs']]:
        """
        The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        """
        return pulumi.get(self, "credentials_b")

    @credentials_b.setter
    def credentials_b(self, value: Optional[pulumi.Input['CloudAccessKeyCredentialsBArgs']]):
        pulumi.set(self, "credentials_b", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier assigned to the access control group assigned to the access key
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['CloudAccessKeyNetworkConfigurationArgs']]:
        """
        The secure networks that you assigned the access key to during creation
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['CloudAccessKeyNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="primaryGuid")
    def primary_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value of `version_guid` field for credentials marked as primary
        """
        return pulumi.get(self, "primary_guid")

    @primary_guid.setter
    def primary_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_guid", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudAccessKeyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudAccessKeyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("akamai:index/cloudAccessKey:CloudAccessKey")
class CloudAccessKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_a: Optional[pulumi.Input[Union['CloudAccessKeyCredentialsAArgs', 'CloudAccessKeyCredentialsAArgsDict']]] = None,
                 credentials_b: Optional[pulumi.Input[Union['CloudAccessKeyCredentialsBArgs', 'CloudAccessKeyCredentialsBArgsDict']]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input[Union['CloudAccessKeyNetworkConfigurationArgs', 'CloudAccessKeyNetworkConfigurationArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudAccessKeyTimeoutsArgs', 'CloudAccessKeyTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Create a CloudAccessKey resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_name: Name of the access key.
        :param pulumi.Input[_builtins.str] authentication_method: The type of cloud provider signing process used to authenticate API requests. Two options are available: "AWS4_HMAC_SHA256" or "GOOG4_HMAC_SHA256".
        :param pulumi.Input[_builtins.str] contract_id: The unique identifier for the contract assigned to the access key
        :param pulumi.Input[Union['CloudAccessKeyCredentialsAArgs', 'CloudAccessKeyCredentialsAArgsDict']] credentials_a: The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        :param pulumi.Input[Union['CloudAccessKeyCredentialsBArgs', 'CloudAccessKeyCredentialsBArgsDict']] credentials_b: The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        :param pulumi.Input[_builtins.int] group_id: The unique identifier assigned to the access control group assigned to the access key
        :param pulumi.Input[Union['CloudAccessKeyNetworkConfigurationArgs', 'CloudAccessKeyNetworkConfigurationArgsDict']] network_configuration: The secure networks that you assigned the access key to during creation
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudAccessKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CloudAccessKey resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CloudAccessKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudAccessKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_a: Optional[pulumi.Input[Union['CloudAccessKeyCredentialsAArgs', 'CloudAccessKeyCredentialsAArgsDict']]] = None,
                 credentials_b: Optional[pulumi.Input[Union['CloudAccessKeyCredentialsBArgs', 'CloudAccessKeyCredentialsBArgsDict']]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network_configuration: Optional[pulumi.Input[Union['CloudAccessKeyNetworkConfigurationArgs', 'CloudAccessKeyNetworkConfigurationArgsDict']]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudAccessKeyTimeoutsArgs', 'CloudAccessKeyTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudAccessKeyArgs.__new__(CloudAccessKeyArgs)

            if access_key_name is None and not opts.urn:
                raise TypeError("Missing required property 'access_key_name'")
            __props__.__dict__["access_key_name"] = access_key_name
            if authentication_method is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_method'")
            __props__.__dict__["authentication_method"] = authentication_method
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            __props__.__dict__["credentials_a"] = credentials_a
            __props__.__dict__["credentials_b"] = credentials_b
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if network_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration'")
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["access_key_uid"] = None
            __props__.__dict__["primary_guid"] = None
        super(CloudAccessKey, __self__).__init__(
            'akamai:index/cloudAccessKey:CloudAccessKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            access_key_uid: Optional[pulumi.Input[_builtins.int]] = None,
            authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            credentials_a: Optional[pulumi.Input[Union['CloudAccessKeyCredentialsAArgs', 'CloudAccessKeyCredentialsAArgsDict']]] = None,
            credentials_b: Optional[pulumi.Input[Union['CloudAccessKeyCredentialsBArgs', 'CloudAccessKeyCredentialsBArgsDict']]] = None,
            group_id: Optional[pulumi.Input[_builtins.int]] = None,
            network_configuration: Optional[pulumi.Input[Union['CloudAccessKeyNetworkConfigurationArgs', 'CloudAccessKeyNetworkConfigurationArgsDict']]] = None,
            primary_guid: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['CloudAccessKeyTimeoutsArgs', 'CloudAccessKeyTimeoutsArgsDict']]] = None) -> 'CloudAccessKey':
        """
        Get an existing CloudAccessKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_name: Name of the access key.
        :param pulumi.Input[_builtins.int] access_key_uid: The unique identifier Akamai assigns to an access key.
        :param pulumi.Input[_builtins.str] authentication_method: The type of cloud provider signing process used to authenticate API requests. Two options are available: "AWS4_HMAC_SHA256" or "GOOG4_HMAC_SHA256".
        :param pulumi.Input[_builtins.str] contract_id: The unique identifier for the contract assigned to the access key
        :param pulumi.Input[Union['CloudAccessKeyCredentialsAArgs', 'CloudAccessKeyCredentialsAArgsDict']] credentials_a: The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        :param pulumi.Input[Union['CloudAccessKeyCredentialsBArgs', 'CloudAccessKeyCredentialsBArgsDict']] credentials_b: The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        :param pulumi.Input[_builtins.int] group_id: The unique identifier assigned to the access control group assigned to the access key
        :param pulumi.Input[Union['CloudAccessKeyNetworkConfigurationArgs', 'CloudAccessKeyNetworkConfigurationArgsDict']] network_configuration: The secure networks that you assigned the access key to during creation
        :param pulumi.Input[_builtins.str] primary_guid: Value of `version_guid` field for credentials marked as primary
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudAccessKeyState.__new__(_CloudAccessKeyState)

        __props__.__dict__["access_key_name"] = access_key_name
        __props__.__dict__["access_key_uid"] = access_key_uid
        __props__.__dict__["authentication_method"] = authentication_method
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["credentials_a"] = credentials_a
        __props__.__dict__["credentials_b"] = credentials_b
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["primary_guid"] = primary_guid
        __props__.__dict__["timeouts"] = timeouts
        return CloudAccessKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKeyName")
    def access_key_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the access key.
        """
        return pulumi.get(self, "access_key_name")

    @_builtins.property
    @pulumi.getter(name="accessKeyUid")
    def access_key_uid(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier Akamai assigns to an access key.
        """
        return pulumi.get(self, "access_key_uid")

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Output[_builtins.str]:
        """
        The type of cloud provider signing process used to authenticate API requests. Two options are available: "AWS4_HMAC_SHA256" or "GOOG4_HMAC_SHA256".
        """
        return pulumi.get(self, "authentication_method")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the contract assigned to the access key
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="credentialsA")
    def credentials_a(self) -> pulumi.Output[Optional['outputs.CloudAccessKeyCredentialsA']]:
        """
        The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        """
        return pulumi.get(self, "credentials_a")

    @_builtins.property
    @pulumi.getter(name="credentialsB")
    def credentials_b(self) -> pulumi.Output[Optional['outputs.CloudAccessKeyCredentialsB']]:
        """
        The combination of a `cloud_access_key_id` and a `cloud_secret_access_key` used to sign API requests. This pair can be identified as access key version. Access key can contain only two access key versions at specific time (defined as credentialsA and credentialsB).
        """
        return pulumi.get(self, "credentials_b")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier assigned to the access control group assigned to the access key
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output['outputs.CloudAccessKeyNetworkConfiguration']:
        """
        The secure networks that you assigned the access key to during creation
        """
        return pulumi.get(self, "network_configuration")

    @_builtins.property
    @pulumi.getter(name="primaryGuid")
    def primary_guid(self) -> pulumi.Output[_builtins.str]:
        """
        Value of `version_guid` field for credentials marked as primary
        """
        return pulumi.get(self, "primary_guid")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CloudAccessKeyTimeouts']]:
        return pulumi.get(self, "timeouts")

