# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudwrapperConfigurationArgs', 'CloudwrapperConfiguration']

@pulumi.input_type
class CloudwrapperConfigurationArgs:
    def __init__(__self__, *,
                 comments: pulumi.Input[_builtins.str],
                 config_name: pulumi.Input[_builtins.str],
                 contract_id: pulumi.Input[_builtins.str],
                 property_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 capacity_alerts_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['CloudwrapperConfigurationLocationArgs']]]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retain_idle_objects: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['CloudwrapperConfigurationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a CloudwrapperConfiguration resource.
        :param pulumi.Input[_builtins.str] comments: Additional information you provide to differentiate or track changes of the configuration.
        :param pulumi.Input[_builtins.str] config_name: Name of the configuration.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID having Cloud Wrapper entitlement.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] property_ids: List of properties belonging to eligible products.
        :param pulumi.Input[_builtins.int] capacity_alerts_threshold: Capacity Alerts enablement information for the configuration. The Alert Threshold should be between 50 and 100.
        :param pulumi.Input[Sequence[pulumi.Input['CloudwrapperConfigurationLocationArgs']]] locations: List of locations to use with the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: Email addresses to use for notifications.
        :param pulumi.Input[_builtins.bool] retain_idle_objects: Retain idle objects beyond their max idle lifetime.
        """
        pulumi.set(__self__, "comments", comments)
        pulumi.set(__self__, "config_name", config_name)
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "property_ids", property_ids)
        if capacity_alerts_threshold is not None:
            pulumi.set(__self__, "capacity_alerts_threshold", capacity_alerts_threshold)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if retain_idle_objects is not None:
            pulumi.set(__self__, "retain_idle_objects", retain_idle_objects)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Input[_builtins.str]:
        """
        Additional information you provide to differentiate or track changes of the configuration.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="configName")
    def config_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the configuration.
        """
        return pulumi.get(self, "config_name")

    @config_name.setter
    def config_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_name", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Contract ID having Cloud Wrapper entitlement.
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="propertyIds")
    def property_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of properties belonging to eligible products.
        """
        return pulumi.get(self, "property_ids")

    @property_ids.setter
    def property_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "property_ids", value)

    @_builtins.property
    @pulumi.getter(name="capacityAlertsThreshold")
    def capacity_alerts_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Capacity Alerts enablement information for the configuration. The Alert Threshold should be between 50 and 100.
        """
        return pulumi.get(self, "capacity_alerts_threshold")

    @capacity_alerts_threshold.setter
    def capacity_alerts_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_alerts_threshold", value)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudwrapperConfigurationLocationArgs']]]]:
        """
        List of locations to use with the configuration.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudwrapperConfigurationLocationArgs']]]]):
        pulumi.set(self, "locations", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email addresses to use for notifications.
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="retainIdleObjects")
    def retain_idle_objects(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Retain idle objects beyond their max idle lifetime.
        """
        return pulumi.get(self, "retain_idle_objects")

    @retain_idle_objects.setter
    def retain_idle_objects(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_idle_objects", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudwrapperConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudwrapperConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _CloudwrapperConfigurationState:
    def __init__(__self__, *,
                 capacity_alerts_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['CloudwrapperConfigurationLocationArgs']]]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 property_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retain_idle_objects: Optional[pulumi.Input[_builtins.bool]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['CloudwrapperConfigurationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering CloudwrapperConfiguration resources.
        :param pulumi.Input[_builtins.int] capacity_alerts_threshold: Capacity Alerts enablement information for the configuration. The Alert Threshold should be between 50 and 100.
        :param pulumi.Input[_builtins.str] comments: Additional information you provide to differentiate or track changes of the configuration.
        :param pulumi.Input[_builtins.str] config_name: Name of the configuration.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID having Cloud Wrapper entitlement.
        :param pulumi.Input[Sequence[pulumi.Input['CloudwrapperConfigurationLocationArgs']]] locations: List of locations to use with the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: Email addresses to use for notifications.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] property_ids: List of properties belonging to eligible products.
        :param pulumi.Input[_builtins.bool] retain_idle_objects: Retain idle objects beyond their max idle lifetime.
        :param pulumi.Input[_builtins.str] revision: Unique hash value of the configuration.
        """
        if capacity_alerts_threshold is not None:
            pulumi.set(__self__, "capacity_alerts_threshold", capacity_alerts_threshold)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if config_name is not None:
            pulumi.set(__self__, "config_name", config_name)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if property_ids is not None:
            pulumi.set(__self__, "property_ids", property_ids)
        if retain_idle_objects is not None:
            pulumi.set(__self__, "retain_idle_objects", retain_idle_objects)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="capacityAlertsThreshold")
    def capacity_alerts_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Capacity Alerts enablement information for the configuration. The Alert Threshold should be between 50 and 100.
        """
        return pulumi.get(self, "capacity_alerts_threshold")

    @capacity_alerts_threshold.setter
    def capacity_alerts_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity_alerts_threshold", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information you provide to differentiate or track changes of the configuration.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="configName")
    def config_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the configuration.
        """
        return pulumi.get(self, "config_name")

    @config_name.setter
    def config_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_name", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contract ID having Cloud Wrapper entitlement.
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudwrapperConfigurationLocationArgs']]]]:
        """
        List of locations to use with the configuration.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudwrapperConfigurationLocationArgs']]]]):
        pulumi.set(self, "locations", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email addresses to use for notifications.
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="propertyIds")
    def property_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of properties belonging to eligible products.
        """
        return pulumi.get(self, "property_ids")

    @property_ids.setter
    def property_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "property_ids", value)

    @_builtins.property
    @pulumi.getter(name="retainIdleObjects")
    def retain_idle_objects(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Retain idle objects beyond their max idle lifetime.
        """
        return pulumi.get(self, "retain_idle_objects")

    @retain_idle_objects.setter
    def retain_idle_objects(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_idle_objects", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique hash value of the configuration.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudwrapperConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudwrapperConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("akamai:index/cloudwrapperConfiguration:CloudwrapperConfiguration")
class CloudwrapperConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_alerts_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudwrapperConfigurationLocationArgs', 'CloudwrapperConfigurationLocationArgsDict']]]]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 property_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retain_idle_objects: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudwrapperConfigurationTimeoutsArgs', 'CloudwrapperConfigurationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Create a CloudwrapperConfiguration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] capacity_alerts_threshold: Capacity Alerts enablement information for the configuration. The Alert Threshold should be between 50 and 100.
        :param pulumi.Input[_builtins.str] comments: Additional information you provide to differentiate or track changes of the configuration.
        :param pulumi.Input[_builtins.str] config_name: Name of the configuration.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID having Cloud Wrapper entitlement.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudwrapperConfigurationLocationArgs', 'CloudwrapperConfigurationLocationArgsDict']]]] locations: List of locations to use with the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: Email addresses to use for notifications.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] property_ids: List of properties belonging to eligible products.
        :param pulumi.Input[_builtins.bool] retain_idle_objects: Retain idle objects beyond their max idle lifetime.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudwrapperConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CloudwrapperConfiguration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CloudwrapperConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudwrapperConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_alerts_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 config_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudwrapperConfigurationLocationArgs', 'CloudwrapperConfigurationLocationArgsDict']]]]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 property_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retain_idle_objects: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudwrapperConfigurationTimeoutsArgs', 'CloudwrapperConfigurationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudwrapperConfigurationArgs.__new__(CloudwrapperConfigurationArgs)

            __props__.__dict__["capacity_alerts_threshold"] = capacity_alerts_threshold
            if comments is None and not opts.urn:
                raise TypeError("Missing required property 'comments'")
            __props__.__dict__["comments"] = comments
            if config_name is None and not opts.urn:
                raise TypeError("Missing required property 'config_name'")
            __props__.__dict__["config_name"] = config_name
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            __props__.__dict__["locations"] = locations
            __props__.__dict__["notification_emails"] = notification_emails
            if property_ids is None and not opts.urn:
                raise TypeError("Missing required property 'property_ids'")
            __props__.__dict__["property_ids"] = property_ids
            __props__.__dict__["retain_idle_objects"] = retain_idle_objects
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["revision"] = None
        super(CloudwrapperConfiguration, __self__).__init__(
            'akamai:index/cloudwrapperConfiguration:CloudwrapperConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity_alerts_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            comments: Optional[pulumi.Input[_builtins.str]] = None,
            config_name: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudwrapperConfigurationLocationArgs', 'CloudwrapperConfigurationLocationArgsDict']]]]] = None,
            notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            property_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            retain_idle_objects: Optional[pulumi.Input[_builtins.bool]] = None,
            revision: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['CloudwrapperConfigurationTimeoutsArgs', 'CloudwrapperConfigurationTimeoutsArgsDict']]] = None) -> 'CloudwrapperConfiguration':
        """
        Get an existing CloudwrapperConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] capacity_alerts_threshold: Capacity Alerts enablement information for the configuration. The Alert Threshold should be between 50 and 100.
        :param pulumi.Input[_builtins.str] comments: Additional information you provide to differentiate or track changes of the configuration.
        :param pulumi.Input[_builtins.str] config_name: Name of the configuration.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID having Cloud Wrapper entitlement.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudwrapperConfigurationLocationArgs', 'CloudwrapperConfigurationLocationArgsDict']]]] locations: List of locations to use with the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: Email addresses to use for notifications.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] property_ids: List of properties belonging to eligible products.
        :param pulumi.Input[_builtins.bool] retain_idle_objects: Retain idle objects beyond their max idle lifetime.
        :param pulumi.Input[_builtins.str] revision: Unique hash value of the configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudwrapperConfigurationState.__new__(_CloudwrapperConfigurationState)

        __props__.__dict__["capacity_alerts_threshold"] = capacity_alerts_threshold
        __props__.__dict__["comments"] = comments
        __props__.__dict__["config_name"] = config_name
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["locations"] = locations
        __props__.__dict__["notification_emails"] = notification_emails
        __props__.__dict__["property_ids"] = property_ids
        __props__.__dict__["retain_idle_objects"] = retain_idle_objects
        __props__.__dict__["revision"] = revision
        __props__.__dict__["timeouts"] = timeouts
        return CloudwrapperConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="capacityAlertsThreshold")
    def capacity_alerts_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Capacity Alerts enablement information for the configuration. The Alert Threshold should be between 50 and 100.
        """
        return pulumi.get(self, "capacity_alerts_threshold")

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information you provide to differentiate or track changes of the configuration.
        """
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter(name="configName")
    def config_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the configuration.
        """
        return pulumi.get(self, "config_name")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Contract ID having Cloud Wrapper entitlement.
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence['outputs.CloudwrapperConfigurationLocation']]]:
        """
        List of locations to use with the configuration.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Email addresses to use for notifications.
        """
        return pulumi.get(self, "notification_emails")

    @_builtins.property
    @pulumi.getter(name="propertyIds")
    def property_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of properties belonging to eligible products.
        """
        return pulumi.get(self, "property_ids")

    @_builtins.property
    @pulumi.getter(name="retainIdleObjects")
    def retain_idle_objects(self) -> pulumi.Output[_builtins.bool]:
        """
        Retain idle objects beyond their max idle lifetime.
        """
        return pulumi.get(self, "retain_idle_objects")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> pulumi.Output[_builtins.str]:
        """
        Unique hash value of the configuration.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CloudwrapperConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

