# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CpsDvValidationArgs', 'CpsDvValidation']

@pulumi.input_type
class CpsDvValidationArgs:
    def __init__(__self__, *,
                 enrollment_id: pulumi.Input[_builtins.int],
                 acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['CpsDvValidationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a CpsDvValidation resource.
        :param pulumi.Input[_builtins.int] enrollment_id: The unique identifier of enrollment
        :param pulumi.Input[_builtins.bool] acknowledge_post_verification_warnings: Whether to acknowledge all post-verification warnings
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: List of SANs
        :param pulumi.Input['CpsDvValidationTimeoutsArgs'] timeouts: Enables to set timeout for processing
        """
        pulumi.set(__self__, "enrollment_id", enrollment_id)
        if acknowledge_post_verification_warnings is not None:
            pulumi.set(__self__, "acknowledge_post_verification_warnings", acknowledge_post_verification_warnings)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> pulumi.Input[_builtins.int]:
        """
        The unique identifier of enrollment
        """
        return pulumi.get(self, "enrollment_id")

    @enrollment_id.setter
    def enrollment_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "enrollment_id", value)

    @_builtins.property
    @pulumi.getter(name="acknowledgePostVerificationWarnings")
    def acknowledge_post_verification_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to acknowledge all post-verification warnings
        """
        return pulumi.get(self, "acknowledge_post_verification_warnings")

    @acknowledge_post_verification_warnings.setter
    def acknowledge_post_verification_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acknowledge_post_verification_warnings", value)

    @_builtins.property
    @pulumi.getter
    def sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @sans.setter
    def sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sans", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CpsDvValidationTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CpsDvValidationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _CpsDvValidationState:
    def __init__(__self__, *,
                 acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 enrollment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['CpsDvValidationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering CpsDvValidation resources.
        :param pulumi.Input[_builtins.bool] acknowledge_post_verification_warnings: Whether to acknowledge all post-verification warnings
        :param pulumi.Input[_builtins.int] enrollment_id: The unique identifier of enrollment
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: List of SANs
        :param pulumi.Input[_builtins.str] status: Status of validation
        :param pulumi.Input['CpsDvValidationTimeoutsArgs'] timeouts: Enables to set timeout for processing
        """
        if acknowledge_post_verification_warnings is not None:
            pulumi.set(__self__, "acknowledge_post_verification_warnings", acknowledge_post_verification_warnings)
        if enrollment_id is not None:
            pulumi.set(__self__, "enrollment_id", enrollment_id)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="acknowledgePostVerificationWarnings")
    def acknowledge_post_verification_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to acknowledge all post-verification warnings
        """
        return pulumi.get(self, "acknowledge_post_verification_warnings")

    @acknowledge_post_verification_warnings.setter
    def acknowledge_post_verification_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acknowledge_post_verification_warnings", value)

    @_builtins.property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of enrollment
        """
        return pulumi.get(self, "enrollment_id")

    @enrollment_id.setter
    def enrollment_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enrollment_id", value)

    @_builtins.property
    @pulumi.getter
    def sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @sans.setter
    def sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sans", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of validation
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CpsDvValidationTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CpsDvValidationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("akamai:index/cpsDvValidation:CpsDvValidation")
class CpsDvValidation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 enrollment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['CpsDvValidationTimeoutsArgs', 'CpsDvValidationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Create a CpsDvValidation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] acknowledge_post_verification_warnings: Whether to acknowledge all post-verification warnings
        :param pulumi.Input[_builtins.int] enrollment_id: The unique identifier of enrollment
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: List of SANs
        :param pulumi.Input[Union['CpsDvValidationTimeoutsArgs', 'CpsDvValidationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CpsDvValidationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CpsDvValidation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CpsDvValidationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CpsDvValidationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 enrollment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['CpsDvValidationTimeoutsArgs', 'CpsDvValidationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CpsDvValidationArgs.__new__(CpsDvValidationArgs)

            __props__.__dict__["acknowledge_post_verification_warnings"] = acknowledge_post_verification_warnings
            if enrollment_id is None and not opts.urn:
                raise TypeError("Missing required property 'enrollment_id'")
            __props__.__dict__["enrollment_id"] = enrollment_id
            __props__.__dict__["sans"] = sans
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["status"] = None
        super(CpsDvValidation, __self__).__init__(
            'akamai:index/cpsDvValidation:CpsDvValidation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acknowledge_post_verification_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
            enrollment_id: Optional[pulumi.Input[_builtins.int]] = None,
            sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['CpsDvValidationTimeoutsArgs', 'CpsDvValidationTimeoutsArgsDict']]] = None) -> 'CpsDvValidation':
        """
        Get an existing CpsDvValidation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] acknowledge_post_verification_warnings: Whether to acknowledge all post-verification warnings
        :param pulumi.Input[_builtins.int] enrollment_id: The unique identifier of enrollment
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: List of SANs
        :param pulumi.Input[_builtins.str] status: Status of validation
        :param pulumi.Input[Union['CpsDvValidationTimeoutsArgs', 'CpsDvValidationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CpsDvValidationState.__new__(_CpsDvValidationState)

        __props__.__dict__["acknowledge_post_verification_warnings"] = acknowledge_post_verification_warnings
        __props__.__dict__["enrollment_id"] = enrollment_id
        __props__.__dict__["sans"] = sans
        __props__.__dict__["status"] = status
        __props__.__dict__["timeouts"] = timeouts
        return CpsDvValidation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acknowledgePostVerificationWarnings")
    def acknowledge_post_verification_warnings(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to acknowledge all post-verification warnings
        """
        return pulumi.get(self, "acknowledge_post_verification_warnings")

    @_builtins.property
    @pulumi.getter(name="enrollmentId")
    def enrollment_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of enrollment
        """
        return pulumi.get(self, "enrollment_id")

    @_builtins.property
    @pulumi.getter
    def sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of validation
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CpsDvValidationTimeouts']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

