# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatastreamArgs', 'Datastream']

@pulumi.input_type
class DatastreamArgs:
    def __init__(__self__, *,
                 active: pulumi.Input[_builtins.bool],
                 contract_id: pulumi.Input[_builtins.str],
                 dataset_fields: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]],
                 delivery_configuration: pulumi.Input['DatastreamDeliveryConfigurationArgs'],
                 group_id: pulumi.Input[_builtins.str],
                 properties: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 stream_name: pulumi.Input[_builtins.str],
                 azure_connector: Optional[pulumi.Input['DatastreamAzureConnectorArgs']] = None,
                 collect_midgress: Optional[pulumi.Input[_builtins.bool]] = None,
                 datadog_connector: Optional[pulumi.Input['DatastreamDatadogConnectorArgs']] = None,
                 elasticsearch_connector: Optional[pulumi.Input['DatastreamElasticsearchConnectorArgs']] = None,
                 gcs_connector: Optional[pulumi.Input['DatastreamGcsConnectorArgs']] = None,
                 https_connector: Optional[pulumi.Input['DatastreamHttpsConnectorArgs']] = None,
                 loggly_connector: Optional[pulumi.Input['DatastreamLogglyConnectorArgs']] = None,
                 new_relic_connector: Optional[pulumi.Input['DatastreamNewRelicConnectorArgs']] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 oracle_connector: Optional[pulumi.Input['DatastreamOracleConnectorArgs']] = None,
                 s3_connector: Optional[pulumi.Input['DatastreamS3ConnectorArgs']] = None,
                 splunk_connector: Optional[pulumi.Input['DatastreamSplunkConnectorArgs']] = None,
                 sumologic_connector: Optional[pulumi.Input['DatastreamSumologicConnectorArgs']] = None):
        """
        The set of arguments for constructing a Datastream resource.
        :param pulumi.Input[_builtins.bool] active: Defining if stream should be active or not
        :param pulumi.Input[_builtins.str] contract_id: Identifies the contract that has access to the product
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] dataset_fields: A list of data set fields selected from the associated template that the stream monitors in logs. The order of the identifiers define how the value for these fields appear in the log lines
        :param pulumi.Input['DatastreamDeliveryConfigurationArgs'] delivery_configuration: Provides information about the configuration related to logs (format, file names, delivery frequency)
        :param pulumi.Input[_builtins.str] group_id: Identifies the group that has access to the product and for which the stream configuration was created
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] properties: Identifies the properties monitored in the stream
        :param pulumi.Input[_builtins.str] stream_name: The name of the stream
        :param pulumi.Input[_builtins.bool] collect_midgress: Identifies if stream needs to collect midgress data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: List of email addresses where the system sends notifications about activations and deactivations of the stream
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "dataset_fields", dataset_fields)
        pulumi.set(__self__, "delivery_configuration", delivery_configuration)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "stream_name", stream_name)
        if azure_connector is not None:
            pulumi.set(__self__, "azure_connector", azure_connector)
        if collect_midgress is not None:
            pulumi.set(__self__, "collect_midgress", collect_midgress)
        if datadog_connector is not None:
            pulumi.set(__self__, "datadog_connector", datadog_connector)
        if elasticsearch_connector is not None:
            pulumi.set(__self__, "elasticsearch_connector", elasticsearch_connector)
        if gcs_connector is not None:
            pulumi.set(__self__, "gcs_connector", gcs_connector)
        if https_connector is not None:
            pulumi.set(__self__, "https_connector", https_connector)
        if loggly_connector is not None:
            pulumi.set(__self__, "loggly_connector", loggly_connector)
        if new_relic_connector is not None:
            pulumi.set(__self__, "new_relic_connector", new_relic_connector)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if oracle_connector is not None:
            pulumi.set(__self__, "oracle_connector", oracle_connector)
        if s3_connector is not None:
            pulumi.set(__self__, "s3_connector", s3_connector)
        if splunk_connector is not None:
            pulumi.set(__self__, "splunk_connector", splunk_connector)
        if sumologic_connector is not None:
            pulumi.set(__self__, "sumologic_connector", sumologic_connector)

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Input[_builtins.bool]:
        """
        Defining if stream should be active or not
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the contract that has access to the product
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="datasetFields")
    def dataset_fields(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        A list of data set fields selected from the associated template that the stream monitors in logs. The order of the identifiers define how the value for these fields appear in the log lines
        """
        return pulumi.get(self, "dataset_fields")

    @dataset_fields.setter
    def dataset_fields(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "dataset_fields", value)

    @_builtins.property
    @pulumi.getter(name="deliveryConfiguration")
    def delivery_configuration(self) -> pulumi.Input['DatastreamDeliveryConfigurationArgs']:
        """
        Provides information about the configuration related to logs (format, file names, delivery frequency)
        """
        return pulumi.get(self, "delivery_configuration")

    @delivery_configuration.setter
    def delivery_configuration(self, value: pulumi.Input['DatastreamDeliveryConfigurationArgs']):
        pulumi.set(self, "delivery_configuration", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the group that has access to the product and for which the stream configuration was created
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Identifies the properties monitored in the stream
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the stream
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_name", value)

    @_builtins.property
    @pulumi.getter(name="azureConnector")
    def azure_connector(self) -> Optional[pulumi.Input['DatastreamAzureConnectorArgs']]:
        return pulumi.get(self, "azure_connector")

    @azure_connector.setter
    def azure_connector(self, value: Optional[pulumi.Input['DatastreamAzureConnectorArgs']]):
        pulumi.set(self, "azure_connector", value)

    @_builtins.property
    @pulumi.getter(name="collectMidgress")
    def collect_midgress(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Identifies if stream needs to collect midgress data
        """
        return pulumi.get(self, "collect_midgress")

    @collect_midgress.setter
    def collect_midgress(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "collect_midgress", value)

    @_builtins.property
    @pulumi.getter(name="datadogConnector")
    def datadog_connector(self) -> Optional[pulumi.Input['DatastreamDatadogConnectorArgs']]:
        return pulumi.get(self, "datadog_connector")

    @datadog_connector.setter
    def datadog_connector(self, value: Optional[pulumi.Input['DatastreamDatadogConnectorArgs']]):
        pulumi.set(self, "datadog_connector", value)

    @_builtins.property
    @pulumi.getter(name="elasticsearchConnector")
    def elasticsearch_connector(self) -> Optional[pulumi.Input['DatastreamElasticsearchConnectorArgs']]:
        return pulumi.get(self, "elasticsearch_connector")

    @elasticsearch_connector.setter
    def elasticsearch_connector(self, value: Optional[pulumi.Input['DatastreamElasticsearchConnectorArgs']]):
        pulumi.set(self, "elasticsearch_connector", value)

    @_builtins.property
    @pulumi.getter(name="gcsConnector")
    def gcs_connector(self) -> Optional[pulumi.Input['DatastreamGcsConnectorArgs']]:
        return pulumi.get(self, "gcs_connector")

    @gcs_connector.setter
    def gcs_connector(self, value: Optional[pulumi.Input['DatastreamGcsConnectorArgs']]):
        pulumi.set(self, "gcs_connector", value)

    @_builtins.property
    @pulumi.getter(name="httpsConnector")
    def https_connector(self) -> Optional[pulumi.Input['DatastreamHttpsConnectorArgs']]:
        return pulumi.get(self, "https_connector")

    @https_connector.setter
    def https_connector(self, value: Optional[pulumi.Input['DatastreamHttpsConnectorArgs']]):
        pulumi.set(self, "https_connector", value)

    @_builtins.property
    @pulumi.getter(name="logglyConnector")
    def loggly_connector(self) -> Optional[pulumi.Input['DatastreamLogglyConnectorArgs']]:
        return pulumi.get(self, "loggly_connector")

    @loggly_connector.setter
    def loggly_connector(self, value: Optional[pulumi.Input['DatastreamLogglyConnectorArgs']]):
        pulumi.set(self, "loggly_connector", value)

    @_builtins.property
    @pulumi.getter(name="newRelicConnector")
    def new_relic_connector(self) -> Optional[pulumi.Input['DatastreamNewRelicConnectorArgs']]:
        return pulumi.get(self, "new_relic_connector")

    @new_relic_connector.setter
    def new_relic_connector(self, value: Optional[pulumi.Input['DatastreamNewRelicConnectorArgs']]):
        pulumi.set(self, "new_relic_connector", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses where the system sends notifications about activations and deactivations of the stream
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="oracleConnector")
    def oracle_connector(self) -> Optional[pulumi.Input['DatastreamOracleConnectorArgs']]:
        return pulumi.get(self, "oracle_connector")

    @oracle_connector.setter
    def oracle_connector(self, value: Optional[pulumi.Input['DatastreamOracleConnectorArgs']]):
        pulumi.set(self, "oracle_connector", value)

    @_builtins.property
    @pulumi.getter(name="s3Connector")
    def s3_connector(self) -> Optional[pulumi.Input['DatastreamS3ConnectorArgs']]:
        return pulumi.get(self, "s3_connector")

    @s3_connector.setter
    def s3_connector(self, value: Optional[pulumi.Input['DatastreamS3ConnectorArgs']]):
        pulumi.set(self, "s3_connector", value)

    @_builtins.property
    @pulumi.getter(name="splunkConnector")
    def splunk_connector(self) -> Optional[pulumi.Input['DatastreamSplunkConnectorArgs']]:
        return pulumi.get(self, "splunk_connector")

    @splunk_connector.setter
    def splunk_connector(self, value: Optional[pulumi.Input['DatastreamSplunkConnectorArgs']]):
        pulumi.set(self, "splunk_connector", value)

    @_builtins.property
    @pulumi.getter(name="sumologicConnector")
    def sumologic_connector(self) -> Optional[pulumi.Input['DatastreamSumologicConnectorArgs']]:
        return pulumi.get(self, "sumologic_connector")

    @sumologic_connector.setter
    def sumologic_connector(self, value: Optional[pulumi.Input['DatastreamSumologicConnectorArgs']]):
        pulumi.set(self, "sumologic_connector", value)


@pulumi.input_type
class _DatastreamState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_connector: Optional[pulumi.Input['DatastreamAzureConnectorArgs']] = None,
                 collect_midgress: Optional[pulumi.Input[_builtins.bool]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_date: Optional[pulumi.Input[_builtins.str]] = None,
                 datadog_connector: Optional[pulumi.Input['DatastreamDatadogConnectorArgs']] = None,
                 dataset_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 delivery_configuration: Optional[pulumi.Input['DatastreamDeliveryConfigurationArgs']] = None,
                 elasticsearch_connector: Optional[pulumi.Input['DatastreamElasticsearchConnectorArgs']] = None,
                 gcs_connector: Optional[pulumi.Input['DatastreamGcsConnectorArgs']] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 https_connector: Optional[pulumi.Input['DatastreamHttpsConnectorArgs']] = None,
                 latest_version: Optional[pulumi.Input[_builtins.int]] = None,
                 loggly_connector: Optional[pulumi.Input['DatastreamLogglyConnectorArgs']] = None,
                 modified_by: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_date: Optional[pulumi.Input[_builtins.str]] = None,
                 new_relic_connector: Optional[pulumi.Input['DatastreamNewRelicConnectorArgs']] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 oracle_connector: Optional[pulumi.Input['DatastreamOracleConnectorArgs']] = None,
                 papi_json: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 s3_connector: Optional[pulumi.Input['DatastreamS3ConnectorArgs']] = None,
                 splunk_connector: Optional[pulumi.Input['DatastreamSplunkConnectorArgs']] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_version: Optional[pulumi.Input[_builtins.int]] = None,
                 sumologic_connector: Optional[pulumi.Input['DatastreamSumologicConnectorArgs']] = None):
        """
        Input properties used for looking up and filtering Datastream resources.
        :param pulumi.Input[_builtins.bool] active: Defining if stream should be active or not
        :param pulumi.Input[_builtins.bool] collect_midgress: Identifies if stream needs to collect midgress data
        :param pulumi.Input[_builtins.str] contract_id: Identifies the contract that has access to the product
        :param pulumi.Input[_builtins.str] created_by: The username who created the stream
        :param pulumi.Input[_builtins.str] created_date: The date and time when the stream was created
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] dataset_fields: A list of data set fields selected from the associated template that the stream monitors in logs. The order of the identifiers define how the value for these fields appear in the log lines
        :param pulumi.Input['DatastreamDeliveryConfigurationArgs'] delivery_configuration: Provides information about the configuration related to logs (format, file names, delivery frequency)
        :param pulumi.Input[_builtins.str] group_id: Identifies the group that has access to the product and for which the stream configuration was created
        :param pulumi.Input[_builtins.int] latest_version: Identifies the latest active configuration version of the stream
        :param pulumi.Input[_builtins.str] modified_by: The username who modified the stream
        :param pulumi.Input[_builtins.str] modified_date: The date and time when the stream was modified
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: List of email addresses where the system sends notifications about activations and deactivations of the stream
        :param pulumi.Input[_builtins.str] papi_json: The configuration in JSON format that can be copy-pasted into PAPI configuration to enable datastream behavior
        :param pulumi.Input[_builtins.str] product_id: The ID of the product for which the stream was created
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] properties: Identifies the properties monitored in the stream
        :param pulumi.Input[_builtins.str] stream_name: The name of the stream
        :param pulumi.Input[_builtins.int] stream_version: Identifies the configuration version of the stream
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if azure_connector is not None:
            pulumi.set(__self__, "azure_connector", azure_connector)
        if collect_midgress is not None:
            pulumi.set(__self__, "collect_midgress", collect_midgress)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if datadog_connector is not None:
            pulumi.set(__self__, "datadog_connector", datadog_connector)
        if dataset_fields is not None:
            pulumi.set(__self__, "dataset_fields", dataset_fields)
        if delivery_configuration is not None:
            pulumi.set(__self__, "delivery_configuration", delivery_configuration)
        if elasticsearch_connector is not None:
            pulumi.set(__self__, "elasticsearch_connector", elasticsearch_connector)
        if gcs_connector is not None:
            pulumi.set(__self__, "gcs_connector", gcs_connector)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if https_connector is not None:
            pulumi.set(__self__, "https_connector", https_connector)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if loggly_connector is not None:
            pulumi.set(__self__, "loggly_connector", loggly_connector)
        if modified_by is not None:
            pulumi.set(__self__, "modified_by", modified_by)
        if modified_date is not None:
            pulumi.set(__self__, "modified_date", modified_date)
        if new_relic_connector is not None:
            pulumi.set(__self__, "new_relic_connector", new_relic_connector)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if oracle_connector is not None:
            pulumi.set(__self__, "oracle_connector", oracle_connector)
        if papi_json is not None:
            pulumi.set(__self__, "papi_json", papi_json)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if s3_connector is not None:
            pulumi.set(__self__, "s3_connector", s3_connector)
        if splunk_connector is not None:
            pulumi.set(__self__, "splunk_connector", splunk_connector)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)
        if stream_version is not None:
            pulumi.set(__self__, "stream_version", stream_version)
        if sumologic_connector is not None:
            pulumi.set(__self__, "sumologic_connector", sumologic_connector)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defining if stream should be active or not
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="azureConnector")
    def azure_connector(self) -> Optional[pulumi.Input['DatastreamAzureConnectorArgs']]:
        return pulumi.get(self, "azure_connector")

    @azure_connector.setter
    def azure_connector(self, value: Optional[pulumi.Input['DatastreamAzureConnectorArgs']]):
        pulumi.set(self, "azure_connector", value)

    @_builtins.property
    @pulumi.getter(name="collectMidgress")
    def collect_midgress(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Identifies if stream needs to collect midgress data
        """
        return pulumi.get(self, "collect_midgress")

    @collect_midgress.setter
    def collect_midgress(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "collect_midgress", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the contract that has access to the product
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username who created the stream
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the stream was created
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date", value)

    @_builtins.property
    @pulumi.getter(name="datadogConnector")
    def datadog_connector(self) -> Optional[pulumi.Input['DatastreamDatadogConnectorArgs']]:
        return pulumi.get(self, "datadog_connector")

    @datadog_connector.setter
    def datadog_connector(self, value: Optional[pulumi.Input['DatastreamDatadogConnectorArgs']]):
        pulumi.set(self, "datadog_connector", value)

    @_builtins.property
    @pulumi.getter(name="datasetFields")
    def dataset_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        A list of data set fields selected from the associated template that the stream monitors in logs. The order of the identifiers define how the value for these fields appear in the log lines
        """
        return pulumi.get(self, "dataset_fields")

    @dataset_fields.setter
    def dataset_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "dataset_fields", value)

    @_builtins.property
    @pulumi.getter(name="deliveryConfiguration")
    def delivery_configuration(self) -> Optional[pulumi.Input['DatastreamDeliveryConfigurationArgs']]:
        """
        Provides information about the configuration related to logs (format, file names, delivery frequency)
        """
        return pulumi.get(self, "delivery_configuration")

    @delivery_configuration.setter
    def delivery_configuration(self, value: Optional[pulumi.Input['DatastreamDeliveryConfigurationArgs']]):
        pulumi.set(self, "delivery_configuration", value)

    @_builtins.property
    @pulumi.getter(name="elasticsearchConnector")
    def elasticsearch_connector(self) -> Optional[pulumi.Input['DatastreamElasticsearchConnectorArgs']]:
        return pulumi.get(self, "elasticsearch_connector")

    @elasticsearch_connector.setter
    def elasticsearch_connector(self, value: Optional[pulumi.Input['DatastreamElasticsearchConnectorArgs']]):
        pulumi.set(self, "elasticsearch_connector", value)

    @_builtins.property
    @pulumi.getter(name="gcsConnector")
    def gcs_connector(self) -> Optional[pulumi.Input['DatastreamGcsConnectorArgs']]:
        return pulumi.get(self, "gcs_connector")

    @gcs_connector.setter
    def gcs_connector(self, value: Optional[pulumi.Input['DatastreamGcsConnectorArgs']]):
        pulumi.set(self, "gcs_connector", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the group that has access to the product and for which the stream configuration was created
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="httpsConnector")
    def https_connector(self) -> Optional[pulumi.Input['DatastreamHttpsConnectorArgs']]:
        return pulumi.get(self, "https_connector")

    @https_connector.setter
    def https_connector(self, value: Optional[pulumi.Input['DatastreamHttpsConnectorArgs']]):
        pulumi.set(self, "https_connector", value)

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Identifies the latest active configuration version of the stream
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "latest_version", value)

    @_builtins.property
    @pulumi.getter(name="logglyConnector")
    def loggly_connector(self) -> Optional[pulumi.Input['DatastreamLogglyConnectorArgs']]:
        return pulumi.get(self, "loggly_connector")

    @loggly_connector.setter
    def loggly_connector(self, value: Optional[pulumi.Input['DatastreamLogglyConnectorArgs']]):
        pulumi.set(self, "loggly_connector", value)

    @_builtins.property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username who modified the stream
        """
        return pulumi.get(self, "modified_by")

    @modified_by.setter
    def modified_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_by", value)

    @_builtins.property
    @pulumi.getter(name="modifiedDate")
    def modified_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the stream was modified
        """
        return pulumi.get(self, "modified_date")

    @modified_date.setter
    def modified_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_date", value)

    @_builtins.property
    @pulumi.getter(name="newRelicConnector")
    def new_relic_connector(self) -> Optional[pulumi.Input['DatastreamNewRelicConnectorArgs']]:
        return pulumi.get(self, "new_relic_connector")

    @new_relic_connector.setter
    def new_relic_connector(self, value: Optional[pulumi.Input['DatastreamNewRelicConnectorArgs']]):
        pulumi.set(self, "new_relic_connector", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses where the system sends notifications about activations and deactivations of the stream
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="oracleConnector")
    def oracle_connector(self) -> Optional[pulumi.Input['DatastreamOracleConnectorArgs']]:
        return pulumi.get(self, "oracle_connector")

    @oracle_connector.setter
    def oracle_connector(self, value: Optional[pulumi.Input['DatastreamOracleConnectorArgs']]):
        pulumi.set(self, "oracle_connector", value)

    @_builtins.property
    @pulumi.getter(name="papiJson")
    def papi_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration in JSON format that can be copy-pasted into PAPI configuration to enable datastream behavior
        """
        return pulumi.get(self, "papi_json")

    @papi_json.setter
    def papi_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "papi_json", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the product for which the stream was created
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Identifies the properties monitored in the stream
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="s3Connector")
    def s3_connector(self) -> Optional[pulumi.Input['DatastreamS3ConnectorArgs']]:
        return pulumi.get(self, "s3_connector")

    @s3_connector.setter
    def s3_connector(self, value: Optional[pulumi.Input['DatastreamS3ConnectorArgs']]):
        pulumi.set(self, "s3_connector", value)

    @_builtins.property
    @pulumi.getter(name="splunkConnector")
    def splunk_connector(self) -> Optional[pulumi.Input['DatastreamSplunkConnectorArgs']]:
        return pulumi.get(self, "splunk_connector")

    @splunk_connector.setter
    def splunk_connector(self, value: Optional[pulumi.Input['DatastreamSplunkConnectorArgs']]):
        pulumi.set(self, "splunk_connector", value)

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the stream
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_name", value)

    @_builtins.property
    @pulumi.getter(name="streamVersion")
    def stream_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Identifies the configuration version of the stream
        """
        return pulumi.get(self, "stream_version")

    @stream_version.setter
    def stream_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stream_version", value)

    @_builtins.property
    @pulumi.getter(name="sumologicConnector")
    def sumologic_connector(self) -> Optional[pulumi.Input['DatastreamSumologicConnectorArgs']]:
        return pulumi.get(self, "sumologic_connector")

    @sumologic_connector.setter
    def sumologic_connector(self, value: Optional[pulumi.Input['DatastreamSumologicConnectorArgs']]):
        pulumi.set(self, "sumologic_connector", value)


@pulumi.type_token("akamai:index/datastream:Datastream")
class Datastream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_connector: Optional[pulumi.Input[Union['DatastreamAzureConnectorArgs', 'DatastreamAzureConnectorArgsDict']]] = None,
                 collect_midgress: Optional[pulumi.Input[_builtins.bool]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datadog_connector: Optional[pulumi.Input[Union['DatastreamDatadogConnectorArgs', 'DatastreamDatadogConnectorArgsDict']]] = None,
                 dataset_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 delivery_configuration: Optional[pulumi.Input[Union['DatastreamDeliveryConfigurationArgs', 'DatastreamDeliveryConfigurationArgsDict']]] = None,
                 elasticsearch_connector: Optional[pulumi.Input[Union['DatastreamElasticsearchConnectorArgs', 'DatastreamElasticsearchConnectorArgsDict']]] = None,
                 gcs_connector: Optional[pulumi.Input[Union['DatastreamGcsConnectorArgs', 'DatastreamGcsConnectorArgsDict']]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 https_connector: Optional[pulumi.Input[Union['DatastreamHttpsConnectorArgs', 'DatastreamHttpsConnectorArgsDict']]] = None,
                 loggly_connector: Optional[pulumi.Input[Union['DatastreamLogglyConnectorArgs', 'DatastreamLogglyConnectorArgsDict']]] = None,
                 new_relic_connector: Optional[pulumi.Input[Union['DatastreamNewRelicConnectorArgs', 'DatastreamNewRelicConnectorArgsDict']]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 oracle_connector: Optional[pulumi.Input[Union['DatastreamOracleConnectorArgs', 'DatastreamOracleConnectorArgsDict']]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 s3_connector: Optional[pulumi.Input[Union['DatastreamS3ConnectorArgs', 'DatastreamS3ConnectorArgsDict']]] = None,
                 splunk_connector: Optional[pulumi.Input[Union['DatastreamSplunkConnectorArgs', 'DatastreamSplunkConnectorArgsDict']]] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sumologic_connector: Optional[pulumi.Input[Union['DatastreamSumologicConnectorArgs', 'DatastreamSumologicConnectorArgsDict']]] = None,
                 __props__=None):
        """
        Create a Datastream resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Defining if stream should be active or not
        :param pulumi.Input[_builtins.bool] collect_midgress: Identifies if stream needs to collect midgress data
        :param pulumi.Input[_builtins.str] contract_id: Identifies the contract that has access to the product
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] dataset_fields: A list of data set fields selected from the associated template that the stream monitors in logs. The order of the identifiers define how the value for these fields appear in the log lines
        :param pulumi.Input[Union['DatastreamDeliveryConfigurationArgs', 'DatastreamDeliveryConfigurationArgsDict']] delivery_configuration: Provides information about the configuration related to logs (format, file names, delivery frequency)
        :param pulumi.Input[_builtins.str] group_id: Identifies the group that has access to the product and for which the stream configuration was created
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: List of email addresses where the system sends notifications about activations and deactivations of the stream
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] properties: Identifies the properties monitored in the stream
        :param pulumi.Input[_builtins.str] stream_name: The name of the stream
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatastreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Datastream resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DatastreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatastreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_connector: Optional[pulumi.Input[Union['DatastreamAzureConnectorArgs', 'DatastreamAzureConnectorArgsDict']]] = None,
                 collect_midgress: Optional[pulumi.Input[_builtins.bool]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datadog_connector: Optional[pulumi.Input[Union['DatastreamDatadogConnectorArgs', 'DatastreamDatadogConnectorArgsDict']]] = None,
                 dataset_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 delivery_configuration: Optional[pulumi.Input[Union['DatastreamDeliveryConfigurationArgs', 'DatastreamDeliveryConfigurationArgsDict']]] = None,
                 elasticsearch_connector: Optional[pulumi.Input[Union['DatastreamElasticsearchConnectorArgs', 'DatastreamElasticsearchConnectorArgsDict']]] = None,
                 gcs_connector: Optional[pulumi.Input[Union['DatastreamGcsConnectorArgs', 'DatastreamGcsConnectorArgsDict']]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 https_connector: Optional[pulumi.Input[Union['DatastreamHttpsConnectorArgs', 'DatastreamHttpsConnectorArgsDict']]] = None,
                 loggly_connector: Optional[pulumi.Input[Union['DatastreamLogglyConnectorArgs', 'DatastreamLogglyConnectorArgsDict']]] = None,
                 new_relic_connector: Optional[pulumi.Input[Union['DatastreamNewRelicConnectorArgs', 'DatastreamNewRelicConnectorArgsDict']]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 oracle_connector: Optional[pulumi.Input[Union['DatastreamOracleConnectorArgs', 'DatastreamOracleConnectorArgsDict']]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 s3_connector: Optional[pulumi.Input[Union['DatastreamS3ConnectorArgs', 'DatastreamS3ConnectorArgsDict']]] = None,
                 splunk_connector: Optional[pulumi.Input[Union['DatastreamSplunkConnectorArgs', 'DatastreamSplunkConnectorArgsDict']]] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sumologic_connector: Optional[pulumi.Input[Union['DatastreamSumologicConnectorArgs', 'DatastreamSumologicConnectorArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatastreamArgs.__new__(DatastreamArgs)

            if active is None and not opts.urn:
                raise TypeError("Missing required property 'active'")
            __props__.__dict__["active"] = active
            __props__.__dict__["azure_connector"] = azure_connector
            __props__.__dict__["collect_midgress"] = collect_midgress
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            __props__.__dict__["datadog_connector"] = datadog_connector
            if dataset_fields is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_fields'")
            __props__.__dict__["dataset_fields"] = dataset_fields
            if delivery_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_configuration'")
            __props__.__dict__["delivery_configuration"] = delivery_configuration
            __props__.__dict__["elasticsearch_connector"] = elasticsearch_connector
            __props__.__dict__["gcs_connector"] = gcs_connector
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["https_connector"] = https_connector
            __props__.__dict__["loggly_connector"] = loggly_connector
            __props__.__dict__["new_relic_connector"] = new_relic_connector
            __props__.__dict__["notification_emails"] = notification_emails
            __props__.__dict__["oracle_connector"] = oracle_connector
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            __props__.__dict__["s3_connector"] = s3_connector
            __props__.__dict__["splunk_connector"] = splunk_connector
            if stream_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_name'")
            __props__.__dict__["stream_name"] = stream_name
            __props__.__dict__["sumologic_connector"] = sumologic_connector
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["modified_by"] = None
            __props__.__dict__["modified_date"] = None
            __props__.__dict__["papi_json"] = None
            __props__.__dict__["product_id"] = None
            __props__.__dict__["stream_version"] = None
        super(Datastream, __self__).__init__(
            'akamai:index/datastream:Datastream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            azure_connector: Optional[pulumi.Input[Union['DatastreamAzureConnectorArgs', 'DatastreamAzureConnectorArgsDict']]] = None,
            collect_midgress: Optional[pulumi.Input[_builtins.bool]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_date: Optional[pulumi.Input[_builtins.str]] = None,
            datadog_connector: Optional[pulumi.Input[Union['DatastreamDatadogConnectorArgs', 'DatastreamDatadogConnectorArgsDict']]] = None,
            dataset_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            delivery_configuration: Optional[pulumi.Input[Union['DatastreamDeliveryConfigurationArgs', 'DatastreamDeliveryConfigurationArgsDict']]] = None,
            elasticsearch_connector: Optional[pulumi.Input[Union['DatastreamElasticsearchConnectorArgs', 'DatastreamElasticsearchConnectorArgsDict']]] = None,
            gcs_connector: Optional[pulumi.Input[Union['DatastreamGcsConnectorArgs', 'DatastreamGcsConnectorArgsDict']]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            https_connector: Optional[pulumi.Input[Union['DatastreamHttpsConnectorArgs', 'DatastreamHttpsConnectorArgsDict']]] = None,
            latest_version: Optional[pulumi.Input[_builtins.int]] = None,
            loggly_connector: Optional[pulumi.Input[Union['DatastreamLogglyConnectorArgs', 'DatastreamLogglyConnectorArgsDict']]] = None,
            modified_by: Optional[pulumi.Input[_builtins.str]] = None,
            modified_date: Optional[pulumi.Input[_builtins.str]] = None,
            new_relic_connector: Optional[pulumi.Input[Union['DatastreamNewRelicConnectorArgs', 'DatastreamNewRelicConnectorArgsDict']]] = None,
            notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            oracle_connector: Optional[pulumi.Input[Union['DatastreamOracleConnectorArgs', 'DatastreamOracleConnectorArgsDict']]] = None,
            papi_json: Optional[pulumi.Input[_builtins.str]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            s3_connector: Optional[pulumi.Input[Union['DatastreamS3ConnectorArgs', 'DatastreamS3ConnectorArgsDict']]] = None,
            splunk_connector: Optional[pulumi.Input[Union['DatastreamSplunkConnectorArgs', 'DatastreamSplunkConnectorArgsDict']]] = None,
            stream_name: Optional[pulumi.Input[_builtins.str]] = None,
            stream_version: Optional[pulumi.Input[_builtins.int]] = None,
            sumologic_connector: Optional[pulumi.Input[Union['DatastreamSumologicConnectorArgs', 'DatastreamSumologicConnectorArgsDict']]] = None) -> 'Datastream':
        """
        Get an existing Datastream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Defining if stream should be active or not
        :param pulumi.Input[_builtins.bool] collect_midgress: Identifies if stream needs to collect midgress data
        :param pulumi.Input[_builtins.str] contract_id: Identifies the contract that has access to the product
        :param pulumi.Input[_builtins.str] created_by: The username who created the stream
        :param pulumi.Input[_builtins.str] created_date: The date and time when the stream was created
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] dataset_fields: A list of data set fields selected from the associated template that the stream monitors in logs. The order of the identifiers define how the value for these fields appear in the log lines
        :param pulumi.Input[Union['DatastreamDeliveryConfigurationArgs', 'DatastreamDeliveryConfigurationArgsDict']] delivery_configuration: Provides information about the configuration related to logs (format, file names, delivery frequency)
        :param pulumi.Input[_builtins.str] group_id: Identifies the group that has access to the product and for which the stream configuration was created
        :param pulumi.Input[_builtins.int] latest_version: Identifies the latest active configuration version of the stream
        :param pulumi.Input[_builtins.str] modified_by: The username who modified the stream
        :param pulumi.Input[_builtins.str] modified_date: The date and time when the stream was modified
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: List of email addresses where the system sends notifications about activations and deactivations of the stream
        :param pulumi.Input[_builtins.str] papi_json: The configuration in JSON format that can be copy-pasted into PAPI configuration to enable datastream behavior
        :param pulumi.Input[_builtins.str] product_id: The ID of the product for which the stream was created
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] properties: Identifies the properties monitored in the stream
        :param pulumi.Input[_builtins.str] stream_name: The name of the stream
        :param pulumi.Input[_builtins.int] stream_version: Identifies the configuration version of the stream
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatastreamState.__new__(_DatastreamState)

        __props__.__dict__["active"] = active
        __props__.__dict__["azure_connector"] = azure_connector
        __props__.__dict__["collect_midgress"] = collect_midgress
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["datadog_connector"] = datadog_connector
        __props__.__dict__["dataset_fields"] = dataset_fields
        __props__.__dict__["delivery_configuration"] = delivery_configuration
        __props__.__dict__["elasticsearch_connector"] = elasticsearch_connector
        __props__.__dict__["gcs_connector"] = gcs_connector
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["https_connector"] = https_connector
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["loggly_connector"] = loggly_connector
        __props__.__dict__["modified_by"] = modified_by
        __props__.__dict__["modified_date"] = modified_date
        __props__.__dict__["new_relic_connector"] = new_relic_connector
        __props__.__dict__["notification_emails"] = notification_emails
        __props__.__dict__["oracle_connector"] = oracle_connector
        __props__.__dict__["papi_json"] = papi_json
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["properties"] = properties
        __props__.__dict__["s3_connector"] = s3_connector
        __props__.__dict__["splunk_connector"] = splunk_connector
        __props__.__dict__["stream_name"] = stream_name
        __props__.__dict__["stream_version"] = stream_version
        __props__.__dict__["sumologic_connector"] = sumologic_connector
        return Datastream(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[_builtins.bool]:
        """
        Defining if stream should be active or not
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="azureConnector")
    def azure_connector(self) -> pulumi.Output[Optional['outputs.DatastreamAzureConnector']]:
        return pulumi.get(self, "azure_connector")

    @_builtins.property
    @pulumi.getter(name="collectMidgress")
    def collect_midgress(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Identifies if stream needs to collect midgress data
        """
        return pulumi.get(self, "collect_midgress")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the contract that has access to the product
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The username who created the stream
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the stream was created
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter(name="datadogConnector")
    def datadog_connector(self) -> pulumi.Output[Optional['outputs.DatastreamDatadogConnector']]:
        return pulumi.get(self, "datadog_connector")

    @_builtins.property
    @pulumi.getter(name="datasetFields")
    def dataset_fields(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        A list of data set fields selected from the associated template that the stream monitors in logs. The order of the identifiers define how the value for these fields appear in the log lines
        """
        return pulumi.get(self, "dataset_fields")

    @_builtins.property
    @pulumi.getter(name="deliveryConfiguration")
    def delivery_configuration(self) -> pulumi.Output['outputs.DatastreamDeliveryConfiguration']:
        """
        Provides information about the configuration related to logs (format, file names, delivery frequency)
        """
        return pulumi.get(self, "delivery_configuration")

    @_builtins.property
    @pulumi.getter(name="elasticsearchConnector")
    def elasticsearch_connector(self) -> pulumi.Output[Optional['outputs.DatastreamElasticsearchConnector']]:
        return pulumi.get(self, "elasticsearch_connector")

    @_builtins.property
    @pulumi.getter(name="gcsConnector")
    def gcs_connector(self) -> pulumi.Output[Optional['outputs.DatastreamGcsConnector']]:
        return pulumi.get(self, "gcs_connector")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the group that has access to the product and for which the stream configuration was created
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="httpsConnector")
    def https_connector(self) -> pulumi.Output[Optional['outputs.DatastreamHttpsConnector']]:
        return pulumi.get(self, "https_connector")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[_builtins.int]:
        """
        Identifies the latest active configuration version of the stream
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter(name="logglyConnector")
    def loggly_connector(self) -> pulumi.Output[Optional['outputs.DatastreamLogglyConnector']]:
        return pulumi.get(self, "loggly_connector")

    @_builtins.property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> pulumi.Output[_builtins.str]:
        """
        The username who modified the stream
        """
        return pulumi.get(self, "modified_by")

    @_builtins.property
    @pulumi.getter(name="modifiedDate")
    def modified_date(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the stream was modified
        """
        return pulumi.get(self, "modified_date")

    @_builtins.property
    @pulumi.getter(name="newRelicConnector")
    def new_relic_connector(self) -> pulumi.Output[Optional['outputs.DatastreamNewRelicConnector']]:
        return pulumi.get(self, "new_relic_connector")

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of email addresses where the system sends notifications about activations and deactivations of the stream
        """
        return pulumi.get(self, "notification_emails")

    @_builtins.property
    @pulumi.getter(name="oracleConnector")
    def oracle_connector(self) -> pulumi.Output[Optional['outputs.DatastreamOracleConnector']]:
        return pulumi.get(self, "oracle_connector")

    @_builtins.property
    @pulumi.getter(name="papiJson")
    def papi_json(self) -> pulumi.Output[_builtins.str]:
        """
        The configuration in JSON format that can be copy-pasted into PAPI configuration to enable datastream behavior
        """
        return pulumi.get(self, "papi_json")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the product for which the stream was created
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Identifies the properties monitored in the stream
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="s3Connector")
    def s3_connector(self) -> pulumi.Output[Optional['outputs.DatastreamS3Connector']]:
        return pulumi.get(self, "s3_connector")

    @_builtins.property
    @pulumi.getter(name="splunkConnector")
    def splunk_connector(self) -> pulumi.Output[Optional['outputs.DatastreamSplunkConnector']]:
        return pulumi.get(self, "splunk_connector")

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the stream
        """
        return pulumi.get(self, "stream_name")

    @_builtins.property
    @pulumi.getter(name="streamVersion")
    def stream_version(self) -> pulumi.Output[_builtins.int]:
        """
        Identifies the configuration version of the stream
        """
        return pulumi.get(self, "stream_version")

    @_builtins.property
    @pulumi.getter(name="sumologicConnector")
    def sumologic_connector(self) -> pulumi.Output[Optional['outputs.DatastreamSumologicConnector']]:
        return pulumi.get(self, "sumologic_connector")

