# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeWorkerArgs', 'EdgeWorker']

@pulumi.input_type
class EdgeWorkerArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.int],
                 resource_tier_id: pulumi.Input[_builtins.int],
                 local_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['EdgeWorkerTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a EdgeWorker resource.
        :param pulumi.Input[_builtins.int] group_id: Defines the group association for the EdgeWorker
        :param pulumi.Input[_builtins.int] resource_tier_id: The unique identifier of a resource tier
        :param pulumi.Input[_builtins.str] local_bundle: The path to the EdgeWorkers tgz code bundle
        :param pulumi.Input[_builtins.str] name: The EdgeWorker name
        :param pulumi.Input['EdgeWorkerTimeoutsArgs'] timeouts: Enables to set timeout for processing
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "resource_tier_id", resource_tier_id)
        if local_bundle is not None:
            pulumi.set(__self__, "local_bundle", local_bundle)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.int]:
        """
        Defines the group association for the EdgeWorker
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceTierId")
    def resource_tier_id(self) -> pulumi.Input[_builtins.int]:
        """
        The unique identifier of a resource tier
        """
        return pulumi.get(self, "resource_tier_id")

    @resource_tier_id.setter
    def resource_tier_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "resource_tier_id", value)

    @_builtins.property
    @pulumi.getter(name="localBundle")
    def local_bundle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the EdgeWorkers tgz code bundle
        """
        return pulumi.get(self, "local_bundle")

    @local_bundle.setter
    def local_bundle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_bundle", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EdgeWorker name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EdgeWorkerTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EdgeWorkerTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _EdgeWorkerState:
    def __init__(__self__, *,
                 edgeworker_id: Optional[pulumi.Input[_builtins.int]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 local_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 local_bundle_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tier_id: Optional[pulumi.Input[_builtins.int]] = None,
                 timeouts: Optional[pulumi.Input['EdgeWorkerTimeoutsArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering EdgeWorker resources.
        :param pulumi.Input[_builtins.int] edgeworker_id: The unique identifier of the EdgeWorker
        :param pulumi.Input[_builtins.int] group_id: Defines the group association for the EdgeWorker
        :param pulumi.Input[_builtins.str] local_bundle: The path to the EdgeWorkers tgz code bundle
        :param pulumi.Input[_builtins.str] local_bundle_hash: The local bundle hash for the EdgeWorker
        :param pulumi.Input[_builtins.str] name: The EdgeWorker name
        :param pulumi.Input[_builtins.int] resource_tier_id: The unique identifier of a resource tier
        :param pulumi.Input['EdgeWorkerTimeoutsArgs'] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] version: The bundle version
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] warnings: The list of warnings returned by EdgeWorker validation
        """
        if edgeworker_id is not None:
            pulumi.set(__self__, "edgeworker_id", edgeworker_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if local_bundle is not None:
            pulumi.set(__self__, "local_bundle", local_bundle)
        if local_bundle_hash is not None:
            pulumi.set(__self__, "local_bundle_hash", local_bundle_hash)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_tier_id is not None:
            pulumi.set(__self__, "resource_tier_id", resource_tier_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if warnings is not None:
            pulumi.set(__self__, "warnings", warnings)

    @_builtins.property
    @pulumi.getter(name="edgeworkerId")
    def edgeworker_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of the EdgeWorker
        """
        return pulumi.get(self, "edgeworker_id")

    @edgeworker_id.setter
    def edgeworker_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "edgeworker_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the group association for the EdgeWorker
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="localBundle")
    def local_bundle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the EdgeWorkers tgz code bundle
        """
        return pulumi.get(self, "local_bundle")

    @local_bundle.setter
    def local_bundle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_bundle", value)

    @_builtins.property
    @pulumi.getter(name="localBundleHash")
    def local_bundle_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The local bundle hash for the EdgeWorker
        """
        return pulumi.get(self, "local_bundle_hash")

    @local_bundle_hash.setter
    def local_bundle_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_bundle_hash", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EdgeWorker name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceTierId")
    def resource_tier_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of a resource tier
        """
        return pulumi.get(self, "resource_tier_id")

    @resource_tier_id.setter
    def resource_tier_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_tier_id", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EdgeWorkerTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EdgeWorkerTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bundle version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of warnings returned by EdgeWorker validation
        """
        return pulumi.get(self, "warnings")

    @warnings.setter
    def warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "warnings", value)


@pulumi.type_token("akamai:index/edgeWorker:EdgeWorker")
class EdgeWorker(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 local_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tier_id: Optional[pulumi.Input[_builtins.int]] = None,
                 timeouts: Optional[pulumi.Input[Union['EdgeWorkerTimeoutsArgs', 'EdgeWorkerTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Create a EdgeWorker resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] group_id: Defines the group association for the EdgeWorker
        :param pulumi.Input[_builtins.str] local_bundle: The path to the EdgeWorkers tgz code bundle
        :param pulumi.Input[_builtins.str] name: The EdgeWorker name
        :param pulumi.Input[_builtins.int] resource_tier_id: The unique identifier of a resource tier
        :param pulumi.Input[Union['EdgeWorkerTimeoutsArgs', 'EdgeWorkerTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeWorkerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a EdgeWorker resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param EdgeWorkerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeWorkerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 local_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tier_id: Optional[pulumi.Input[_builtins.int]] = None,
                 timeouts: Optional[pulumi.Input[Union['EdgeWorkerTimeoutsArgs', 'EdgeWorkerTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeWorkerArgs.__new__(EdgeWorkerArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["local_bundle"] = local_bundle
            __props__.__dict__["name"] = name
            if resource_tier_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_tier_id'")
            __props__.__dict__["resource_tier_id"] = resource_tier_id
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["edgeworker_id"] = None
            __props__.__dict__["local_bundle_hash"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["warnings"] = None
        super(EdgeWorker, __self__).__init__(
            'akamai:index/edgeWorker:EdgeWorker',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            edgeworker_id: Optional[pulumi.Input[_builtins.int]] = None,
            group_id: Optional[pulumi.Input[_builtins.int]] = None,
            local_bundle: Optional[pulumi.Input[_builtins.str]] = None,
            local_bundle_hash: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_tier_id: Optional[pulumi.Input[_builtins.int]] = None,
            timeouts: Optional[pulumi.Input[Union['EdgeWorkerTimeoutsArgs', 'EdgeWorkerTimeoutsArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'EdgeWorker':
        """
        Get an existing EdgeWorker resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] edgeworker_id: The unique identifier of the EdgeWorker
        :param pulumi.Input[_builtins.int] group_id: Defines the group association for the EdgeWorker
        :param pulumi.Input[_builtins.str] local_bundle: The path to the EdgeWorkers tgz code bundle
        :param pulumi.Input[_builtins.str] local_bundle_hash: The local bundle hash for the EdgeWorker
        :param pulumi.Input[_builtins.str] name: The EdgeWorker name
        :param pulumi.Input[_builtins.int] resource_tier_id: The unique identifier of a resource tier
        :param pulumi.Input[Union['EdgeWorkerTimeoutsArgs', 'EdgeWorkerTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] version: The bundle version
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] warnings: The list of warnings returned by EdgeWorker validation
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeWorkerState.__new__(_EdgeWorkerState)

        __props__.__dict__["edgeworker_id"] = edgeworker_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["local_bundle"] = local_bundle
        __props__.__dict__["local_bundle_hash"] = local_bundle_hash
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_tier_id"] = resource_tier_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["version"] = version
        __props__.__dict__["warnings"] = warnings
        return EdgeWorker(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="edgeworkerId")
    def edgeworker_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of the EdgeWorker
        """
        return pulumi.get(self, "edgeworker_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.int]:
        """
        Defines the group association for the EdgeWorker
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="localBundle")
    def local_bundle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to the EdgeWorkers tgz code bundle
        """
        return pulumi.get(self, "local_bundle")

    @_builtins.property
    @pulumi.getter(name="localBundleHash")
    def local_bundle_hash(self) -> pulumi.Output[_builtins.str]:
        """
        The local bundle hash for the EdgeWorker
        """
        return pulumi.get(self, "local_bundle_hash")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The EdgeWorker name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceTierId")
    def resource_tier_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of a resource tier
        """
        return pulumi.get(self, "resource_tier_id")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.EdgeWorkerTimeouts']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The bundle version
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def warnings(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of warnings returned by EdgeWorker validation
        """
        return pulumi.get(self, "warnings")

