# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PropertyActivationArgs', 'PropertyActivation']

@pulumi.input_type
class PropertyActivationArgs:
    def __init__(__self__, *,
                 contacts: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 property_id: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.int],
                 activation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 compliance_record: Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['PropertyActivationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a PropertyActivation resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contacts: One or more email addresses to which to send activation status changes.
        :param pulumi.Input[_builtins.str] property_id: Your property's ID, including the prp_ prefix.
        :param pulumi.Input[_builtins.int] version: Your property's version number.
        :param pulumi.Input[_builtins.str] activation_id: The ID given to the activation event while it's in progress.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation to continue. Default is false
        :param pulumi.Input['PropertyActivationComplianceRecordArgs'] compliance_record: Provides an audit record when activating on a production network.
        :param pulumi.Input[_builtins.str] network: Akamai network in which to activate your property, either STAGING or PRODUCTION. The default is STAGING.
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the activation request.
        :param pulumi.Input['PropertyActivationTimeoutsArgs'] timeouts: Enables to set timeout for processing.
        """
        pulumi.set(__self__, "contacts", contacts)
        pulumi.set(__self__, "property_id", property_id)
        pulumi.set(__self__, "version", version)
        if activation_id is not None:
            pulumi.set(__self__, "activation_id", activation_id)
        if auto_acknowledge_rule_warnings is not None:
            pulumi.set(__self__, "auto_acknowledge_rule_warnings", auto_acknowledge_rule_warnings)
        if compliance_record is not None:
            pulumi.set(__self__, "compliance_record", compliance_record)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def contacts(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        One or more email addresses to which to send activation status changes.
        """
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "contacts", value)

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> pulumi.Input[_builtins.str]:
        """
        Your property's ID, including the prp_ prefix.
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.int]:
        """
        Your property's version number.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID given to the activation event while it's in progress.
        """
        return pulumi.get(self, "activation_id")

    @activation_id.setter
    def activation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activation_id", value)

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically acknowledge all rule warnings for activation to continue. Default is false
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @auto_acknowledge_rule_warnings.setter
    def auto_acknowledge_rule_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_acknowledge_rule_warnings", value)

    @_builtins.property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']]:
        """
        Provides an audit record when activating on a production network.
        """
        return pulumi.get(self, "compliance_record")

    @compliance_record.setter
    def compliance_record(self, value: Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']]):
        pulumi.set(self, "compliance_record", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Akamai network in which to activate your property, either STAGING or PRODUCTION. The default is STAGING.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assigns a log message to the activation request.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['PropertyActivationTimeoutsArgs']]:
        """
        Enables to set timeout for processing.
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['PropertyActivationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _PropertyActivationState:
    def __init__(__self__, *,
                 activation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 compliance_record: Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 errors: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['PropertyActivationTimeoutsArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 warnings: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PropertyActivation resources.
        :param pulumi.Input[_builtins.str] activation_id: The ID given to the activation event while it's in progress.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation to continue. Default is false
        :param pulumi.Input['PropertyActivationComplianceRecordArgs'] compliance_record: Provides an audit record when activating on a production network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contacts: One or more email addresses to which to send activation status changes.
        :param pulumi.Input[_builtins.str] errors: Errors returned during activation.
        :param pulumi.Input[_builtins.str] network: Akamai network in which to activate your property, either STAGING or PRODUCTION. The default is STAGING.
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the activation request.
        :param pulumi.Input[_builtins.str] property_id: Your property's ID, including the prp_ prefix.
        :param pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]] rule_errors: Any errors returned by the API about rules.
        :param pulumi.Input[_builtins.str] status: The property version's activation status on the given network.
        :param pulumi.Input['PropertyActivationTimeoutsArgs'] timeouts: Enables to set timeout for processing.
        :param pulumi.Input[_builtins.int] version: Your property's version number.
        :param pulumi.Input[_builtins.str] warnings: Warnings returned during activation.
        """
        if activation_id is not None:
            pulumi.set(__self__, "activation_id", activation_id)
        if auto_acknowledge_rule_warnings is not None:
            pulumi.set(__self__, "auto_acknowledge_rule_warnings", auto_acknowledge_rule_warnings)
        if compliance_record is not None:
            pulumi.set(__self__, "compliance_record", compliance_record)
        if contacts is not None:
            pulumi.set(__self__, "contacts", contacts)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if rule_errors is not None:
            pulumi.set(__self__, "rule_errors", rule_errors)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if warnings is not None:
            pulumi.set(__self__, "warnings", warnings)

    @_builtins.property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID given to the activation event while it's in progress.
        """
        return pulumi.get(self, "activation_id")

    @activation_id.setter
    def activation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activation_id", value)

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically acknowledge all rule warnings for activation to continue. Default is false
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @auto_acknowledge_rule_warnings.setter
    def auto_acknowledge_rule_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_acknowledge_rule_warnings", value)

    @_builtins.property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']]:
        """
        Provides an audit record when activating on a production network.
        """
        return pulumi.get(self, "compliance_record")

    @compliance_record.setter
    def compliance_record(self, value: Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']]):
        pulumi.set(self, "compliance_record", value)

    @_builtins.property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more email addresses to which to send activation status changes.
        """
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "contacts", value)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Errors returned during activation.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "errors", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Akamai network in which to activate your property, either STAGING or PRODUCTION. The default is STAGING.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assigns a log message to the activation request.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your property's ID, including the prp_ prefix.
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]]:
        """
        Any errors returned by the API about rules.
        """
        return pulumi.get(self, "rule_errors")

    @rule_errors.setter
    def rule_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]]):
        pulumi.set(self, "rule_errors", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property version's activation status on the given network.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['PropertyActivationTimeoutsArgs']]:
        """
        Enables to set timeout for processing.
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['PropertyActivationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Your property's version number.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def warnings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Warnings returned during activation.
        """
        return pulumi.get(self, "warnings")

    @warnings.setter
    def warnings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warnings", value)


@pulumi.type_token("akamai:index/propertyActivation:PropertyActivation")
class PropertyActivation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 compliance_record: Optional[pulumi.Input[Union['PropertyActivationComplianceRecordArgs', 'PropertyActivationComplianceRecordArgsDict']]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['PropertyActivationTimeoutsArgs', 'PropertyActivationTimeoutsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a PropertyActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activation_id: The ID given to the activation event while it's in progress.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation to continue. Default is false
        :param pulumi.Input[Union['PropertyActivationComplianceRecordArgs', 'PropertyActivationComplianceRecordArgsDict']] compliance_record: Provides an audit record when activating on a production network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contacts: One or more email addresses to which to send activation status changes.
        :param pulumi.Input[_builtins.str] network: Akamai network in which to activate your property, either STAGING or PRODUCTION. The default is STAGING.
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the activation request.
        :param pulumi.Input[_builtins.str] property_id: Your property's ID, including the prp_ prefix.
        :param pulumi.Input[Union['PropertyActivationTimeoutsArgs', 'PropertyActivationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing.
        :param pulumi.Input[_builtins.int] version: Your property's version number.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyActivationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PropertyActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyActivationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyActivationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 compliance_record: Optional[pulumi.Input[Union['PropertyActivationComplianceRecordArgs', 'PropertyActivationComplianceRecordArgsDict']]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['PropertyActivationTimeoutsArgs', 'PropertyActivationTimeoutsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyActivationArgs.__new__(PropertyActivationArgs)

            __props__.__dict__["activation_id"] = activation_id
            __props__.__dict__["auto_acknowledge_rule_warnings"] = auto_acknowledge_rule_warnings
            __props__.__dict__["compliance_record"] = compliance_record
            if contacts is None and not opts.urn:
                raise TypeError("Missing required property 'contacts'")
            __props__.__dict__["contacts"] = contacts
            __props__.__dict__["network"] = network
            __props__.__dict__["note"] = note
            if property_id is None and not opts.urn:
                raise TypeError("Missing required property 'property_id'")
            __props__.__dict__["property_id"] = property_id
            __props__.__dict__["timeouts"] = timeouts
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["errors"] = None
            __props__.__dict__["rule_errors"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["warnings"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="akamai:properties/propertyActivation:PropertyActivation")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(PropertyActivation, __self__).__init__(
            'akamai:index/propertyActivation:PropertyActivation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_id: Optional[pulumi.Input[_builtins.str]] = None,
            auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
            compliance_record: Optional[pulumi.Input[Union['PropertyActivationComplianceRecordArgs', 'PropertyActivationComplianceRecordArgsDict']]] = None,
            contacts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            errors: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            note: Optional[pulumi.Input[_builtins.str]] = None,
            property_id: Optional[pulumi.Input[_builtins.str]] = None,
            rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyActivationRuleErrorArgs', 'PropertyActivationRuleErrorArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['PropertyActivationTimeoutsArgs', 'PropertyActivationTimeoutsArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None,
            warnings: Optional[pulumi.Input[_builtins.str]] = None) -> 'PropertyActivation':
        """
        Get an existing PropertyActivation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activation_id: The ID given to the activation event while it's in progress.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation to continue. Default is false
        :param pulumi.Input[Union['PropertyActivationComplianceRecordArgs', 'PropertyActivationComplianceRecordArgsDict']] compliance_record: Provides an audit record when activating on a production network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] contacts: One or more email addresses to which to send activation status changes.
        :param pulumi.Input[_builtins.str] errors: Errors returned during activation.
        :param pulumi.Input[_builtins.str] network: Akamai network in which to activate your property, either STAGING or PRODUCTION. The default is STAGING.
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the activation request.
        :param pulumi.Input[_builtins.str] property_id: Your property's ID, including the prp_ prefix.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PropertyActivationRuleErrorArgs', 'PropertyActivationRuleErrorArgsDict']]]] rule_errors: Any errors returned by the API about rules.
        :param pulumi.Input[_builtins.str] status: The property version's activation status on the given network.
        :param pulumi.Input[Union['PropertyActivationTimeoutsArgs', 'PropertyActivationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing.
        :param pulumi.Input[_builtins.int] version: Your property's version number.
        :param pulumi.Input[_builtins.str] warnings: Warnings returned during activation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyActivationState.__new__(_PropertyActivationState)

        __props__.__dict__["activation_id"] = activation_id
        __props__.__dict__["auto_acknowledge_rule_warnings"] = auto_acknowledge_rule_warnings
        __props__.__dict__["compliance_record"] = compliance_record
        __props__.__dict__["contacts"] = contacts
        __props__.__dict__["errors"] = errors
        __props__.__dict__["network"] = network
        __props__.__dict__["note"] = note
        __props__.__dict__["property_id"] = property_id
        __props__.__dict__["rule_errors"] = rule_errors
        __props__.__dict__["status"] = status
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["version"] = version
        __props__.__dict__["warnings"] = warnings
        return PropertyActivation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID given to the activation event while it's in progress.
        """
        return pulumi.get(self, "activation_id")

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Automatically acknowledge all rule warnings for activation to continue. Default is false
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @_builtins.property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> pulumi.Output[Optional['outputs.PropertyActivationComplianceRecord']]:
        """
        Provides an audit record when activating on a production network.
        """
        return pulumi.get(self, "compliance_record")

    @_builtins.property
    @pulumi.getter
    def contacts(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        One or more email addresses to which to send activation status changes.
        """
        return pulumi.get(self, "contacts")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> pulumi.Output[_builtins.str]:
        """
        Errors returned during activation.
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Akamai network in which to activate your property, either STAGING or PRODUCTION. The default is STAGING.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Assigns a log message to the activation request.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> pulumi.Output[_builtins.str]:
        """
        Your property's ID, including the prp_ prefix.
        """
        return pulumi.get(self, "property_id")

    @_builtins.property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> pulumi.Output[Sequence['outputs.PropertyActivationRuleError']]:
        """
        Any errors returned by the API about rules.
        """
        return pulumi.get(self, "rule_errors")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The property version's activation status on the given network.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.PropertyActivationTimeouts']]:
        """
        Enables to set timeout for processing.
        """
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        Your property's version number.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def warnings(self) -> pulumi.Output[_builtins.str]:
        """
        Warnings returned during activation.
        """
        return pulumi.get(self, "warnings")

