# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PropertyBootstrapArgs', 'PropertyBootstrap']

@pulumi.input_type
class PropertyBootstrapArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 product_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a PropertyBootstrap resource.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[_builtins.bool] use_hostname_bucket: Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without incrementing property versions.
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "product_id", product_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if use_hostname_bucket is not None:
            pulumi.set(__self__, "use_hostname_bucket", use_hostname_bucket)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[_builtins.str]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="useHostnameBucket")
    def use_hostname_bucket(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without incrementing property versions.
        """
        return pulumi.get(self, "use_hostname_bucket")

    @use_hostname_bucket.setter
    def use_hostname_bucket(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_hostname_bucket", value)


@pulumi.input_type
class _PropertyBootstrapState:
    def __init__(__self__, *,
                 asset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering PropertyBootstrap resources.
        :param pulumi.Input[_builtins.str] asset_id: ID of the property in the Identity and Access Management API.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[_builtins.str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[_builtins.bool] use_hostname_bucket: Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without incrementing property versions.
        """
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if use_hostname_bucket is not None:
            pulumi.set(__self__, "use_hostname_bucket", use_hostname_bucket)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the property in the Identity and Access Management API.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asset_id", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="useHostnameBucket")
    def use_hostname_bucket(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without incrementing property versions.
        """
        return pulumi.get(self, "use_hostname_bucket")

    @use_hostname_bucket.setter
    def use_hostname_bucket(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_hostname_bucket", value)


@pulumi.type_token("akamai:index/propertyBootstrap:PropertyBootstrap")
class PropertyBootstrap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Create a PropertyBootstrap resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[_builtins.str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[_builtins.bool] use_hostname_bucket: Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without incrementing property versions.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyBootstrapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PropertyBootstrap resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyBootstrapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyBootstrapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyBootstrapArgs.__new__(PropertyBootstrapArgs)

            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["name"] = name
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["use_hostname_bucket"] = use_hostname_bucket
            __props__.__dict__["asset_id"] = None
        super(PropertyBootstrap, __self__).__init__(
            'akamai:index/propertyBootstrap:PropertyBootstrap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asset_id: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None) -> 'PropertyBootstrap':
        """
        Get an existing PropertyBootstrap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] asset_id: ID of the property in the Identity and Access Management API.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[_builtins.str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[_builtins.bool] use_hostname_bucket: Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without incrementing property versions.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyBootstrapState.__new__(_PropertyBootstrapState)

        __props__.__dict__["asset_id"] = asset_id
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["use_hostname_bucket"] = use_hostname_bucket
        return PropertyBootstrap(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the property in the Identity and Access Management API.
        """
        return pulumi.get(self, "asset_id")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[_builtins.str]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="useHostnameBucket")
    def use_hostname_bucket(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without incrementing property versions.
        """
        return pulumi.get(self, "use_hostname_bucket")

