# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PropertyIncludeActivationArgs', 'PropertyIncludeActivation']

@pulumi.input_type
class PropertyIncludeActivationArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 include_id: pulumi.Input[_builtins.str],
                 network: pulumi.Input[_builtins.str],
                 notify_emails: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 version: pulumi.Input[_builtins.int],
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 compliance_record: Optional[pulumi.Input['PropertyIncludeActivationComplianceRecordArgs']] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['PropertyIncludeActivationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a PropertyIncludeActivation resource.
        :param pulumi.Input[_builtins.str] contract_id: The contract under which the include is activated
        :param pulumi.Input[_builtins.str] group_id: The group under which the include is activated
        :param pulumi.Input[_builtins.str] include_id: The unique identifier of the include
        :param pulumi.Input[_builtins.str] network: The network for which the activation will be performed
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_emails: The list of email addresses to notify about an activation status
        :param pulumi.Input[_builtins.int] version: The unique identifier of the include
        :param pulumi.Input[_builtins.bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation and continue
        :param pulumi.Input['PropertyIncludeActivationComplianceRecordArgs'] compliance_record: Provides an audit record when activating on a production network
        :param pulumi.Input[_builtins.str] note: The note to assign to a log message of the activation request
        :param pulumi.Input['PropertyIncludeActivationTimeoutsArgs'] timeouts: Enables to set timeout for processing
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "include_id", include_id)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "notify_emails", notify_emails)
        pulumi.set(__self__, "version", version)
        if auto_acknowledge_rule_warnings is not None:
            pulumi.set(__self__, "auto_acknowledge_rule_warnings", auto_acknowledge_rule_warnings)
        if compliance_record is not None:
            pulumi.set(__self__, "compliance_record", compliance_record)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        The contract under which the include is activated
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The group under which the include is activated
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="includeId")
    def include_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the include
        """
        return pulumi.get(self, "include_id")

    @include_id.setter
    def include_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "include_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The network for which the activation will be performed
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="notifyEmails")
    def notify_emails(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of email addresses to notify about an activation status
        """
        return pulumi.get(self, "notify_emails")

    @notify_emails.setter
    def notify_emails(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "notify_emails", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.int]:
        """
        The unique identifier of the include
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically acknowledge all rule warnings for activation and continue
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @auto_acknowledge_rule_warnings.setter
    def auto_acknowledge_rule_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_acknowledge_rule_warnings", value)

    @_builtins.property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> Optional[pulumi.Input['PropertyIncludeActivationComplianceRecordArgs']]:
        """
        Provides an audit record when activating on a production network
        """
        return pulumi.get(self, "compliance_record")

    @compliance_record.setter
    def compliance_record(self, value: Optional[pulumi.Input['PropertyIncludeActivationComplianceRecordArgs']]):
        pulumi.set(self, "compliance_record", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The note to assign to a log message of the activation request
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['PropertyIncludeActivationTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['PropertyIncludeActivationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _PropertyIncludeActivationState:
    def __init__(__self__, *,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 compliance_record: Optional[pulumi.Input['PropertyIncludeActivationComplianceRecordArgs']] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 include_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['PropertyIncludeActivationTimeoutsArgs']] = None,
                 validations: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PropertyIncludeActivation resources.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation and continue
        :param pulumi.Input['PropertyIncludeActivationComplianceRecordArgs'] compliance_record: Provides an audit record when activating on a production network
        :param pulumi.Input[_builtins.str] contract_id: The contract under which the include is activated
        :param pulumi.Input[_builtins.str] group_id: The group under which the include is activated
        :param pulumi.Input[_builtins.str] include_id: The unique identifier of the include
        :param pulumi.Input[_builtins.str] network: The network for which the activation will be performed
        :param pulumi.Input[_builtins.str] note: The note to assign to a log message of the activation request
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_emails: The list of email addresses to notify about an activation status
        :param pulumi.Input['PropertyIncludeActivationTimeoutsArgs'] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] validations: The validation information in JSON format
        :param pulumi.Input[_builtins.int] version: The unique identifier of the include
        """
        if auto_acknowledge_rule_warnings is not None:
            pulumi.set(__self__, "auto_acknowledge_rule_warnings", auto_acknowledge_rule_warnings)
        if compliance_record is not None:
            pulumi.set(__self__, "compliance_record", compliance_record)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if include_id is not None:
            pulumi.set(__self__, "include_id", include_id)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if notify_emails is not None:
            pulumi.set(__self__, "notify_emails", notify_emails)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if validations is not None:
            pulumi.set(__self__, "validations", validations)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically acknowledge all rule warnings for activation and continue
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @auto_acknowledge_rule_warnings.setter
    def auto_acknowledge_rule_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_acknowledge_rule_warnings", value)

    @_builtins.property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> Optional[pulumi.Input['PropertyIncludeActivationComplianceRecordArgs']]:
        """
        Provides an audit record when activating on a production network
        """
        return pulumi.get(self, "compliance_record")

    @compliance_record.setter
    def compliance_record(self, value: Optional[pulumi.Input['PropertyIncludeActivationComplianceRecordArgs']]):
        pulumi.set(self, "compliance_record", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The contract under which the include is activated
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group under which the include is activated
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="includeId")
    def include_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the include
        """
        return pulumi.get(self, "include_id")

    @include_id.setter
    def include_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network for which the activation will be performed
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The note to assign to a log message of the activation request
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter(name="notifyEmails")
    def notify_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of email addresses to notify about an activation status
        """
        return pulumi.get(self, "notify_emails")

    @notify_emails.setter
    def notify_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notify_emails", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['PropertyIncludeActivationTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['PropertyIncludeActivationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def validations(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The validation information in JSON format
        """
        return pulumi.get(self, "validations")

    @validations.setter
    def validations(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validations", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of the include
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("akamai:index/propertyIncludeActivation:PropertyIncludeActivation")
class PropertyIncludeActivation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 compliance_record: Optional[pulumi.Input[Union['PropertyIncludeActivationComplianceRecordArgs', 'PropertyIncludeActivationComplianceRecordArgsDict']]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 include_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['PropertyIncludeActivationTimeoutsArgs', 'PropertyIncludeActivationTimeoutsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a PropertyIncludeActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation and continue
        :param pulumi.Input[Union['PropertyIncludeActivationComplianceRecordArgs', 'PropertyIncludeActivationComplianceRecordArgsDict']] compliance_record: Provides an audit record when activating on a production network
        :param pulumi.Input[_builtins.str] contract_id: The contract under which the include is activated
        :param pulumi.Input[_builtins.str] group_id: The group under which the include is activated
        :param pulumi.Input[_builtins.str] include_id: The unique identifier of the include
        :param pulumi.Input[_builtins.str] network: The network for which the activation will be performed
        :param pulumi.Input[_builtins.str] note: The note to assign to a log message of the activation request
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_emails: The list of email addresses to notify about an activation status
        :param pulumi.Input[Union['PropertyIncludeActivationTimeoutsArgs', 'PropertyIncludeActivationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.int] version: The unique identifier of the include
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyIncludeActivationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PropertyIncludeActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyIncludeActivationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyIncludeActivationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 compliance_record: Optional[pulumi.Input[Union['PropertyIncludeActivationComplianceRecordArgs', 'PropertyIncludeActivationComplianceRecordArgsDict']]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 include_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['PropertyIncludeActivationTimeoutsArgs', 'PropertyIncludeActivationTimeoutsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyIncludeActivationArgs.__new__(PropertyIncludeActivationArgs)

            __props__.__dict__["auto_acknowledge_rule_warnings"] = auto_acknowledge_rule_warnings
            __props__.__dict__["compliance_record"] = compliance_record
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if include_id is None and not opts.urn:
                raise TypeError("Missing required property 'include_id'")
            __props__.__dict__["include_id"] = include_id
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["note"] = note
            if notify_emails is None and not opts.urn:
                raise TypeError("Missing required property 'notify_emails'")
            __props__.__dict__["notify_emails"] = notify_emails
            __props__.__dict__["timeouts"] = timeouts
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["validations"] = None
        super(PropertyIncludeActivation, __self__).__init__(
            'akamai:index/propertyIncludeActivation:PropertyIncludeActivation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_acknowledge_rule_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
            compliance_record: Optional[pulumi.Input[Union['PropertyIncludeActivationComplianceRecordArgs', 'PropertyIncludeActivationComplianceRecordArgsDict']]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            include_id: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            note: Optional[pulumi.Input[_builtins.str]] = None,
            notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['PropertyIncludeActivationTimeoutsArgs', 'PropertyIncludeActivationTimeoutsArgsDict']]] = None,
            validations: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'PropertyIncludeActivation':
        """
        Get an existing PropertyIncludeActivation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation and continue
        :param pulumi.Input[Union['PropertyIncludeActivationComplianceRecordArgs', 'PropertyIncludeActivationComplianceRecordArgsDict']] compliance_record: Provides an audit record when activating on a production network
        :param pulumi.Input[_builtins.str] contract_id: The contract under which the include is activated
        :param pulumi.Input[_builtins.str] group_id: The group under which the include is activated
        :param pulumi.Input[_builtins.str] include_id: The unique identifier of the include
        :param pulumi.Input[_builtins.str] network: The network for which the activation will be performed
        :param pulumi.Input[_builtins.str] note: The note to assign to a log message of the activation request
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_emails: The list of email addresses to notify about an activation status
        :param pulumi.Input[Union['PropertyIncludeActivationTimeoutsArgs', 'PropertyIncludeActivationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] validations: The validation information in JSON format
        :param pulumi.Input[_builtins.int] version: The unique identifier of the include
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyIncludeActivationState.__new__(_PropertyIncludeActivationState)

        __props__.__dict__["auto_acknowledge_rule_warnings"] = auto_acknowledge_rule_warnings
        __props__.__dict__["compliance_record"] = compliance_record
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["include_id"] = include_id
        __props__.__dict__["network"] = network
        __props__.__dict__["note"] = note
        __props__.__dict__["notify_emails"] = notify_emails
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["validations"] = validations
        __props__.__dict__["version"] = version
        return PropertyIncludeActivation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Automatically acknowledge all rule warnings for activation and continue
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @_builtins.property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> pulumi.Output[Optional['outputs.PropertyIncludeActivationComplianceRecord']]:
        """
        Provides an audit record when activating on a production network
        """
        return pulumi.get(self, "compliance_record")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        The contract under which the include is activated
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The group under which the include is activated
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="includeId")
    def include_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the include
        """
        return pulumi.get(self, "include_id")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network for which the activation will be performed
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The note to assign to a log message of the activation request
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter(name="notifyEmails")
    def notify_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of email addresses to notify about an activation status
        """
        return pulumi.get(self, "notify_emails")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.PropertyIncludeActivationTimeouts']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def validations(self) -> pulumi.Output[_builtins.str]:
        """
        The validation information in JSON format
        """
        return pulumi.get(self, "validations")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of the include
        """
        return pulumi.get(self, "version")

