# Auto-generated by 'Node To Python' extension
# https://extensions.blender.org/add-ons/node-to-python/
import bpy


# initialize MN Compositor node group
def mn_compositor_node_group():
    mn_compositor = bpy.data.node_groups.new(
        type="CompositorNodeTree", name="MN Compositor"
    )

    mn_compositor.color_tag = "NONE"
    mn_compositor.description = ""
    mn_compositor.default_group_node_width = 140

    # mn_compositor interface
    # Socket Image
    image_socket = mn_compositor.interface.new_socket(
        name="Image", in_out="OUTPUT", socket_type="NodeSocketColor"
    )
    image_socket.default_value = (
        0.800000011920929,
        0.800000011920929,
        0.800000011920929,
        1.0,
    )
    image_socket.attribute_domain = "POINT"

    # Socket Image
    image_socket_1 = mn_compositor.interface.new_socket(
        name="Image", in_out="INPUT", socket_type="NodeSocketColor"
    )
    image_socket_1.default_value = (1.0, 1.0, 1.0, 1.0)
    image_socket_1.attribute_domain = "POINT"

    # initialize mn_compositor nodes
    # node Group Output
    group_output = mn_compositor.nodes.new("NodeGroupOutput")
    group_output.name = "Group Output"
    group_output.is_active_output = True

    # node Group Input
    group_input = mn_compositor.nodes.new("NodeGroupInput")
    group_input.name = "Group Input"

    # node Image
    image = mn_compositor.nodes.new("CompositorNodeImage")
    image.name = "Image"
    image.frame_duration = 1
    image.frame_offset = 0
    image.frame_start = 1
    if "mn_annotations" in bpy.data.images:
        image.image = bpy.data.images["mn_annotations"]
    image.use_auto_refresh = True
    image.use_cyclic = False
    image.use_straight_alpha_output = False

    # node Alpha Over
    alpha_over = mn_compositor.nodes.new("CompositorNodeAlphaOver")
    alpha_over.name = "Alpha Over"
    alpha_over.premul = 0.0
    alpha_over.use_premultiply = False
    # Fac
    alpha_over.inputs[0].default_value = 1.0

    # Set locations
    group_output.location = (380.0, 20.0)
    group_input.location = (0.0, 20.0)
    image.location = (0.0, -80.0)
    alpha_over.location = (200.0, -80.0)

    # Set dimensions
    group_output.width, group_output.height = 140.0, 100.0
    group_input.width, group_input.height = 140.0, 100.0
    image.width, image.height = 140.0, 100.0
    alpha_over.width, alpha_over.height = 140.0, 100.0

    # initialize mn_compositor links
    # alpha_over.Image -> group_output.Image
    mn_compositor.links.new(alpha_over.outputs[0], group_output.inputs[0])
    # image.Image -> alpha_over.Image
    mn_compositor.links.new(image.outputs[0], alpha_over.inputs[2])
    # group_input.Image -> alpha_over.Image
    mn_compositor.links.new(group_input.outputs[0], alpha_over.inputs[1])
    return mn_compositor
