#!/usr/bin/python3
# this is used to generate `src/translator/nb_prefix.h`
import os, sys
from glob import glob

path_nonbreaking_prefixes = sys.argv[1]

data = b"// auto-generated by 'dev/generate_ssplit_bundle.py', do not modify\n" \
       b"#ifndef SRC_KOTKI_NBPREFIX_H_\n" \
       b"#define SRC_KOTKI_NBPREFIX_H_\n" \
       b"#include <string>\n" \
       b"#include <map>\n\n" \
       b"using namespace std;\n\n"
lookup = {}

for path in glob(path_nonbreaking_prefixes + "/*_prefix.*"):
    basename = os.path.basename(path)
    ext = basename.split('.')[1].encode()
    var_name = b"nb_prefix_" + ext

    f = open(path, "rb")
    contents = f.read()
    f.close()

    data += b"const string " + var_name + b" "
    data += b" = R\"(\n"
    data += contents
    data += b")\";\n\n"

    lookup[ext] = var_name

data += b"const string nb_prefix_default = \"en\";\n"
data += b"const map<string, string> nb_prefix_lookup = {\n"
for lang_name, var_name in lookup.items():
    data += b"    {\"" + lang_name + b"\", " + var_name + b"},\n"

data = data[:-2] + b"\n"
data += b"};\n\n"
data += b"#endif"

print(data.decode())
