# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class FloatingIp(pulumi.CustomResource):
    address: pulumi.Output[str]
    """
    The actual floating IP address itself.
    """
    fixed_ip: pulumi.Output[str]
    """
    The fixed IP address corresponding to the floating IP.
    """
    instance_id: pulumi.Output[str]
    """
    UUID of the compute instance associated with the floating IP.
    """
    pool: pulumi.Output[str]
    """
    The name of the pool from which to obtain the floating
    IP. Changing this creates a new floating IP.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 Compute client.
    A Compute client is needed to create a floating IP that can be used with
    a compute instance. If omitted, the `region` argument of the provider
    is used. Changing this creates a new floating IP (which may or may not
    have a different address).
    """
    def __init__(__self__, resource_name, opts=None, pool=None, region=None, __name__=None, __opts__=None):
        """
        Manages a V2 floating IP resource within OpenStack Nova (compute)
        that can be used for compute instances.
        
        Please note that managing floating IPs through the OpenStack Compute API has
        been deprecated. Unless you are using an older OpenStack environment, it is
        recommended to use the `openstack_networking_floatingip_v2`
        resource instead, which uses the OpenStack Networking API.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] pool: The name of the pool from which to obtain the floating
               IP. Changing this creates a new floating IP.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Compute client.
               A Compute client is needed to create a floating IP that can be used with
               a compute instance. If omitted, the `region` argument of the provider
               is used. Changing this creates a new floating IP (which may or may not
               have a different address).

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/compute_floatingip_v2.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if pool is None:
            raise TypeError("Missing required property 'pool'")
        __props__['pool'] = pool

        __props__['region'] = region

        __props__['address'] = None
        __props__['fixed_ip'] = None
        __props__['instance_id'] = None

        super(FloatingIp, __self__).__init__(
            'openstack:compute/floatingIp:FloatingIp',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

