# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Keypair(pulumi.CustomResource):
    fingerprint: pulumi.Output[str]
    """
    The fingerprint of the public key.
    """
    name: pulumi.Output[str]
    """
    A unique name for the keypair. Changing this creates a new
    keypair.
    """
    private_key: pulumi.Output[str]
    """
    The generated private key when no public key is specified.
    """
    public_key: pulumi.Output[str]
    """
    A pregenerated OpenSSH-formatted public key.
    Changing this creates a new keypair. If a public key is not specified, then
    a public/private key pair will be automatically generated. If a pair is
    created, then destroying this resource means you will lose access to that
    keypair forever.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 Compute client.
    Keypairs are associated with accounts, but a Compute client is needed to
    create one. If omitted, the `region` argument of the provider is used.
    Changing this creates a new keypair.
    """
    value_specs: pulumi.Output[dict]
    """
    Map of additional options.
    """
    def __init__(__self__, resource_name, opts=None, name=None, public_key=None, region=None, value_specs=None, __name__=None, __opts__=None):
        """
        Create a Keypair resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: A unique name for the keypair. Changing this creates a new
               keypair.
        :param pulumi.Input[str] public_key: A pregenerated OpenSSH-formatted public key.
               Changing this creates a new keypair. If a public key is not specified, then
               a public/private key pair will be automatically generated. If a pair is
               created, then destroying this resource means you will lose access to that
               keypair forever.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Compute client.
               Keypairs are associated with accounts, but a Compute client is needed to
               create one. If omitted, the `region` argument of the provider is used.
               Changing this creates a new keypair.
        :param pulumi.Input[dict] value_specs: Map of additional options.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/compute_keypair_v2.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['name'] = name

        __props__['public_key'] = public_key

        __props__['region'] = region

        __props__['value_specs'] = value_specs

        __props__['fingerprint'] = None
        __props__['private_key'] = None

        super(Keypair, __self__).__init__(
            'openstack:compute/keypair:Keypair',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

