# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Configuration(pulumi.CustomResource):
    configurations: pulumi.Output[list]
    """
    An array of configuration parameter name and value. Can be specified multiple times. The configuration object structure is documented below.
    """
    datastore: pulumi.Output[dict]
    """
    An array of database engine type and version. The datastore
    object structure is documented below. Changing this creates resource.
    """
    description: pulumi.Output[str]
    """
    Description of the resource.
    """
    name: pulumi.Output[str]
    """
    A unique name for the resource.
    """
    region: pulumi.Output[str]
    """
    The region in which to create the db instance. Changing this
    creates a new instance.
    """
    def __init__(__self__, resource_name, opts=None, configurations=None, datastore=None, description=None, name=None, region=None, __name__=None, __opts__=None):
        """
        Manages a V1 DB configuration resource within OpenStack.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] configurations: An array of configuration parameter name and value. Can be specified multiple times. The configuration object structure is documented below.
        :param pulumi.Input[dict] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] name: A unique name for the resource.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/db_configuration_v1.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['configurations'] = configurations

        if datastore is None:
            raise TypeError("Missing required property 'datastore'")
        __props__['datastore'] = datastore

        if description is None:
            raise TypeError("Missing required property 'description'")
        __props__['description'] = description

        __props__['name'] = name

        __props__['region'] = region

        super(Configuration, __self__).__init__(
            'openstack:database/configuration:Configuration',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

