# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class ApplicationCredential(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    A description of the application credential.
    Changing this creates a new application credential.
    """
    expires_at: pulumi.Output[str]
    """
    The expiration time of the application credential
    in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted,
    an application credential will never expire. Changing this creates a new
    application credential.
    """
    name: pulumi.Output[str]
    """
    A name of the application credential. Changing this
    creates a new application credential.
    """
    project_id: pulumi.Output[str]
    """
    The ID of the project the application credential was created
    for and that authentication requests using this application credential will
    be scoped to.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V3 Keystone client.
    If omitted, the `region` argument of the provider is used. Changing this
    creates a new application credential.
    """
    roles: pulumi.Output[list]
    """
    A collection of one or more role names, which this
    application credential has to be associated with its project. If omitted,
    all the current user's roles within the scoped project will be inherited by
    a new application credential. Changing this creates a new application
    credential.
    """
    secret: pulumi.Output[str]
    """
    The secret for the application credential. If omitted,
    it will be generated by the server. Changing this creates a new application
    credential.
    """
    unrestricted: pulumi.Output[bool]
    """
    A flag indicating whether the application
    credential may be used for creation or destruction of other application
    credentials or trusts. Changing this creates a new application credential.
    """
    def __init__(__self__, resource_name, opts=None, description=None, expires_at=None, name=None, region=None, roles=None, secret=None, unrestricted=None, __name__=None, __opts__=None):
        """
        Manages a V3 Application Credential resource within OpenStack Keystone.
        
        > **Note:** All arguments including the application credential name and secret
        will be stored in the raw state as plain-text. [Read more about sensitive data
        in state](https://www.terraform.io/docs/state/sensitive-data.html).
        
        > **Note:** An Application Credential is created within the authenticated user
        project scope and is not visible by an admin or other accounts.
        The Application Credential visibility is similar to
        `openstack_compute_keypair_v2`.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the application credential.
               Changing this creates a new application credential.
        :param pulumi.Input[str] expires_at: The expiration time of the application credential
               in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted,
               an application credential will never expire. Changing this creates a new
               application credential.
        :param pulumi.Input[str] name: A name of the application credential. Changing this
               creates a new application credential.
        :param pulumi.Input[str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new application credential.
        :param pulumi.Input[list] roles: A collection of one or more role names, which this
               application credential has to be associated with its project. If omitted,
               all the current user's roles within the scoped project will be inherited by
               a new application credential. Changing this creates a new application
               credential.
        :param pulumi.Input[str] secret: The secret for the application credential. If omitted,
               it will be generated by the server. Changing this creates a new application
               credential.
        :param pulumi.Input[bool] unrestricted: A flag indicating whether the application
               credential may be used for creation or destruction of other application
               credentials or trusts. Changing this creates a new application credential.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/identity_application_credential_v3.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['description'] = description

        __props__['expires_at'] = expires_at

        __props__['name'] = name

        __props__['region'] = region

        __props__['roles'] = roles

        __props__['secret'] = secret

        __props__['unrestricted'] = unrestricted

        __props__['project_id'] = None

        super(ApplicationCredential, __self__).__init__(
            'openstack:identity/applicationCredential:ApplicationCredential',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

