# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class RoleAssignment(pulumi.CustomResource):
    domain_id: pulumi.Output[str]
    """
    The domain to assign the role in.
    """
    group_id: pulumi.Output[str]
    """
    The group to assign the role to.
    """
    project_id: pulumi.Output[str]
    """
    The project to assign the role in.
    """
    region: pulumi.Output[str]
    role_id: pulumi.Output[str]
    """
    The role to assign.
    """
    user_id: pulumi.Output[str]
    """
    The user to assign the role to.
    """
    def __init__(__self__, resource_name, opts=None, domain_id=None, group_id=None, project_id=None, region=None, role_id=None, user_id=None, __name__=None, __opts__=None):
        """
        Manages a V3 Role assignment within OpenStack Keystone.
        
        Note: You _must_ have admin privileges in your OpenStack cloud to use
        this resource.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_id: The domain to assign the role in.
        :param pulumi.Input[str] group_id: The group to assign the role to.
        :param pulumi.Input[str] project_id: The project to assign the role in.
        :param pulumi.Input[str] role_id: The role to assign.
        :param pulumi.Input[str] user_id: The user to assign the role to.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/identity_role_assignment_v3.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['domain_id'] = domain_id

        __props__['group_id'] = group_id

        __props__['project_id'] = project_id

        __props__['region'] = region

        if role_id is None:
            raise TypeError("Missing required property 'role_id'")
        __props__['role_id'] = role_id

        __props__['user_id'] = user_id

        super(RoleAssignment, __self__).__init__(
            'openstack:identity/roleAssignment:RoleAssignment',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

