# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Monitor(pulumi.CustomResource):
    admin_state_up: pulumi.Output[bool]
    """
    The administrative state of the monitor.
    A valid value is true (UP) or false (DOWN).
    """
    delay: pulumi.Output[float]
    """
    The time, in seconds, between sending probes to members.
    """
    expected_codes: pulumi.Output[str]
    """
    Required for HTTP(S) types. Expected HTTP codes
    for a passing HTTP(S) monitor. You can either specify a single status like
    "200", or a range like "200-202".
    """
    http_method: pulumi.Output[str]
    """
    Required for HTTP(S) types. The HTTP method used
    for requests by the monitor. If this attribute is not specified, it
    defaults to "GET".
    """
    max_retries: pulumi.Output[float]
    """
    Number of permissible ping failures before
    changing the member's status to INACTIVE. Must be a number between 1
    and 10..
    """
    name: pulumi.Output[str]
    """
    The Name of the Monitor.
    """
    pool_id: pulumi.Output[str]
    """
    The id of the pool that this monitor will be assigned to.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 Networking client.
    A Networking client is needed to create an . If omitted, the
    `region` argument of the provider is used. Changing this creates a new
    monitor.
    """
    tenant_id: pulumi.Output[str]
    """
    Required for admins. The UUID of the tenant who owns
    the monitor.  Only administrative users can specify a tenant UUID
    other than their own. Changing this creates a new monitor.
    """
    timeout: pulumi.Output[float]
    """
    Maximum number of seconds for a monitor to wait for a
    ping reply before it times out. The value must be less than the delay
    value.
    """
    type: pulumi.Output[str]
    """
    The type of probe, which is PING, TCP, HTTP, or HTTPS,
    that is sent by the load balancer to verify the member state. Changing this
    creates a new monitor.
    """
    url_path: pulumi.Output[str]
    """
    Required for HTTP(S) types. URI path that will be
    accessed if monitor type is HTTP or HTTPS.
    """
    def __init__(__self__, resource_name, opts=None, admin_state_up=None, delay=None, expected_codes=None, http_method=None, max_retries=None, name=None, pool_id=None, region=None, tenant_id=None, timeout=None, type=None, url_path=None, __name__=None, __opts__=None):
        """
        Manages a V2 monitor resource within OpenStack.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the monitor.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[float] delay: The time, in seconds, between sending probes to members.
        :param pulumi.Input[str] expected_codes: Required for HTTP(S) types. Expected HTTP codes
               for a passing HTTP(S) monitor. You can either specify a single status like
               "200", or a range like "200-202".
        :param pulumi.Input[str] http_method: Required for HTTP(S) types. The HTTP method used
               for requests by the monitor. If this attribute is not specified, it
               defaults to "GET".
        :param pulumi.Input[float] max_retries: Number of permissible ping failures before
               changing the member's status to INACTIVE. Must be a number between 1
               and 10..
        :param pulumi.Input[str] name: The Name of the Monitor.
        :param pulumi.Input[str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an . If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               monitor.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the monitor.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new monitor.
        :param pulumi.Input[float] timeout: Maximum number of seconds for a monitor to wait for a
               ping reply before it times out. The value must be less than the delay
               value.
        :param pulumi.Input[str] type: The type of probe, which is PING, TCP, HTTP, or HTTPS,
               that is sent by the load balancer to verify the member state. Changing this
               creates a new monitor.
        :param pulumi.Input[str] url_path: Required for HTTP(S) types. URI path that will be
               accessed if monitor type is HTTP or HTTPS.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/lb_monitor_v2.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['admin_state_up'] = admin_state_up

        if delay is None:
            raise TypeError("Missing required property 'delay'")
        __props__['delay'] = delay

        __props__['expected_codes'] = expected_codes

        __props__['http_method'] = http_method

        if max_retries is None:
            raise TypeError("Missing required property 'max_retries'")
        __props__['max_retries'] = max_retries

        __props__['name'] = name

        if pool_id is None:
            raise TypeError("Missing required property 'pool_id'")
        __props__['pool_id'] = pool_id

        __props__['region'] = region

        __props__['tenant_id'] = tenant_id

        if timeout is None:
            raise TypeError("Missing required property 'timeout'")
        __props__['timeout'] = timeout

        if type is None:
            raise TypeError("Missing required property 'type'")
        __props__['type'] = type

        __props__['url_path'] = url_path

        super(Monitor, __self__).__init__(
            'openstack:loadbalancer/monitor:Monitor',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

