# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class FloatingIpAssociate(pulumi.CustomResource):
    fixed_ip: pulumi.Output[str]
    floating_ip: pulumi.Output[str]
    """
    IP Address of an existing floating IP.
    """
    port_id: pulumi.Output[str]
    """
    ID of an existing port with at least one IP address to
    associate with this floating IP.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 Networking client.
    A Networking client is needed to create a floating IP that can be used with
    another networking resource, such as a load balancer. If omitted, the
    `region` argument of the provider is used. Changing this creates a new
    floating IP (which may or may not have a different address).
    """
    def __init__(__self__, resource_name, opts=None, fixed_ip=None, floating_ip=None, port_id=None, region=None, __name__=None, __opts__=None):
        """
        Associates a floating IP to a port. This is useful for situations
        where you have a pre-allocated floating IP or are unable to use the
        `openstack_networking_floatingip_v2` resource to create a floating IP.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] floating_ip: IP Address of an existing floating IP.
        :param pulumi.Input[str] port_id: ID of an existing port with at least one IP address to
               associate with this floating IP.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a floating IP that can be used with
               another networking resource, such as a load balancer. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               floating IP (which may or may not have a different address).

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/networking_floatingip_associate_v2.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['fixed_ip'] = fixed_ip

        if floating_ip is None:
            raise TypeError("Missing required property 'floating_ip'")
        __props__['floating_ip'] = floating_ip

        if port_id is None:
            raise TypeError("Missing required property 'port_id'")
        __props__['port_id'] = port_id

        __props__['region'] = region

        super(FloatingIpAssociate, __self__).__init__(
            'openstack:networking/floatingIpAssociate:FloatingIpAssociate',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

