# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class PortSecGroupAssociate(pulumi.CustomResource):
    all_security_group_ids: pulumi.Output[list]
    """
    The collection of Security Group IDs on the port
    which have been explicitly and implicitly added.
    """
    enforce: pulumi.Output[bool]
    """
    Whether to replace or append the list of security
    groups, specified in the `security_group_ids`. Defaults to `false`.
    """
    port_id: pulumi.Output[str]
    """
    An UUID of the port to apply security groups to.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 networking client.
    A networking client is needed to manage a port. If omitted, the
    `region` argument of the provider is used. Changing this creates a new
    resource.
    """
    security_group_ids: pulumi.Output[list]
    """
    A list of security group IDs to apply to
    the port. The security groups must be specified by ID and not name (as
    opposed to how they are configured with the Compute Instance).
    """
    def __init__(__self__, resource_name, opts=None, enforce=None, port_id=None, region=None, security_group_ids=None, __name__=None, __opts__=None):
        """
        Create a PortSecGroupAssociate resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enforce: Whether to replace or append the list of security
               groups, specified in the `security_group_ids`. Defaults to `false`.
        :param pulumi.Input[str] port_id: An UUID of the port to apply security groups to.
        :param pulumi.Input[str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to manage a port. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               resource.
        :param pulumi.Input[list] security_group_ids: A list of security group IDs to apply to
               the port. The security groups must be specified by ID and not name (as
               opposed to how they are configured with the Compute Instance).

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/networking_port_secgroup_associate_v2.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['enforce'] = enforce

        if port_id is None:
            raise TypeError("Missing required property 'port_id'")
        __props__['port_id'] = port_id

        __props__['region'] = region

        if security_group_ids is None:
            raise TypeError("Missing required property 'security_group_ids'")
        __props__['security_group_ids'] = security_group_ids

        __props__['all_security_group_ids'] = None

        super(PortSecGroupAssociate, __self__).__init__(
            'openstack:networking/portSecGroupAssociate:PortSecGroupAssociate',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

