# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class ShareNetwork(pulumi.CustomResource):
    cidr: pulumi.Output[str]
    """
    The share network CIDR.
    """
    description: pulumi.Output[str]
    """
    The human-readable description for the share network.
    Changing this updates the description of the existing share network.
    """
    ip_version: pulumi.Output[float]
    """
    The IP version of the share network. Can either be 4 or 6.
    """
    name: pulumi.Output[str]
    """
    The name for the share network. Changing this updates the name
    of the existing share network.
    """
    network_type: pulumi.Output[str]
    """
    The share network type. Can either be VLAN, VXLAN, GRE, or flat.
    """
    neutron_net_id: pulumi.Output[str]
    """
    The UUID of a neutron network when setting up or updating
    a share network. Changing this updates the existing share network if it's not used by
    shares.
    """
    neutron_subnet_id: pulumi.Output[str]
    """
    The UUID of the neutron subnet when setting up or
    updating a share network. Changing this updates the existing share network if it's
    not used by shares.
    """
    project_id: pulumi.Output[str]
    """
    The owner of the Share Network.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 Shared File System client.
    A Shared File System client is needed to create a share network. If omitted, the
    `region` argument of the provider is used. Changing this creates a new
    share network.
    """
    security_service_ids: pulumi.Output[list]
    """
    The list of security service IDs to associate with
    the share network. The security service must be specified by ID and not name.
    """
    segmentation_id: pulumi.Output[float]
    """
    The share network segmentation ID.
    """
    def __init__(__self__, resource_name, opts=None, description=None, name=None, neutron_net_id=None, neutron_subnet_id=None, region=None, security_service_ids=None, __name__=None, __opts__=None):
        """
        Use this resource to configure a share network.
        
        A share network stores network information that share servers can use when
        shares are created.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The human-readable description for the share network.
               Changing this updates the description of the existing share network.
        :param pulumi.Input[str] name: The name for the share network. Changing this updates the name
               of the existing share network.
        :param pulumi.Input[str] neutron_net_id: The UUID of a neutron network when setting up or updating
               a share network. Changing this updates the existing share network if it's not used by
               shares.
        :param pulumi.Input[str] neutron_subnet_id: The UUID of the neutron subnet when setting up or
               updating a share network. Changing this updates the existing share network if it's
               not used by shares.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Shared File System client.
               A Shared File System client is needed to create a share network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               share network.
        :param pulumi.Input[list] security_service_ids: The list of security service IDs to associate with
               the share network. The security service must be specified by ID and not name.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/sharedfilesystem_sharenetwork_v2.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['description'] = description

        __props__['name'] = name

        if neutron_net_id is None:
            raise TypeError("Missing required property 'neutron_net_id'")
        __props__['neutron_net_id'] = neutron_net_id

        if neutron_subnet_id is None:
            raise TypeError("Missing required property 'neutron_subnet_id'")
        __props__['neutron_subnet_id'] = neutron_subnet_id

        __props__['region'] = region

        __props__['security_service_ids'] = security_service_ids

        __props__['cidr'] = None
        __props__['ip_version'] = None
        __props__['network_type'] = None
        __props__['project_id'] = None
        __props__['segmentation_id'] = None

        super(ShareNetwork, __self__).__init__(
            'openstack:sharedfilesystem/shareNetwork:ShareNetwork',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

