# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalTableArgs', 'ExternalTable']

@pulumi.input_type
class ExternalTableArgs:
    def __init__(__self__, *,
                 columns: pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]],
                 database: pulumi.Input[_builtins.str],
                 file_format: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 auto_refresh: Optional[pulumi.Input[_builtins.bool]] = None,
                 aws_sns_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 table_format: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]] = None):
        """
        The set of arguments for constructing a ExternalTable resource.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]] columns: Definitions of a column to create in the external table. Minimum one required.
        :param pulumi.Input[_builtins.str] database: The database in which to create the external table.
        :param pulumi.Input[_builtins.str] file_format: Specifies the file format for the external table.
        :param pulumi.Input[_builtins.str] location: Specifies a location for the external table, using its FQDN. You can hardcode it (`"@MYDB.MYSCHEMA.MYSTAGE"`), or populate dynamically (`"@${snowflake_stage.mystage.fully_qualified_name}"`)
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the external table.
        :param pulumi.Input[_builtins.bool] auto_refresh: (Default: `true`) Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        :param pulumi.Input[_builtins.str] aws_sns_topic: Specifies the aws sns topic for the external table.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the external table.
        :param pulumi.Input[_builtins.bool] copy_grants: (Default: `false`) Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partition_bies: Specifies any partition columns to evaluate for the external table.
        :param pulumi.Input[_builtins.str] pattern: Specifies the file names and/or paths on the external stage to match.
        :param pulumi.Input[_builtins.bool] refresh_on_create: (Default: `true`) Specifies weather to refresh when an external table is created.
        :param pulumi.Input[_builtins.str] table_format: Identifies the external table table type. For now, only "delta" for Delta Lake table format is supported.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]] tags: Definitions of a tag to associate with the resource.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "file_format", file_format)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "schema", schema)
        if auto_refresh is not None:
            pulumi.set(__self__, "auto_refresh", auto_refresh)
        if aws_sns_topic is not None:
            pulumi.set(__self__, "aws_sns_topic", aws_sns_topic)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_grants is not None:
            pulumi.set(__self__, "copy_grants", copy_grants)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_bies is not None:
            pulumi.set(__self__, "partition_bies", partition_bies)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if refresh_on_create is not None:
            pulumi.set(__self__, "refresh_on_create", refresh_on_create)
        if table_format is not None:
            pulumi.set(__self__, "table_format", table_format)
        if tags is not None:
            warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]:
        """
        Definitions of a column to create in the external table. Minimum one required.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the external table.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the file format for the external table.
        """
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_format", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies a location for the external table, using its FQDN. You can hardcode it (`"@MYDB.MYSCHEMA.MYSTAGE"`), or populate dynamically (`"@${snowflake_stage.mystage.fully_qualified_name}"`)
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the external table.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="autoRefresh")
    def auto_refresh(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `true`) Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        """
        return pulumi.get(self, "auto_refresh")

    @auto_refresh.setter
    def auto_refresh(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_refresh", value)

    @_builtins.property
    @pulumi.getter(name="awsSnsTopic")
    def aws_sns_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the aws sns topic for the external table.
        """
        return pulumi.get(self, "aws_sns_topic")

    @aws_sns_topic.setter
    def aws_sns_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sns_topic", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the external table.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        """
        return pulumi.get(self, "copy_grants")

    @copy_grants.setter
    def copy_grants(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_grants", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partitionBies")
    def partition_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies any partition columns to evaluate for the external table.
        """
        return pulumi.get(self, "partition_bies")

    @partition_bies.setter
    def partition_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "partition_bies", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file names and/or paths on the external stage to match.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="refreshOnCreate")
    def refresh_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `true`) Specifies weather to refresh when an external table is created.
        """
        return pulumi.get(self, "refresh_on_create")

    @refresh_on_create.setter
    def refresh_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "refresh_on_create", value)

    @_builtins.property
    @pulumi.getter(name="tableFormat")
    def table_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the external table table type. For now, only "delta" for Delta Lake table format is supported.
        """
        return pulumi.get(self, "table_format")

    @table_format.setter
    def table_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_format", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'snowflake_tag_association' resource instead.""")
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ExternalTableState:
    def __init__(__self__, *,
                 auto_refresh: Optional[pulumi.Input[_builtins.bool]] = None,
                 aws_sns_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 table_format: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering ExternalTable resources.
        :param pulumi.Input[_builtins.bool] auto_refresh: (Default: `true`) Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        :param pulumi.Input[_builtins.str] aws_sns_topic: Specifies the aws sns topic for the external table.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]] columns: Definitions of a column to create in the external table. Minimum one required.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the external table.
        :param pulumi.Input[_builtins.bool] copy_grants: (Default: `false`) Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        :param pulumi.Input[_builtins.str] database: The database in which to create the external table.
        :param pulumi.Input[_builtins.str] file_format: Specifies the file format for the external table.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] location: Specifies a location for the external table, using its FQDN. You can hardcode it (`"@MYDB.MYSCHEMA.MYSTAGE"`), or populate dynamically (`"@${snowflake_stage.mystage.fully_qualified_name}"`)
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        :param pulumi.Input[_builtins.str] owner: Name of the role that owns the external table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partition_bies: Specifies any partition columns to evaluate for the external table.
        :param pulumi.Input[_builtins.str] pattern: Specifies the file names and/or paths on the external stage to match.
        :param pulumi.Input[_builtins.bool] refresh_on_create: (Default: `true`) Specifies weather to refresh when an external table is created.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the external table.
        :param pulumi.Input[_builtins.str] table_format: Identifies the external table table type. For now, only "delta" for Delta Lake table format is supported.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]] tags: Definitions of a tag to associate with the resource.
        """
        if auto_refresh is not None:
            pulumi.set(__self__, "auto_refresh", auto_refresh)
        if aws_sns_topic is not None:
            pulumi.set(__self__, "aws_sns_topic", aws_sns_topic)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_grants is not None:
            pulumi.set(__self__, "copy_grants", copy_grants)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if partition_bies is not None:
            pulumi.set(__self__, "partition_bies", partition_bies)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if refresh_on_create is not None:
            pulumi.set(__self__, "refresh_on_create", refresh_on_create)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if table_format is not None:
            pulumi.set(__self__, "table_format", table_format)
        if tags is not None:
            warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="autoRefresh")
    def auto_refresh(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `true`) Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        """
        return pulumi.get(self, "auto_refresh")

    @auto_refresh.setter
    def auto_refresh(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_refresh", value)

    @_builtins.property
    @pulumi.getter(name="awsSnsTopic")
    def aws_sns_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the aws sns topic for the external table.
        """
        return pulumi.get(self, "aws_sns_topic")

    @aws_sns_topic.setter
    def aws_sns_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sns_topic", value)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]]:
        """
        Definitions of a column to create in the external table. Minimum one required.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the external table.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        """
        return pulumi.get(self, "copy_grants")

    @copy_grants.setter
    def copy_grants(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_grants", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the external table.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file format for the external table.
        """
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_format", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a location for the external table, using its FQDN. You can hardcode it (`"@MYDB.MYSCHEMA.MYSTAGE"`), or populate dynamically (`"@${snowflake_stage.mystage.fully_qualified_name}"`)
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the role that owns the external table.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="partitionBies")
    def partition_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies any partition columns to evaluate for the external table.
        """
        return pulumi.get(self, "partition_bies")

    @partition_bies.setter
    def partition_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "partition_bies", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file names and/or paths on the external stage to match.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="refreshOnCreate")
    def refresh_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `true`) Specifies weather to refresh when an external table is created.
        """
        return pulumi.get(self, "refresh_on_create")

    @refresh_on_create.setter
    def refresh_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "refresh_on_create", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the external table.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="tableFormat")
    def table_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the external table table type. For now, only "delta" for Delta Lake table format is supported.
        """
        return pulumi.get(self, "table_format")

    @table_format.setter
    def table_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_format", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'snowflake_tag_association' resource instead.""")
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalTableTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("snowflake:index/externalTable:ExternalTable")
class ExternalTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_refresh: Optional[pulumi.Input[_builtins.bool]] = None,
                 aws_sns_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableColumnArgs', 'ExternalTableColumnArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 table_format: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableTagArgs', 'ExternalTableTagArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Import

        format is database name | schema name | external table name

        ```sh
        $ pulumi import snowflake:index/externalTable:ExternalTable example 'dbName|schemaName|externalTableName'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_refresh: (Default: `true`) Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        :param pulumi.Input[_builtins.str] aws_sns_topic: Specifies the aws sns topic for the external table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableColumnArgs', 'ExternalTableColumnArgsDict']]]] columns: Definitions of a column to create in the external table. Minimum one required.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the external table.
        :param pulumi.Input[_builtins.bool] copy_grants: (Default: `false`) Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        :param pulumi.Input[_builtins.str] database: The database in which to create the external table.
        :param pulumi.Input[_builtins.str] file_format: Specifies the file format for the external table.
        :param pulumi.Input[_builtins.str] location: Specifies a location for the external table, using its FQDN. You can hardcode it (`"@MYDB.MYSCHEMA.MYSTAGE"`), or populate dynamically (`"@${snowflake_stage.mystage.fully_qualified_name}"`)
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partition_bies: Specifies any partition columns to evaluate for the external table.
        :param pulumi.Input[_builtins.str] pattern: Specifies the file names and/or paths on the external stage to match.
        :param pulumi.Input[_builtins.bool] refresh_on_create: (Default: `true`) Specifies weather to refresh when an external table is created.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the external table.
        :param pulumi.Input[_builtins.str] table_format: Identifies the external table table type. For now, only "delta" for Delta Lake table format is supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableTagArgs', 'ExternalTableTagArgsDict']]]] tags: Definitions of a tag to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        format is database name | schema name | external table name

        ```sh
        $ pulumi import snowflake:index/externalTable:ExternalTable example 'dbName|schemaName|externalTableName'
        ```

        :param str resource_name: The name of the resource.
        :param ExternalTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_refresh: Optional[pulumi.Input[_builtins.bool]] = None,
                 aws_sns_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableColumnArgs', 'ExternalTableColumnArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 table_format: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableTagArgs', 'ExternalTableTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalTableArgs.__new__(ExternalTableArgs)

            __props__.__dict__["auto_refresh"] = auto_refresh
            __props__.__dict__["aws_sns_topic"] = aws_sns_topic
            if columns is None and not opts.urn:
                raise TypeError("Missing required property 'columns'")
            __props__.__dict__["columns"] = columns
            __props__.__dict__["comment"] = comment
            __props__.__dict__["copy_grants"] = copy_grants
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            if file_format is None and not opts.urn:
                raise TypeError("Missing required property 'file_format'")
            __props__.__dict__["file_format"] = file_format
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["partition_bies"] = partition_bies
            __props__.__dict__["pattern"] = pattern
            __props__.__dict__["refresh_on_create"] = refresh_on_create
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["table_format"] = table_format
            __props__.__dict__["tags"] = tags
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["owner"] = None
        super(ExternalTable, __self__).__init__(
            'snowflake:index/externalTable:ExternalTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_refresh: Optional[pulumi.Input[_builtins.bool]] = None,
            aws_sns_topic: Optional[pulumi.Input[_builtins.str]] = None,
            columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableColumnArgs', 'ExternalTableColumnArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            copy_grants: Optional[pulumi.Input[_builtins.bool]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            file_format: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            partition_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            pattern: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            table_format: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableTagArgs', 'ExternalTableTagArgsDict']]]]] = None) -> 'ExternalTable':
        """
        Get an existing ExternalTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_refresh: (Default: `true`) Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        :param pulumi.Input[_builtins.str] aws_sns_topic: Specifies the aws sns topic for the external table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableColumnArgs', 'ExternalTableColumnArgsDict']]]] columns: Definitions of a column to create in the external table. Minimum one required.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the external table.
        :param pulumi.Input[_builtins.bool] copy_grants: (Default: `false`) Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        :param pulumi.Input[_builtins.str] database: The database in which to create the external table.
        :param pulumi.Input[_builtins.str] file_format: Specifies the file format for the external table.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] location: Specifies a location for the external table, using its FQDN. You can hardcode it (`"@MYDB.MYSCHEMA.MYSTAGE"`), or populate dynamically (`"@${snowflake_stage.mystage.fully_qualified_name}"`)
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        :param pulumi.Input[_builtins.str] owner: Name of the role that owns the external table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] partition_bies: Specifies any partition columns to evaluate for the external table.
        :param pulumi.Input[_builtins.str] pattern: Specifies the file names and/or paths on the external stage to match.
        :param pulumi.Input[_builtins.bool] refresh_on_create: (Default: `true`) Specifies weather to refresh when an external table is created.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the external table.
        :param pulumi.Input[_builtins.str] table_format: Identifies the external table table type. For now, only "delta" for Delta Lake table format is supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExternalTableTagArgs', 'ExternalTableTagArgsDict']]]] tags: Definitions of a tag to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalTableState.__new__(_ExternalTableState)

        __props__.__dict__["auto_refresh"] = auto_refresh
        __props__.__dict__["aws_sns_topic"] = aws_sns_topic
        __props__.__dict__["columns"] = columns
        __props__.__dict__["comment"] = comment
        __props__.__dict__["copy_grants"] = copy_grants
        __props__.__dict__["database"] = database
        __props__.__dict__["file_format"] = file_format
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["partition_bies"] = partition_bies
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["refresh_on_create"] = refresh_on_create
        __props__.__dict__["schema"] = schema
        __props__.__dict__["table_format"] = table_format
        __props__.__dict__["tags"] = tags
        return ExternalTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRefresh")
    def auto_refresh(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `true`) Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
        """
        return pulumi.get(self, "auto_refresh")

    @_builtins.property
    @pulumi.getter(name="awsSnsTopic")
    def aws_sns_topic(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the aws sns topic for the external table.
        """
        return pulumi.get(self, "aws_sns_topic")

    @_builtins.property
    @pulumi.getter
    def columns(self) -> pulumi.Output[Sequence['outputs.ExternalTableColumn']]:
        """
        Definitions of a column to create in the external table. Minimum one required.
        """
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the external table.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="copyGrants")
    def copy_grants(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `false`) Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
        """
        return pulumi.get(self, "copy_grants")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the external table.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the file format for the external table.
        """
        return pulumi.get(self, "file_format")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a location for the external table, using its FQDN. You can hardcode it (`"@MYDB.MYSCHEMA.MYSTAGE"`), or populate dynamically (`"@${snowflake_stage.mystage.fully_qualified_name}"`)
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the role that owns the external table.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="partitionBies")
    def partition_bies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies any partition columns to evaluate for the external table.
        """
        return pulumi.get(self, "partition_bies")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the file names and/or paths on the external stage to match.
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="refreshOnCreate")
    def refresh_on_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `true`) Specifies weather to refresh when an external table is created.
        """
        return pulumi.get(self, "refresh_on_create")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the external table.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="tableFormat")
    def table_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifies the external table table type. For now, only "delta" for Delta Lake table format is supported.
        """
        return pulumi.get(self, "table_format")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'snowflake_tag_association' resource instead.""")
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ExternalTableTag']]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

