# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FailoverGroupArgs', 'FailoverGroup']

@pulumi.input_type
class FailoverGroupArgs:
    def __init__(__self__, *,
                 allowed_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_databases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_integration_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_shares: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_replica: Optional[pulumi.Input['FailoverGroupFromReplicaArgs']] = None,
                 ignore_edition_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replication_schedule: Optional[pulumi.Input['FailoverGroupReplicationScheduleArgs']] = None):
        """
        The set of arguments for constructing a FailoverGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_accounts: Specifies the target account or list of target accounts to which replication and failover of specified objects from the source account is enabled. Secondary failover groups in the target accounts in this list can be promoted to serve as the primary failover group in case of failover. Expected in the form `<org_name>.<target_account_name>`. This value is case-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_databases: Specifies the database or list of databases for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include DATABASES to set this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_integration_types: Type(s) of integrations for which you are enabling replication and failover from the source account to the target account. This property requires that the OBJECT_TYPES list include INTEGRATIONS to set this parameter. The following integration types are supported: "SECURITY INTEGRATIONS", "API INTEGRATIONS", "STORAGE INTEGRATIONS", "EXTERNAL ACCESS INTEGRATIONS", "NOTIFICATION INTEGRATIONS"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_shares: Specifies the share or list of shares for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include SHARES to set this parameter.
        :param pulumi.Input['FailoverGroupFromReplicaArgs'] from_replica: Specifies the name of the replica to use as the source for the failover group.
        :param pulumi.Input[_builtins.bool] ignore_edition_check: (Default: `false`) Allows replicating objects to accounts on lower editions.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the failover group. The identifier must start with an alphabetic character and cannot contain spaces or special characters unless the identifier string is enclosed in double quotes (e.g. "My object"). Identifiers enclosed in double quotes are also case-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_types: Type(s) of objects for which you are enabling replication and failover from the source account to the target account. The following object types are supported: "ACCOUNT PARAMETERS", "DATABASES", "INTEGRATIONS", "NETWORK POLICIES", "RESOURCE MONITORS", "ROLES", "SHARES", "USERS", "WAREHOUSES"
        :param pulumi.Input['FailoverGroupReplicationScheduleArgs'] replication_schedule: Specifies the schedule for refreshing secondary failover groups.
        """
        if allowed_accounts is not None:
            pulumi.set(__self__, "allowed_accounts", allowed_accounts)
        if allowed_databases is not None:
            pulumi.set(__self__, "allowed_databases", allowed_databases)
        if allowed_integration_types is not None:
            pulumi.set(__self__, "allowed_integration_types", allowed_integration_types)
        if allowed_shares is not None:
            pulumi.set(__self__, "allowed_shares", allowed_shares)
        if from_replica is not None:
            pulumi.set(__self__, "from_replica", from_replica)
        if ignore_edition_check is not None:
            pulumi.set(__self__, "ignore_edition_check", ignore_edition_check)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_types is not None:
            pulumi.set(__self__, "object_types", object_types)
        if replication_schedule is not None:
            pulumi.set(__self__, "replication_schedule", replication_schedule)

    @_builtins.property
    @pulumi.getter(name="allowedAccounts")
    def allowed_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the target account or list of target accounts to which replication and failover of specified objects from the source account is enabled. Secondary failover groups in the target accounts in this list can be promoted to serve as the primary failover group in case of failover. Expected in the form `<org_name>.<target_account_name>`. This value is case-sensitive.
        """
        return pulumi.get(self, "allowed_accounts")

    @allowed_accounts.setter
    def allowed_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_accounts", value)

    @_builtins.property
    @pulumi.getter(name="allowedDatabases")
    def allowed_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the database or list of databases for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include DATABASES to set this parameter.
        """
        return pulumi.get(self, "allowed_databases")

    @allowed_databases.setter
    def allowed_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_databases", value)

    @_builtins.property
    @pulumi.getter(name="allowedIntegrationTypes")
    def allowed_integration_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Type(s) of integrations for which you are enabling replication and failover from the source account to the target account. This property requires that the OBJECT_TYPES list include INTEGRATIONS to set this parameter. The following integration types are supported: "SECURITY INTEGRATIONS", "API INTEGRATIONS", "STORAGE INTEGRATIONS", "EXTERNAL ACCESS INTEGRATIONS", "NOTIFICATION INTEGRATIONS"
        """
        return pulumi.get(self, "allowed_integration_types")

    @allowed_integration_types.setter
    def allowed_integration_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_integration_types", value)

    @_builtins.property
    @pulumi.getter(name="allowedShares")
    def allowed_shares(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the share or list of shares for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include SHARES to set this parameter.
        """
        return pulumi.get(self, "allowed_shares")

    @allowed_shares.setter
    def allowed_shares(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_shares", value)

    @_builtins.property
    @pulumi.getter(name="fromReplica")
    def from_replica(self) -> Optional[pulumi.Input['FailoverGroupFromReplicaArgs']]:
        """
        Specifies the name of the replica to use as the source for the failover group.
        """
        return pulumi.get(self, "from_replica")

    @from_replica.setter
    def from_replica(self, value: Optional[pulumi.Input['FailoverGroupFromReplicaArgs']]):
        pulumi.set(self, "from_replica", value)

    @_builtins.property
    @pulumi.getter(name="ignoreEditionCheck")
    def ignore_edition_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Allows replicating objects to accounts on lower editions.
        """
        return pulumi.get(self, "ignore_edition_check")

    @ignore_edition_check.setter
    def ignore_edition_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_edition_check", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the failover group. The identifier must start with an alphabetic character and cannot contain spaces or special characters unless the identifier string is enclosed in double quotes (e.g. "My object"). Identifiers enclosed in double quotes are also case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectTypes")
    def object_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Type(s) of objects for which you are enabling replication and failover from the source account to the target account. The following object types are supported: "ACCOUNT PARAMETERS", "DATABASES", "INTEGRATIONS", "NETWORK POLICIES", "RESOURCE MONITORS", "ROLES", "SHARES", "USERS", "WAREHOUSES"
        """
        return pulumi.get(self, "object_types")

    @object_types.setter
    def object_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "object_types", value)

    @_builtins.property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> Optional[pulumi.Input['FailoverGroupReplicationScheduleArgs']]:
        """
        Specifies the schedule for refreshing secondary failover groups.
        """
        return pulumi.get(self, "replication_schedule")

    @replication_schedule.setter
    def replication_schedule(self, value: Optional[pulumi.Input['FailoverGroupReplicationScheduleArgs']]):
        pulumi.set(self, "replication_schedule", value)


@pulumi.input_type
class _FailoverGroupState:
    def __init__(__self__, *,
                 allowed_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_databases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_integration_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_shares: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_replica: Optional[pulumi.Input['FailoverGroupFromReplicaArgs']] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_edition_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replication_schedule: Optional[pulumi.Input['FailoverGroupReplicationScheduleArgs']] = None):
        """
        Input properties used for looking up and filtering FailoverGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_accounts: Specifies the target account or list of target accounts to which replication and failover of specified objects from the source account is enabled. Secondary failover groups in the target accounts in this list can be promoted to serve as the primary failover group in case of failover. Expected in the form `<org_name>.<target_account_name>`. This value is case-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_databases: Specifies the database or list of databases for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include DATABASES to set this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_integration_types: Type(s) of integrations for which you are enabling replication and failover from the source account to the target account. This property requires that the OBJECT_TYPES list include INTEGRATIONS to set this parameter. The following integration types are supported: "SECURITY INTEGRATIONS", "API INTEGRATIONS", "STORAGE INTEGRATIONS", "EXTERNAL ACCESS INTEGRATIONS", "NOTIFICATION INTEGRATIONS"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_shares: Specifies the share or list of shares for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include SHARES to set this parameter.
        :param pulumi.Input['FailoverGroupFromReplicaArgs'] from_replica: Specifies the name of the replica to use as the source for the failover group.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.bool] ignore_edition_check: (Default: `false`) Allows replicating objects to accounts on lower editions.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the failover group. The identifier must start with an alphabetic character and cannot contain spaces or special characters unless the identifier string is enclosed in double quotes (e.g. "My object"). Identifiers enclosed in double quotes are also case-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_types: Type(s) of objects for which you are enabling replication and failover from the source account to the target account. The following object types are supported: "ACCOUNT PARAMETERS", "DATABASES", "INTEGRATIONS", "NETWORK POLICIES", "RESOURCE MONITORS", "ROLES", "SHARES", "USERS", "WAREHOUSES"
        :param pulumi.Input['FailoverGroupReplicationScheduleArgs'] replication_schedule: Specifies the schedule for refreshing secondary failover groups.
        """
        if allowed_accounts is not None:
            pulumi.set(__self__, "allowed_accounts", allowed_accounts)
        if allowed_databases is not None:
            pulumi.set(__self__, "allowed_databases", allowed_databases)
        if allowed_integration_types is not None:
            pulumi.set(__self__, "allowed_integration_types", allowed_integration_types)
        if allowed_shares is not None:
            pulumi.set(__self__, "allowed_shares", allowed_shares)
        if from_replica is not None:
            pulumi.set(__self__, "from_replica", from_replica)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if ignore_edition_check is not None:
            pulumi.set(__self__, "ignore_edition_check", ignore_edition_check)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_types is not None:
            pulumi.set(__self__, "object_types", object_types)
        if replication_schedule is not None:
            pulumi.set(__self__, "replication_schedule", replication_schedule)

    @_builtins.property
    @pulumi.getter(name="allowedAccounts")
    def allowed_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the target account or list of target accounts to which replication and failover of specified objects from the source account is enabled. Secondary failover groups in the target accounts in this list can be promoted to serve as the primary failover group in case of failover. Expected in the form `<org_name>.<target_account_name>`. This value is case-sensitive.
        """
        return pulumi.get(self, "allowed_accounts")

    @allowed_accounts.setter
    def allowed_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_accounts", value)

    @_builtins.property
    @pulumi.getter(name="allowedDatabases")
    def allowed_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the database or list of databases for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include DATABASES to set this parameter.
        """
        return pulumi.get(self, "allowed_databases")

    @allowed_databases.setter
    def allowed_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_databases", value)

    @_builtins.property
    @pulumi.getter(name="allowedIntegrationTypes")
    def allowed_integration_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Type(s) of integrations for which you are enabling replication and failover from the source account to the target account. This property requires that the OBJECT_TYPES list include INTEGRATIONS to set this parameter. The following integration types are supported: "SECURITY INTEGRATIONS", "API INTEGRATIONS", "STORAGE INTEGRATIONS", "EXTERNAL ACCESS INTEGRATIONS", "NOTIFICATION INTEGRATIONS"
        """
        return pulumi.get(self, "allowed_integration_types")

    @allowed_integration_types.setter
    def allowed_integration_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_integration_types", value)

    @_builtins.property
    @pulumi.getter(name="allowedShares")
    def allowed_shares(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the share or list of shares for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include SHARES to set this parameter.
        """
        return pulumi.get(self, "allowed_shares")

    @allowed_shares.setter
    def allowed_shares(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_shares", value)

    @_builtins.property
    @pulumi.getter(name="fromReplica")
    def from_replica(self) -> Optional[pulumi.Input['FailoverGroupFromReplicaArgs']]:
        """
        Specifies the name of the replica to use as the source for the failover group.
        """
        return pulumi.get(self, "from_replica")

    @from_replica.setter
    def from_replica(self, value: Optional[pulumi.Input['FailoverGroupFromReplicaArgs']]):
        pulumi.set(self, "from_replica", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="ignoreEditionCheck")
    def ignore_edition_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Allows replicating objects to accounts on lower editions.
        """
        return pulumi.get(self, "ignore_edition_check")

    @ignore_edition_check.setter
    def ignore_edition_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_edition_check", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the failover group. The identifier must start with an alphabetic character and cannot contain spaces or special characters unless the identifier string is enclosed in double quotes (e.g. "My object"). Identifiers enclosed in double quotes are also case-sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectTypes")
    def object_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Type(s) of objects for which you are enabling replication and failover from the source account to the target account. The following object types are supported: "ACCOUNT PARAMETERS", "DATABASES", "INTEGRATIONS", "NETWORK POLICIES", "RESOURCE MONITORS", "ROLES", "SHARES", "USERS", "WAREHOUSES"
        """
        return pulumi.get(self, "object_types")

    @object_types.setter
    def object_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "object_types", value)

    @_builtins.property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> Optional[pulumi.Input['FailoverGroupReplicationScheduleArgs']]:
        """
        Specifies the schedule for refreshing secondary failover groups.
        """
        return pulumi.get(self, "replication_schedule")

    @replication_schedule.setter
    def replication_schedule(self, value: Optional[pulumi.Input['FailoverGroupReplicationScheduleArgs']]):
        pulumi.set(self, "replication_schedule", value)


@pulumi.type_token("snowflake:index/failoverGroup:FailoverGroup")
class FailoverGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_databases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_integration_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_shares: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_replica: Optional[pulumi.Input[Union['FailoverGroupFromReplicaArgs', 'FailoverGroupFromReplicaArgsDict']]] = None,
                 ignore_edition_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replication_schedule: Optional[pulumi.Input[Union['FailoverGroupReplicationScheduleArgs', 'FailoverGroupReplicationScheduleArgsDict']]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/failoverGroup:FailoverGroup example 'fg1'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_accounts: Specifies the target account or list of target accounts to which replication and failover of specified objects from the source account is enabled. Secondary failover groups in the target accounts in this list can be promoted to serve as the primary failover group in case of failover. Expected in the form `<org_name>.<target_account_name>`. This value is case-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_databases: Specifies the database or list of databases for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include DATABASES to set this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_integration_types: Type(s) of integrations for which you are enabling replication and failover from the source account to the target account. This property requires that the OBJECT_TYPES list include INTEGRATIONS to set this parameter. The following integration types are supported: "SECURITY INTEGRATIONS", "API INTEGRATIONS", "STORAGE INTEGRATIONS", "EXTERNAL ACCESS INTEGRATIONS", "NOTIFICATION INTEGRATIONS"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_shares: Specifies the share or list of shares for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include SHARES to set this parameter.
        :param pulumi.Input[Union['FailoverGroupFromReplicaArgs', 'FailoverGroupFromReplicaArgsDict']] from_replica: Specifies the name of the replica to use as the source for the failover group.
        :param pulumi.Input[_builtins.bool] ignore_edition_check: (Default: `false`) Allows replicating objects to accounts on lower editions.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the failover group. The identifier must start with an alphabetic character and cannot contain spaces or special characters unless the identifier string is enclosed in double quotes (e.g. "My object"). Identifiers enclosed in double quotes are also case-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_types: Type(s) of objects for which you are enabling replication and failover from the source account to the target account. The following object types are supported: "ACCOUNT PARAMETERS", "DATABASES", "INTEGRATIONS", "NETWORK POLICIES", "RESOURCE MONITORS", "ROLES", "SHARES", "USERS", "WAREHOUSES"
        :param pulumi.Input[Union['FailoverGroupReplicationScheduleArgs', 'FailoverGroupReplicationScheduleArgsDict']] replication_schedule: Specifies the schedule for refreshing secondary failover groups.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FailoverGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/failoverGroup:FailoverGroup example 'fg1'
        ```

        :param str resource_name: The name of the resource.
        :param FailoverGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FailoverGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_databases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_integration_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_shares: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_replica: Optional[pulumi.Input[Union['FailoverGroupFromReplicaArgs', 'FailoverGroupFromReplicaArgsDict']]] = None,
                 ignore_edition_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 replication_schedule: Optional[pulumi.Input[Union['FailoverGroupReplicationScheduleArgs', 'FailoverGroupReplicationScheduleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FailoverGroupArgs.__new__(FailoverGroupArgs)

            __props__.__dict__["allowed_accounts"] = allowed_accounts
            __props__.__dict__["allowed_databases"] = allowed_databases
            __props__.__dict__["allowed_integration_types"] = allowed_integration_types
            __props__.__dict__["allowed_shares"] = allowed_shares
            __props__.__dict__["from_replica"] = from_replica
            __props__.__dict__["ignore_edition_check"] = ignore_edition_check
            __props__.__dict__["name"] = name
            __props__.__dict__["object_types"] = object_types
            __props__.__dict__["replication_schedule"] = replication_schedule
            __props__.__dict__["fully_qualified_name"] = None
        super(FailoverGroup, __self__).__init__(
            'snowflake:index/failoverGroup:FailoverGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_databases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_integration_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_shares: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            from_replica: Optional[pulumi.Input[Union['FailoverGroupFromReplicaArgs', 'FailoverGroupFromReplicaArgsDict']]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            ignore_edition_check: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            object_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            replication_schedule: Optional[pulumi.Input[Union['FailoverGroupReplicationScheduleArgs', 'FailoverGroupReplicationScheduleArgsDict']]] = None) -> 'FailoverGroup':
        """
        Get an existing FailoverGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_accounts: Specifies the target account or list of target accounts to which replication and failover of specified objects from the source account is enabled. Secondary failover groups in the target accounts in this list can be promoted to serve as the primary failover group in case of failover. Expected in the form `<org_name>.<target_account_name>`. This value is case-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_databases: Specifies the database or list of databases for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include DATABASES to set this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_integration_types: Type(s) of integrations for which you are enabling replication and failover from the source account to the target account. This property requires that the OBJECT_TYPES list include INTEGRATIONS to set this parameter. The following integration types are supported: "SECURITY INTEGRATIONS", "API INTEGRATIONS", "STORAGE INTEGRATIONS", "EXTERNAL ACCESS INTEGRATIONS", "NOTIFICATION INTEGRATIONS"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_shares: Specifies the share or list of shares for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include SHARES to set this parameter.
        :param pulumi.Input[Union['FailoverGroupFromReplicaArgs', 'FailoverGroupFromReplicaArgsDict']] from_replica: Specifies the name of the replica to use as the source for the failover group.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.bool] ignore_edition_check: (Default: `false`) Allows replicating objects to accounts on lower editions.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the failover group. The identifier must start with an alphabetic character and cannot contain spaces or special characters unless the identifier string is enclosed in double quotes (e.g. "My object"). Identifiers enclosed in double quotes are also case-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_types: Type(s) of objects for which you are enabling replication and failover from the source account to the target account. The following object types are supported: "ACCOUNT PARAMETERS", "DATABASES", "INTEGRATIONS", "NETWORK POLICIES", "RESOURCE MONITORS", "ROLES", "SHARES", "USERS", "WAREHOUSES"
        :param pulumi.Input[Union['FailoverGroupReplicationScheduleArgs', 'FailoverGroupReplicationScheduleArgsDict']] replication_schedule: Specifies the schedule for refreshing secondary failover groups.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FailoverGroupState.__new__(_FailoverGroupState)

        __props__.__dict__["allowed_accounts"] = allowed_accounts
        __props__.__dict__["allowed_databases"] = allowed_databases
        __props__.__dict__["allowed_integration_types"] = allowed_integration_types
        __props__.__dict__["allowed_shares"] = allowed_shares
        __props__.__dict__["from_replica"] = from_replica
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["ignore_edition_check"] = ignore_edition_check
        __props__.__dict__["name"] = name
        __props__.__dict__["object_types"] = object_types
        __props__.__dict__["replication_schedule"] = replication_schedule
        return FailoverGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedAccounts")
    def allowed_accounts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the target account or list of target accounts to which replication and failover of specified objects from the source account is enabled. Secondary failover groups in the target accounts in this list can be promoted to serve as the primary failover group in case of failover. Expected in the form `<org_name>.<target_account_name>`. This value is case-sensitive.
        """
        return pulumi.get(self, "allowed_accounts")

    @_builtins.property
    @pulumi.getter(name="allowedDatabases")
    def allowed_databases(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the database or list of databases for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include DATABASES to set this parameter.
        """
        return pulumi.get(self, "allowed_databases")

    @_builtins.property
    @pulumi.getter(name="allowedIntegrationTypes")
    def allowed_integration_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Type(s) of integrations for which you are enabling replication and failover from the source account to the target account. This property requires that the OBJECT_TYPES list include INTEGRATIONS to set this parameter. The following integration types are supported: "SECURITY INTEGRATIONS", "API INTEGRATIONS", "STORAGE INTEGRATIONS", "EXTERNAL ACCESS INTEGRATIONS", "NOTIFICATION INTEGRATIONS"
        """
        return pulumi.get(self, "allowed_integration_types")

    @_builtins.property
    @pulumi.getter(name="allowedShares")
    def allowed_shares(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the share or list of shares for which you are enabling replication and failover from the source account to the target account. The OBJECT_TYPES list must include SHARES to set this parameter.
        """
        return pulumi.get(self, "allowed_shares")

    @_builtins.property
    @pulumi.getter(name="fromReplica")
    def from_replica(self) -> pulumi.Output[Optional['outputs.FailoverGroupFromReplica']]:
        """
        Specifies the name of the replica to use as the source for the failover group.
        """
        return pulumi.get(self, "from_replica")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="ignoreEditionCheck")
    def ignore_edition_check(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `false`) Allows replicating objects to accounts on lower editions.
        """
        return pulumi.get(self, "ignore_edition_check")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the failover group. The identifier must start with an alphabetic character and cannot contain spaces or special characters unless the identifier string is enclosed in double quotes (e.g. "My object"). Identifiers enclosed in double quotes are also case-sensitive.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectTypes")
    def object_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Type(s) of objects for which you are enabling replication and failover from the source account to the target account. The following object types are supported: "ACCOUNT PARAMETERS", "DATABASES", "INTEGRATIONS", "NETWORK POLICIES", "RESOURCE MONITORS", "ROLES", "SHARES", "USERS", "WAREHOUSES"
        """
        return pulumi.get(self, "object_types")

    @_builtins.property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> pulumi.Output[Optional['outputs.FailoverGroupReplicationSchedule']]:
        """
        Specifies the schedule for refreshing secondary failover groups.
        """
        return pulumi.get(self, "replication_schedule")

