# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobServiceArgs', 'JobService']

@pulumi.input_type
class JobServiceArgs:
    def __init__(__self__, *,
                 compute_pool: pulumi.Input[_builtins.str],
                 database: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_specification: Optional[pulumi.Input['JobServiceFromSpecificationArgs']] = None,
                 from_specification_template: Optional[pulumi.Input['JobServiceFromSpecificationTemplateArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_warehouse: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a JobService resource.
        :param pulumi.Input[_builtins.str] compute_pool: Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] database: The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: Specifies the names of the external access integrations that allow your service to access external sites.
        :param pulumi.Input['JobServiceFromSpecificationArgs'] from_specification: Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input['JobServiceFromSpecificationTemplateArgs'] from_specification_template: Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] query_warehouse: Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        pulumi.set(__self__, "compute_pool", compute_pool)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if external_access_integrations is not None:
            pulumi.set(__self__, "external_access_integrations", external_access_integrations)
        if from_specification is not None:
            pulumi.set(__self__, "from_specification", from_specification)
        if from_specification_template is not None:
            pulumi.set(__self__, "from_specification_template", from_specification_template)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_warehouse is not None:
            pulumi.set(__self__, "query_warehouse", query_warehouse)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "compute_pool")

    @compute_pool.setter
    def compute_pool(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_pool", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the service.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the names of the external access integrations that allow your service to access external sites.
        """
        return pulumi.get(self, "external_access_integrations")

    @external_access_integrations.setter
    def external_access_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_access_integrations", value)

    @_builtins.property
    @pulumi.getter(name="fromSpecification")
    def from_specification(self) -> Optional[pulumi.Input['JobServiceFromSpecificationArgs']]:
        """
        Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification")

    @from_specification.setter
    def from_specification(self, value: Optional[pulumi.Input['JobServiceFromSpecificationArgs']]):
        pulumi.set(self, "from_specification", value)

    @_builtins.property
    @pulumi.getter(name="fromSpecificationTemplate")
    def from_specification_template(self) -> Optional[pulumi.Input['JobServiceFromSpecificationTemplateArgs']]:
        """
        Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification_template")

    @from_specification_template.setter
    def from_specification_template(self, value: Optional[pulumi.Input['JobServiceFromSpecificationTemplateArgs']]):
        pulumi.set(self, "from_specification_template", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryWarehouse")
    def query_warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "query_warehouse")

    @query_warehouse.setter
    def query_warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_warehouse", value)


@pulumi.input_type
class _JobServiceState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['JobServiceDescribeOutputArgs']]]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_specification: Optional[pulumi.Input['JobServiceFromSpecificationArgs']] = None,
                 from_specification_template: Optional[pulumi.Input['JobServiceFromSpecificationTemplateArgs']] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['JobServiceShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering JobService resources.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the service.
        :param pulumi.Input[_builtins.str] compute_pool: Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] database: The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['JobServiceDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE SERVICE` for the given service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: Specifies the names of the external access integrations that allow your service to access external sites.
        :param pulumi.Input['JobServiceFromSpecificationArgs'] from_specification: Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input['JobServiceFromSpecificationTemplateArgs'] from_specification_template: Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] query_warehouse: Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] service_type: Specifies a type for the service. This field is used for checking external changes and recreating the resources if needed.
        :param pulumi.Input[Sequence[pulumi.Input['JobServiceShowOutputArgs']]] show_outputs: Outputs the result of `SHOW SERVICES` for the given service.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compute_pool is not None:
            pulumi.set(__self__, "compute_pool", compute_pool)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if external_access_integrations is not None:
            pulumi.set(__self__, "external_access_integrations", external_access_integrations)
        if from_specification is not None:
            pulumi.set(__self__, "from_specification", from_specification)
        if from_specification_template is not None:
            pulumi.set(__self__, "from_specification_template", from_specification_template)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_warehouse is not None:
            pulumi.set(__self__, "query_warehouse", query_warehouse)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the service.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "compute_pool")

    @compute_pool.setter
    def compute_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_pool", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobServiceDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE SERVICE` for the given service.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobServiceDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the names of the external access integrations that allow your service to access external sites.
        """
        return pulumi.get(self, "external_access_integrations")

    @external_access_integrations.setter
    def external_access_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_access_integrations", value)

    @_builtins.property
    @pulumi.getter(name="fromSpecification")
    def from_specification(self) -> Optional[pulumi.Input['JobServiceFromSpecificationArgs']]:
        """
        Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification")

    @from_specification.setter
    def from_specification(self, value: Optional[pulumi.Input['JobServiceFromSpecificationArgs']]):
        pulumi.set(self, "from_specification", value)

    @_builtins.property
    @pulumi.getter(name="fromSpecificationTemplate")
    def from_specification_template(self) -> Optional[pulumi.Input['JobServiceFromSpecificationTemplateArgs']]:
        """
        Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification_template")

    @from_specification_template.setter
    def from_specification_template(self, value: Optional[pulumi.Input['JobServiceFromSpecificationTemplateArgs']]):
        pulumi.set(self, "from_specification_template", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryWarehouse")
    def query_warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "query_warehouse")

    @query_warehouse.setter
    def query_warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_warehouse", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a type for the service. This field is used for checking external changes and recreating the resources if needed.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobServiceShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW SERVICES` for the given service.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobServiceShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/jobService:JobService")
class JobService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_specification: Optional[pulumi.Input[Union['JobServiceFromSpecificationArgs', 'JobServiceFromSpecificationArgsDict']]] = None,
                 from_specification_template: Optional[pulumi.Input[Union['JobServiceFromSpecificationTemplateArgs', 'JobServiceFromSpecificationTemplateArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/jobService:JobService example '"<database_name>"."<schema_name>"."<job_service_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the service.
        :param pulumi.Input[_builtins.str] compute_pool: Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] database: The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: Specifies the names of the external access integrations that allow your service to access external sites.
        :param pulumi.Input[Union['JobServiceFromSpecificationArgs', 'JobServiceFromSpecificationArgsDict']] from_specification: Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[Union['JobServiceFromSpecificationTemplateArgs', 'JobServiceFromSpecificationTemplateArgsDict']] from_specification_template: Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] query_warehouse: Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/jobService:JobService example '"<database_name>"."<schema_name>"."<job_service_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param JobServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_specification: Optional[pulumi.Input[Union['JobServiceFromSpecificationArgs', 'JobServiceFromSpecificationArgsDict']]] = None,
                 from_specification_template: Optional[pulumi.Input[Union['JobServiceFromSpecificationTemplateArgs', 'JobServiceFromSpecificationTemplateArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobServiceArgs.__new__(JobServiceArgs)

            __props__.__dict__["comment"] = comment
            if compute_pool is None and not opts.urn:
                raise TypeError("Missing required property 'compute_pool'")
            __props__.__dict__["compute_pool"] = compute_pool
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["external_access_integrations"] = external_access_integrations
            __props__.__dict__["from_specification"] = from_specification
            __props__.__dict__["from_specification_template"] = from_specification_template
            __props__.__dict__["name"] = name
            __props__.__dict__["query_warehouse"] = query_warehouse
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["show_outputs"] = None
        super(JobService, __self__).__init__(
            'snowflake:index/jobService:JobService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            compute_pool: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobServiceDescribeOutputArgs', 'JobServiceDescribeOutputArgsDict']]]]] = None,
            external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            from_specification: Optional[pulumi.Input[Union['JobServiceFromSpecificationArgs', 'JobServiceFromSpecificationArgsDict']]] = None,
            from_specification_template: Optional[pulumi.Input[Union['JobServiceFromSpecificationTemplateArgs', 'JobServiceFromSpecificationTemplateArgsDict']]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query_warehouse: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            service_type: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobServiceShowOutputArgs', 'JobServiceShowOutputArgsDict']]]]] = None) -> 'JobService':
        """
        Get an existing JobService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the service.
        :param pulumi.Input[_builtins.str] compute_pool: Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] database: The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobServiceDescribeOutputArgs', 'JobServiceDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE SERVICE` for the given service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: Specifies the names of the external access integrations that allow your service to access external sites.
        :param pulumi.Input[Union['JobServiceFromSpecificationArgs', 'JobServiceFromSpecificationArgsDict']] from_specification: Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[Union['JobServiceFromSpecificationTemplateArgs', 'JobServiceFromSpecificationTemplateArgsDict']] from_specification_template: Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] query_warehouse: Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] service_type: Specifies a type for the service. This field is used for checking external changes and recreating the resources if needed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobServiceShowOutputArgs', 'JobServiceShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW SERVICES` for the given service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobServiceState.__new__(_JobServiceState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["compute_pool"] = compute_pool
        __props__.__dict__["database"] = database
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["external_access_integrations"] = external_access_integrations
        __props__.__dict__["from_specification"] = from_specification
        __props__.__dict__["from_specification_template"] = from_specification_template
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["name"] = name
        __props__.__dict__["query_warehouse"] = query_warehouse
        __props__.__dict__["schema"] = schema
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["show_outputs"] = show_outputs
        return JobService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the service.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "compute_pool")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.JobServiceDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE SERVICE` for the given service.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the names of the external access integrations that allow your service to access external sites.
        """
        return pulumi.get(self, "external_access_integrations")

    @_builtins.property
    @pulumi.getter(name="fromSpecification")
    def from_specification(self) -> pulumi.Output[Optional['outputs.JobServiceFromSpecification']]:
        """
        Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification")

    @_builtins.property
    @pulumi.getter(name="fromSpecificationTemplate")
    def from_specification_template(self) -> pulumi.Output[Optional['outputs.JobServiceFromSpecificationTemplate']]:
        """
        Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification_template")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queryWarehouse")
    def query_warehouse(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "query_warehouse")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a type for the service. This field is used for checking external changes and recreating the resources if needed.
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.JobServiceShowOutput']]:
        """
        Outputs the result of `SHOW SERVICES` for the given service.
        """
        return pulumi.get(self, "show_outputs")

