# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProcedureJavaArgs', 'ProcedureJava']

@pulumi.input_type
class ProcedureJavaArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 handler: pulumi.Input[_builtins.str],
                 return_type: pulumi.Input[_builtins.str],
                 runtime_version: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 snowpark_package: pulumi.Input[_builtins.str],
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaArgumentArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 execute_as: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 imports: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaImportArgs']]]] = None,
                 is_secure: Optional[pulumi.Input[_builtins.str]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_level: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 procedure_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaSecretArgs']]]] = None,
                 target_path: Optional[pulumi.Input['ProcedureJavaTargetPathArgs']] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProcedureJava resource.
        :param pulumi.Input[_builtins.str] database: The database in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] handler: Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        :param pulumi.Input[_builtins.str] return_type: Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Java Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-java-data-type-mappings)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
        :param pulumi.Input[_builtins.str] runtime_version: The language runtime version to use. Currently, the supported versions are: 11.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] snowpark_package: The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        :param pulumi.Input[Sequence[pulumi.Input['ProcedureJavaArgumentArgs']]] arguments: List of the arguments for the procedure. Consult the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-procedure#all-languages) for more details.
        :param pulumi.Input[_builtins.str] comment: (Default: `user-defined procedure`) Specifies a comment for the procedure.
        :param pulumi.Input[_builtins.bool] enable_console_output: Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG*LEVEL). For more information, check [ENABLE*CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
        :param pulumi.Input[_builtins.str] execute_as: Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
        :param pulumi.Input[Sequence[pulumi.Input['ProcedureJavaImportArgs']]] imports: The location (stage), path, and name of the file(s) to import. You must set the IMPORTS clause to include any files that your stored procedure depends on. If you are writing an in-line stored procedure, you can omit this clause, unless your code depends on classes defined outside the stored procedure or resource files. If you are writing a stored procedure with a staged handler, you must also include a path to the JAR file containing the stored procedure’s handler code. The IMPORTS definition cannot reference variables from arguments that are passed into the stored procedure. Each file in the IMPORTS clause must have a unique name, even if the files are in different subdirectories or different stages.
        :param pulumi.Input[_builtins.str] is_secure: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] log_level: LOG*LEVEL to use when filtering events For more information, check [LOG*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        :param pulumi.Input[_builtins.str] metric_level: METRIC*LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
        :param pulumi.Input[_builtins.str] name: The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] null_input_behavior: Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] packages: List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        :param pulumi.Input[_builtins.str] procedure_definition: Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Java source code. For more information, see [Java (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-java). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        :param pulumi.Input[Sequence[pulumi.Input['ProcedureJavaSecretArgs']]] secrets: Assigns the names of [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) to variables so that you can use the variables to reference the secrets when retrieving information from secrets in handler code. Secrets you specify here must be allowed by the [external access integration](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) specified as a value of this CREATE FUNCTION command’s EXTERNAL*ACCESS*INTEGRATIONS parameter.
        :param pulumi.Input['ProcedureJavaTargetPathArgs'] target_path: Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        :param pulumi.Input[_builtins.str] trace_level: Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "return_type", return_type)
        pulumi.set(__self__, "runtime_version", runtime_version)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "snowpark_package", snowpark_package)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enable_console_output is not None:
            pulumi.set(__self__, "enable_console_output", enable_console_output)
        if execute_as is not None:
            pulumi.set(__self__, "execute_as", execute_as)
        if external_access_integrations is not None:
            pulumi.set(__self__, "external_access_integrations", external_access_integrations)
        if imports is not None:
            pulumi.set(__self__, "imports", imports)
        if is_secure is not None:
            pulumi.set(__self__, "is_secure", is_secure)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if metric_level is not None:
            pulumi.set(__self__, "metric_level", metric_level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_input_behavior is not None:
            pulumi.set(__self__, "null_input_behavior", null_input_behavior)
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if procedure_definition is not None:
            pulumi.set(__self__, "procedure_definition", procedure_definition)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if target_path is not None:
            pulumi.set(__self__, "target_path", target_path)
        if trace_level is not None:
            pulumi.set(__self__, "trace_level", trace_level)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def handler(self) -> pulumi.Input[_builtins.str]:
        """
        Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "handler", value)

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Java Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-java-data-type-mappings)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "return_type", value)

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Input[_builtins.str]:
        """
        The language runtime version to use. Currently, the supported versions are: 11.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "runtime_version", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="snowparkPackage")
    def snowpark_package(self) -> pulumi.Input[_builtins.str]:
        """
        The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        """
        return pulumi.get(self, "snowpark_package")

    @snowpark_package.setter
    def snowpark_package(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snowpark_package", value)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaArgumentArgs']]]]:
        """
        List of the arguments for the procedure. Consult the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-procedure#all-languages) for more details.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `user-defined procedure`) Specifies a comment for the procedure.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="enableConsoleOutput")
    def enable_console_output(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG*LEVEL). For more information, check [ENABLE*CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
        """
        return pulumi.get(self, "enable_console_output")

    @enable_console_output.setter
    def enable_console_output(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_console_output", value)

    @_builtins.property
    @pulumi.getter(name="executeAs")
    def execute_as(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
        """
        return pulumi.get(self, "execute_as")

    @execute_as.setter
    def execute_as(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execute_as", value)

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
        """
        return pulumi.get(self, "external_access_integrations")

    @external_access_integrations.setter
    def external_access_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_access_integrations", value)

    @_builtins.property
    @pulumi.getter
    def imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaImportArgs']]]]:
        """
        The location (stage), path, and name of the file(s) to import. You must set the IMPORTS clause to include any files that your stored procedure depends on. If you are writing an in-line stored procedure, you can omit this clause, unless your code depends on classes defined outside the stored procedure or resource files. If you are writing a stored procedure with a staged handler, you must also include a path to the JAR file containing the stored procedure’s handler code. The IMPORTS definition cannot reference variables from arguments that are passed into the stored procedure. Each file in the IMPORTS clause must have a unique name, even if the files are in different subdirectories or different stages.
        """
        return pulumi.get(self, "imports")

    @imports.setter
    def imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaImportArgs']]]]):
        pulumi.set(self, "imports", value)

    @_builtins.property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "is_secure")

    @is_secure.setter
    def is_secure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_secure", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LOG*LEVEL to use when filtering events For more information, check [LOG*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter(name="metricLevel")
    def metric_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        METRIC*LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
        """
        return pulumi.get(self, "metric_level")

    @metric_level.setter
    def metric_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_level", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
        """
        return pulumi.get(self, "null_input_behavior")

    @null_input_behavior.setter
    def null_input_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "null_input_behavior", value)

    @_builtins.property
    @pulumi.getter
    def packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "packages", value)

    @_builtins.property
    @pulumi.getter(name="procedureDefinition")
    def procedure_definition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Java source code. For more information, see [Java (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-java). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        return pulumi.get(self, "procedure_definition")

    @procedure_definition.setter
    def procedure_definition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "procedure_definition", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaSecretArgs']]]]:
        """
        Assigns the names of [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) to variables so that you can use the variables to reference the secrets when retrieving information from secrets in handler code. Secrets you specify here must be allowed by the [external access integration](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) specified as a value of this CREATE FUNCTION command’s EXTERNAL*ACCESS*INTEGRATIONS parameter.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> Optional[pulumi.Input['ProcedureJavaTargetPathArgs']]:
        """
        Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        """
        return pulumi.get(self, "target_path")

    @target_path.setter
    def target_path(self, value: Optional[pulumi.Input['ProcedureJavaTargetPathArgs']]):
        pulumi.set(self, "target_path", value)

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        return pulumi.get(self, "trace_level")

    @trace_level.setter
    def trace_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_level", value)


@pulumi.input_type
class _ProcedureJavaState:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaArgumentArgs']]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 execute_as: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 imports: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaImportArgs']]]] = None,
                 is_secure: Optional[pulumi.Input[_builtins.str]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_level: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaParameterArgs']]]] = None,
                 procedure_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 procedure_language: Optional[pulumi.Input[_builtins.str]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaSecretArgs']]]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaShowOutputArgs']]]] = None,
                 snowpark_package: Optional[pulumi.Input[_builtins.str]] = None,
                 target_path: Optional[pulumi.Input['ProcedureJavaTargetPathArgs']] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProcedureJava resources.
        :param pulumi.Input[Sequence[pulumi.Input['ProcedureJavaArgumentArgs']]] arguments: List of the arguments for the procedure. Consult the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-procedure#all-languages) for more details.
        :param pulumi.Input[_builtins.str] comment: (Default: `user-defined procedure`) Specifies a comment for the procedure.
        :param pulumi.Input[_builtins.str] database: The database in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] enable_console_output: Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG*LEVEL). For more information, check [ENABLE*CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
        :param pulumi.Input[_builtins.str] execute_as: Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] handler: Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        :param pulumi.Input[Sequence[pulumi.Input['ProcedureJavaImportArgs']]] imports: The location (stage), path, and name of the file(s) to import. You must set the IMPORTS clause to include any files that your stored procedure depends on. If you are writing an in-line stored procedure, you can omit this clause, unless your code depends on classes defined outside the stored procedure or resource files. If you are writing a stored procedure with a staged handler, you must also include a path to the JAR file containing the stored procedure’s handler code. The IMPORTS definition cannot reference variables from arguments that are passed into the stored procedure. Each file in the IMPORTS clause must have a unique name, even if the files are in different subdirectories or different stages.
        :param pulumi.Input[_builtins.str] is_secure: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] log_level: LOG*LEVEL to use when filtering events For more information, check [LOG*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        :param pulumi.Input[_builtins.str] metric_level: METRIC*LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
        :param pulumi.Input[_builtins.str] name: The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] null_input_behavior: Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] packages: List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        :param pulumi.Input[Sequence[pulumi.Input['ProcedureJavaParameterArgs']]] parameters: Outputs the result of `SHOW PARAMETERS IN PROCEDURE` for the given procedure.
        :param pulumi.Input[_builtins.str] procedure_definition: Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Java source code. For more information, see [Java (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-java). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        :param pulumi.Input[_builtins.str] procedure_language: Specifies language for the procedure. Used to detect external changes.
        :param pulumi.Input[_builtins.str] return_type: Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Java Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-java-data-type-mappings)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
        :param pulumi.Input[_builtins.str] runtime_version: The language runtime version to use. Currently, the supported versions are: 11.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['ProcedureJavaSecretArgs']]] secrets: Assigns the names of [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) to variables so that you can use the variables to reference the secrets when retrieving information from secrets in handler code. Secrets you specify here must be allowed by the [external access integration](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) specified as a value of this CREATE FUNCTION command’s EXTERNAL*ACCESS*INTEGRATIONS parameter.
        :param pulumi.Input[Sequence[pulumi.Input['ProcedureJavaShowOutputArgs']]] show_outputs: Outputs the result of `SHOW PROCEDURE` for the given procedure.
        :param pulumi.Input[_builtins.str] snowpark_package: The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        :param pulumi.Input['ProcedureJavaTargetPathArgs'] target_path: Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        :param pulumi.Input[_builtins.str] trace_level: Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if enable_console_output is not None:
            pulumi.set(__self__, "enable_console_output", enable_console_output)
        if execute_as is not None:
            pulumi.set(__self__, "execute_as", execute_as)
        if external_access_integrations is not None:
            pulumi.set(__self__, "external_access_integrations", external_access_integrations)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if imports is not None:
            pulumi.set(__self__, "imports", imports)
        if is_secure is not None:
            pulumi.set(__self__, "is_secure", is_secure)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if metric_level is not None:
            pulumi.set(__self__, "metric_level", metric_level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if null_input_behavior is not None:
            pulumi.set(__self__, "null_input_behavior", null_input_behavior)
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if procedure_definition is not None:
            pulumi.set(__self__, "procedure_definition", procedure_definition)
        if procedure_language is not None:
            pulumi.set(__self__, "procedure_language", procedure_language)
        if return_type is not None:
            pulumi.set(__self__, "return_type", return_type)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if snowpark_package is not None:
            pulumi.set(__self__, "snowpark_package", snowpark_package)
        if target_path is not None:
            pulumi.set(__self__, "target_path", target_path)
        if trace_level is not None:
            pulumi.set(__self__, "trace_level", trace_level)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaArgumentArgs']]]]:
        """
        List of the arguments for the procedure. Consult the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-procedure#all-languages) for more details.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `user-defined procedure`) Specifies a comment for the procedure.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="enableConsoleOutput")
    def enable_console_output(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG*LEVEL). For more information, check [ENABLE*CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
        """
        return pulumi.get(self, "enable_console_output")

    @enable_console_output.setter
    def enable_console_output(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_console_output", value)

    @_builtins.property
    @pulumi.getter(name="executeAs")
    def execute_as(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
        """
        return pulumi.get(self, "execute_as")

    @execute_as.setter
    def execute_as(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execute_as", value)

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
        """
        return pulumi.get(self, "external_access_integrations")

    @external_access_integrations.setter
    def external_access_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_access_integrations", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handler", value)

    @_builtins.property
    @pulumi.getter
    def imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaImportArgs']]]]:
        """
        The location (stage), path, and name of the file(s) to import. You must set the IMPORTS clause to include any files that your stored procedure depends on. If you are writing an in-line stored procedure, you can omit this clause, unless your code depends on classes defined outside the stored procedure or resource files. If you are writing a stored procedure with a staged handler, you must also include a path to the JAR file containing the stored procedure’s handler code. The IMPORTS definition cannot reference variables from arguments that are passed into the stored procedure. Each file in the IMPORTS clause must have a unique name, even if the files are in different subdirectories or different stages.
        """
        return pulumi.get(self, "imports")

    @imports.setter
    def imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaImportArgs']]]]):
        pulumi.set(self, "imports", value)

    @_builtins.property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "is_secure")

    @is_secure.setter
    def is_secure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_secure", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        LOG*LEVEL to use when filtering events For more information, check [LOG*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter(name="metricLevel")
    def metric_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        METRIC*LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
        """
        return pulumi.get(self, "metric_level")

    @metric_level.setter
    def metric_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_level", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
        """
        return pulumi.get(self, "null_input_behavior")

    @null_input_behavior.setter
    def null_input_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "null_input_behavior", value)

    @_builtins.property
    @pulumi.getter
    def packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "packages", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaParameterArgs']]]]:
        """
        Outputs the result of `SHOW PARAMETERS IN PROCEDURE` for the given procedure.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="procedureDefinition")
    def procedure_definition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Java source code. For more information, see [Java (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-java). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        return pulumi.get(self, "procedure_definition")

    @procedure_definition.setter
    def procedure_definition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "procedure_definition", value)

    @_builtins.property
    @pulumi.getter(name="procedureLanguage")
    def procedure_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies language for the procedure. Used to detect external changes.
        """
        return pulumi.get(self, "procedure_language")

    @procedure_language.setter
    def procedure_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "procedure_language", value)

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Java Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-java-data-type-mappings)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "return_type", value)

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language runtime version to use. Currently, the supported versions are: 11.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_version", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaSecretArgs']]]]:
        """
        Assigns the names of [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) to variables so that you can use the variables to reference the secrets when retrieving information from secrets in handler code. Secrets you specify here must be allowed by the [external access integration](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) specified as a value of this CREATE FUNCTION command’s EXTERNAL*ACCESS*INTEGRATIONS parameter.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW PROCEDURE` for the given procedure.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcedureJavaShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter(name="snowparkPackage")
    def snowpark_package(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        """
        return pulumi.get(self, "snowpark_package")

    @snowpark_package.setter
    def snowpark_package(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snowpark_package", value)

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> Optional[pulumi.Input['ProcedureJavaTargetPathArgs']]:
        """
        Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        """
        return pulumi.get(self, "target_path")

    @target_path.setter
    def target_path(self, value: Optional[pulumi.Input['ProcedureJavaTargetPathArgs']]):
        pulumi.set(self, "target_path", value)

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        return pulumi.get(self, "trace_level")

    @trace_level.setter
    def trace_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_level", value)


@pulumi.type_token("snowflake:index/procedureJava:ProcedureJava")
class ProcedureJava(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaArgumentArgs', 'ProcedureJavaArgumentArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 execute_as: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaImportArgs', 'ProcedureJavaImportArgsDict']]]]] = None,
                 is_secure: Optional[pulumi.Input[_builtins.str]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_level: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 procedure_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaSecretArgs', 'ProcedureJavaSecretArgsDict']]]]] = None,
                 snowpark_package: Optional[pulumi.Input[_builtins.str]] = None,
                 target_path: Optional[pulumi.Input[Union['ProcedureJavaTargetPathArgs', 'ProcedureJavaTargetPathArgsDict']]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/procedureJava:ProcedureJava example '"<database_name>"."<schema_name>"."<function_name>"(varchar, varchar, varchar)'
        ```

        Note: Snowflake is not returning all information needed to populate the state correctly after import (e.g. data types with attributes like NUMBER(32, 10) are returned as NUMBER, default values for arguments are not returned at all).

        Also, `ALTER` for functions is very limited so most of the attributes on this resource are marked as force new. Because of that, in multiple situations plan won't be empty after importing and manual state operations may be required.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaArgumentArgs', 'ProcedureJavaArgumentArgsDict']]]] arguments: List of the arguments for the procedure. Consult the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-procedure#all-languages) for more details.
        :param pulumi.Input[_builtins.str] comment: (Default: `user-defined procedure`) Specifies a comment for the procedure.
        :param pulumi.Input[_builtins.str] database: The database in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] enable_console_output: Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG*LEVEL). For more information, check [ENABLE*CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
        :param pulumi.Input[_builtins.str] execute_as: Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
        :param pulumi.Input[_builtins.str] handler: Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaImportArgs', 'ProcedureJavaImportArgsDict']]]] imports: The location (stage), path, and name of the file(s) to import. You must set the IMPORTS clause to include any files that your stored procedure depends on. If you are writing an in-line stored procedure, you can omit this clause, unless your code depends on classes defined outside the stored procedure or resource files. If you are writing a stored procedure with a staged handler, you must also include a path to the JAR file containing the stored procedure’s handler code. The IMPORTS definition cannot reference variables from arguments that are passed into the stored procedure. Each file in the IMPORTS clause must have a unique name, even if the files are in different subdirectories or different stages.
        :param pulumi.Input[_builtins.str] is_secure: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] log_level: LOG*LEVEL to use when filtering events For more information, check [LOG*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        :param pulumi.Input[_builtins.str] metric_level: METRIC*LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
        :param pulumi.Input[_builtins.str] name: The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] null_input_behavior: Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] packages: List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        :param pulumi.Input[_builtins.str] procedure_definition: Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Java source code. For more information, see [Java (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-java). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        :param pulumi.Input[_builtins.str] return_type: Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Java Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-java-data-type-mappings)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
        :param pulumi.Input[_builtins.str] runtime_version: The language runtime version to use. Currently, the supported versions are: 11.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaSecretArgs', 'ProcedureJavaSecretArgsDict']]]] secrets: Assigns the names of [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) to variables so that you can use the variables to reference the secrets when retrieving information from secrets in handler code. Secrets you specify here must be allowed by the [external access integration](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) specified as a value of this CREATE FUNCTION command’s EXTERNAL*ACCESS*INTEGRATIONS parameter.
        :param pulumi.Input[_builtins.str] snowpark_package: The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        :param pulumi.Input[Union['ProcedureJavaTargetPathArgs', 'ProcedureJavaTargetPathArgsDict']] target_path: Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        :param pulumi.Input[_builtins.str] trace_level: Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProcedureJavaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/procedureJava:ProcedureJava example '"<database_name>"."<schema_name>"."<function_name>"(varchar, varchar, varchar)'
        ```

        Note: Snowflake is not returning all information needed to populate the state correctly after import (e.g. data types with attributes like NUMBER(32, 10) are returned as NUMBER, default values for arguments are not returned at all).

        Also, `ALTER` for functions is very limited so most of the attributes on this resource are marked as force new. Because of that, in multiple situations plan won't be empty after importing and manual state operations may be required.

        :param str resource_name: The name of the resource.
        :param ProcedureJavaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProcedureJavaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaArgumentArgs', 'ProcedureJavaArgumentArgsDict']]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 execute_as: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaImportArgs', 'ProcedureJavaImportArgsDict']]]]] = None,
                 is_secure: Optional[pulumi.Input[_builtins.str]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_level: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 procedure_definition: Optional[pulumi.Input[_builtins.str]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaSecretArgs', 'ProcedureJavaSecretArgsDict']]]]] = None,
                 snowpark_package: Optional[pulumi.Input[_builtins.str]] = None,
                 target_path: Optional[pulumi.Input[Union['ProcedureJavaTargetPathArgs', 'ProcedureJavaTargetPathArgsDict']]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProcedureJavaArgs.__new__(ProcedureJavaArgs)

            __props__.__dict__["arguments"] = arguments
            __props__.__dict__["comment"] = comment
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["enable_console_output"] = enable_console_output
            __props__.__dict__["execute_as"] = execute_as
            __props__.__dict__["external_access_integrations"] = external_access_integrations
            if handler is None and not opts.urn:
                raise TypeError("Missing required property 'handler'")
            __props__.__dict__["handler"] = handler
            __props__.__dict__["imports"] = imports
            __props__.__dict__["is_secure"] = is_secure
            __props__.__dict__["log_level"] = log_level
            __props__.__dict__["metric_level"] = metric_level
            __props__.__dict__["name"] = name
            __props__.__dict__["null_input_behavior"] = null_input_behavior
            __props__.__dict__["packages"] = packages
            __props__.__dict__["procedure_definition"] = procedure_definition
            if return_type is None and not opts.urn:
                raise TypeError("Missing required property 'return_type'")
            __props__.__dict__["return_type"] = return_type
            if runtime_version is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_version'")
            __props__.__dict__["runtime_version"] = runtime_version
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["secrets"] = secrets
            if snowpark_package is None and not opts.urn:
                raise TypeError("Missing required property 'snowpark_package'")
            __props__.__dict__["snowpark_package"] = snowpark_package
            __props__.__dict__["target_path"] = target_path
            __props__.__dict__["trace_level"] = trace_level
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["parameters"] = None
            __props__.__dict__["procedure_language"] = None
            __props__.__dict__["show_outputs"] = None
        super(ProcedureJava, __self__).__init__(
            'snowflake:index/procedureJava:ProcedureJava',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaArgumentArgs', 'ProcedureJavaArgumentArgsDict']]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
            execute_as: Optional[pulumi.Input[_builtins.str]] = None,
            external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            handler: Optional[pulumi.Input[_builtins.str]] = None,
            imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaImportArgs', 'ProcedureJavaImportArgsDict']]]]] = None,
            is_secure: Optional[pulumi.Input[_builtins.str]] = None,
            log_level: Optional[pulumi.Input[_builtins.str]] = None,
            metric_level: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            null_input_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            packages: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaParameterArgs', 'ProcedureJavaParameterArgsDict']]]]] = None,
            procedure_definition: Optional[pulumi.Input[_builtins.str]] = None,
            procedure_language: Optional[pulumi.Input[_builtins.str]] = None,
            return_type: Optional[pulumi.Input[_builtins.str]] = None,
            runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaSecretArgs', 'ProcedureJavaSecretArgsDict']]]]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaShowOutputArgs', 'ProcedureJavaShowOutputArgsDict']]]]] = None,
            snowpark_package: Optional[pulumi.Input[_builtins.str]] = None,
            target_path: Optional[pulumi.Input[Union['ProcedureJavaTargetPathArgs', 'ProcedureJavaTargetPathArgsDict']]] = None,
            trace_level: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProcedureJava':
        """
        Get an existing ProcedureJava resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaArgumentArgs', 'ProcedureJavaArgumentArgsDict']]]] arguments: List of the arguments for the procedure. Consult the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-procedure#all-languages) for more details.
        :param pulumi.Input[_builtins.str] comment: (Default: `user-defined procedure`) Specifies a comment for the procedure.
        :param pulumi.Input[_builtins.str] database: The database in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] enable_console_output: Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG*LEVEL). For more information, check [ENABLE*CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
        :param pulumi.Input[_builtins.str] execute_as: Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] handler: Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaImportArgs', 'ProcedureJavaImportArgsDict']]]] imports: The location (stage), path, and name of the file(s) to import. You must set the IMPORTS clause to include any files that your stored procedure depends on. If you are writing an in-line stored procedure, you can omit this clause, unless your code depends on classes defined outside the stored procedure or resource files. If you are writing a stored procedure with a staged handler, you must also include a path to the JAR file containing the stored procedure’s handler code. The IMPORTS definition cannot reference variables from arguments that are passed into the stored procedure. Each file in the IMPORTS clause must have a unique name, even if the files are in different subdirectories or different stages.
        :param pulumi.Input[_builtins.str] is_secure: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] log_level: LOG*LEVEL to use when filtering events For more information, check [LOG*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        :param pulumi.Input[_builtins.str] metric_level: METRIC*LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
        :param pulumi.Input[_builtins.str] name: The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] null_input_behavior: Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] packages: List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaParameterArgs', 'ProcedureJavaParameterArgsDict']]]] parameters: Outputs the result of `SHOW PARAMETERS IN PROCEDURE` for the given procedure.
        :param pulumi.Input[_builtins.str] procedure_definition: Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Java source code. For more information, see [Java (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-java). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        :param pulumi.Input[_builtins.str] procedure_language: Specifies language for the procedure. Used to detect external changes.
        :param pulumi.Input[_builtins.str] return_type: Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Java Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-java-data-type-mappings)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
        :param pulumi.Input[_builtins.str] runtime_version: The language runtime version to use. Currently, the supported versions are: 11.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaSecretArgs', 'ProcedureJavaSecretArgsDict']]]] secrets: Assigns the names of [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) to variables so that you can use the variables to reference the secrets when retrieving information from secrets in handler code. Secrets you specify here must be allowed by the [external access integration](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) specified as a value of this CREATE FUNCTION command’s EXTERNAL*ACCESS*INTEGRATIONS parameter.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProcedureJavaShowOutputArgs', 'ProcedureJavaShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW PROCEDURE` for the given procedure.
        :param pulumi.Input[_builtins.str] snowpark_package: The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        :param pulumi.Input[Union['ProcedureJavaTargetPathArgs', 'ProcedureJavaTargetPathArgsDict']] target_path: Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        :param pulumi.Input[_builtins.str] trace_level: Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProcedureJavaState.__new__(_ProcedureJavaState)

        __props__.__dict__["arguments"] = arguments
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database"] = database
        __props__.__dict__["enable_console_output"] = enable_console_output
        __props__.__dict__["execute_as"] = execute_as
        __props__.__dict__["external_access_integrations"] = external_access_integrations
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["handler"] = handler
        __props__.__dict__["imports"] = imports
        __props__.__dict__["is_secure"] = is_secure
        __props__.__dict__["log_level"] = log_level
        __props__.__dict__["metric_level"] = metric_level
        __props__.__dict__["name"] = name
        __props__.__dict__["null_input_behavior"] = null_input_behavior
        __props__.__dict__["packages"] = packages
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["procedure_definition"] = procedure_definition
        __props__.__dict__["procedure_language"] = procedure_language
        __props__.__dict__["return_type"] = return_type
        __props__.__dict__["runtime_version"] = runtime_version
        __props__.__dict__["schema"] = schema
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["snowpark_package"] = snowpark_package
        __props__.__dict__["target_path"] = target_path
        __props__.__dict__["trace_level"] = trace_level
        return ProcedureJava(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> pulumi.Output[Optional[Sequence['outputs.ProcedureJavaArgument']]]:
        """
        List of the arguments for the procedure. Consult the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-procedure#all-languages) for more details.
        """
        return pulumi.get(self, "arguments")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: `user-defined procedure`) Specifies a comment for the procedure.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="enableConsoleOutput")
    def enable_console_output(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG*LEVEL). For more information, check [ENABLE*CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
        """
        return pulumi.get(self, "enable_console_output")

    @_builtins.property
    @pulumi.getter(name="executeAs")
    def execute_as(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
        """
        return pulumi.get(self, "execute_as")

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
        """
        return pulumi.get(self, "external_access_integrations")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def handler(self) -> pulumi.Output[_builtins.str]:
        """
        Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        """
        return pulumi.get(self, "handler")

    @_builtins.property
    @pulumi.getter
    def imports(self) -> pulumi.Output[Optional[Sequence['outputs.ProcedureJavaImport']]]:
        """
        The location (stage), path, and name of the file(s) to import. You must set the IMPORTS clause to include any files that your stored procedure depends on. If you are writing an in-line stored procedure, you can omit this clause, unless your code depends on classes defined outside the stored procedure or resource files. If you are writing a stored procedure with a staged handler, you must also include a path to the JAR file containing the stored procedure’s handler code. The IMPORTS definition cannot reference variables from arguments that are passed into the stored procedure. Each file in the IMPORTS clause must have a unique name, even if the files are in different subdirectories or different stages.
        """
        return pulumi.get(self, "imports")

    @_builtins.property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "is_secure")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Output[_builtins.str]:
        """
        LOG*LEVEL to use when filtering events For more information, check [LOG*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter(name="metricLevel")
    def metric_level(self) -> pulumi.Output[_builtins.str]:
        """
        METRIC*LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC*LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
        """
        return pulumi.get(self, "metric_level")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nullInputBehavior")
    def null_input_behavior(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
        """
        return pulumi.get(self, "null_input_behavior")

    @_builtins.property
    @pulumi.getter
    def packages(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        """
        return pulumi.get(self, "packages")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.ProcedureJavaParameter']]:
        """
        Outputs the result of `SHOW PARAMETERS IN PROCEDURE` for the given procedure.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="procedureDefinition")
    def procedure_definition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Java source code. For more information, see [Java (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-java). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
        """
        return pulumi.get(self, "procedure_definition")

    @_builtins.property
    @pulumi.getter(name="procedureLanguage")
    def procedure_language(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies language for the procedure. Used to detect external changes.
        """
        return pulumi.get(self, "procedure_language")

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Java Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-java-data-type-mappings)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
        """
        return pulumi.get(self, "return_type")

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Output[_builtins.str]:
        """
        The language runtime version to use. Currently, the supported versions are: 11.
        """
        return pulumi.get(self, "runtime_version")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the procedure. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Optional[Sequence['outputs.ProcedureJavaSecret']]]:
        """
        Assigns the names of [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) to variables so that you can use the variables to reference the secrets when retrieving information from secrets in handler code. Secrets you specify here must be allowed by the [external access integration](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) specified as a value of this CREATE FUNCTION command’s EXTERNAL*ACCESS*INTEGRATIONS parameter.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.ProcedureJavaShowOutput']]:
        """
        Outputs the result of `SHOW PROCEDURE` for the given procedure.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter(name="snowparkPackage")
    def snowpark_package(self) -> pulumi.Output[_builtins.str]:
        """
        The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
        """
        return pulumi.get(self, "snowpark_package")

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> pulumi.Output[Optional['outputs.ProcedureJavaTargetPath']]:
        """
        Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
        """
        return pulumi.get(self, "target_path")

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> pulumi.Output[_builtins.str]:
        """
        Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
        """
        return pulumi.get(self, "trace_level")

