"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Provider = exports.BlockDurationMinutes = exports.InstanceInterruptionBehavior = exports.SpotInstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const spotone = require("cdk-spot-one");
const constructs_1 = require("constructs");
var SpotInstanceType;
(function (SpotInstanceType) {
    SpotInstanceType["ONE_TIME"] = "one-time";
    SpotInstanceType["PERSISTENT"] = "persistent";
})(SpotInstanceType = exports.SpotInstanceType || (exports.SpotInstanceType = {}));
var InstanceInterruptionBehavior;
(function (InstanceInterruptionBehavior) {
    InstanceInterruptionBehavior["HIBERNATE"] = "hibernate";
    InstanceInterruptionBehavior["STOP"] = "stop";
    InstanceInterruptionBehavior["TERMINATE"] = "terminate";
})(InstanceInterruptionBehavior = exports.InstanceInterruptionBehavior || (exports.InstanceInterruptionBehavior = {}));
var BlockDurationMinutes;
(function (BlockDurationMinutes) {
    BlockDurationMinutes[BlockDurationMinutes["ONE_HOUR"] = 60] = "ONE_HOUR";
    BlockDurationMinutes[BlockDurationMinutes["TWO_HOURS"] = 120] = "TWO_HOURS";
    BlockDurationMinutes[BlockDurationMinutes["THREE_HOURS"] = 180] = "THREE_HOURS";
    BlockDurationMinutes[BlockDurationMinutes["FOUR_HOURS"] = 240] = "FOUR_HOURS";
    BlockDurationMinutes[BlockDurationMinutes["FIVE_HOURS"] = 300] = "FIVE_HOURS";
    BlockDurationMinutes[BlockDurationMinutes["SIX_HOURS"] = 360] = "SIX_HOURS";
})(BlockDurationMinutes = exports.BlockDurationMinutes || (exports.BlockDurationMinutes = {}));
class Provider extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.defaultInstanceType = new aws_cdk_lib_1.aws_ec2.InstanceType('t3.large');
    }
    get amazonLinuxAmiImageId() {
        return new aws_cdk_lib_1.aws_ec2.AmazonLinuxImage({
            generation: aws_cdk_lib_1.aws_ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
        }).getImage(this).imageId;
    }
    getOrCreateVpc(scope) {
        // use an existing vpc or create a new one
        return scope.node.tryGetContext('use_default_vpc') === '1' ?
            aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
            scope.node.tryGetContext('use_vpc_id') ?
                aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
                new aws_cdk_lib_1.aws_ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
    }
    createInstanceProfile(id) {
        const role = new aws_cdk_lib_1.aws_iam.Role(this, `Role${id}`, {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
        });
        return new aws_cdk_lib_1.aws_iam.CfnInstanceProfile(this, `InstanceProfile${id}`, {
            roles: [role.roleName],
        });
    }
    /**
     * Create Launch Template
     * @param id launch template id
     * @param options launch template options
     */
    createLaunchTemplate(id, options = {}) {
        const instanceProfileArn = options.instanceProfile ? options.instanceProfile.attrArn
            : this.createInstanceProfile('DefaultInstanceProfile').attrArn;
        return new aws_cdk_lib_1.aws_ec2.CfnLaunchTemplate(this, id, {
            launchTemplateData: {
                imageId: options.machineImage?.getImage(this).imageId || this.amazonLinuxAmiImageId,
                instanceType: options.instanceType?.toString() || this.defaultInstanceType.toString(),
                userData: options.userData ? cdk.Fn.base64(options.userData.render()) : undefined,
                instanceMarketOptions: {
                    marketType: 'spot',
                    spotOptions: {
                        blockDurationMinutes: options.spotOptions?.blockDurationMinutes?.valueOf(),
                        instanceInterruptionBehavior: options.spotOptions?.instanceInterruptionBehavior?.valueOf(),
                        maxPrice: options.spotOptions?.maxPrice,
                        spotInstanceType: options.spotOptions?.spotInstanceType?.valueOf(),
                    },
                },
                iamInstanceProfile: {
                    arn: instanceProfileArn,
                },
                tagSpecifications: [
                    {
                        resourceType: 'instance',
                        tags: [
                            {
                                key: 'Name',
                                value: `${this.node.path}/${id}`,
                            },
                        ],
                    },
                ],
            },
        });
    }
    /**
     * Create EC2 Spot Fleet
     * @param id fleet id
     * @param options spot fleet options
     */
    createFleet(id, options) {
        const lt = this.createLaunchTemplate(id, {
            instanceProfile: options.instanceProfile,
            instanceType: options.instanceType,
            machineImage: options.machineImage,
            spotOptions: options.spotOptions,
            userData: options.userData,
        });
        const spotFleetRole = new aws_cdk_lib_1.aws_iam.Role(this, 'FleetRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('spotfleet.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonEC2SpotFleetTaggingRole'),
            ],
        });
        const vpcSubnetSelection = options.vpcSubnet ?? {
            subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE,
        };
        const subnetConfig = options.vpc.selectSubnets(vpcSubnetSelection).subnets.map(s => ({
            subnetId: s.subnetId,
        }));
        const fleet = new aws_cdk_lib_1.aws_ec2.CfnSpotFleet(this, `${id}Resource`, {
            spotFleetRequestConfigData: {
                launchTemplateConfigs: [
                    {
                        launchTemplateSpecification: {
                            launchTemplateId: lt.ref,
                            version: lt.attrLatestVersionNumber,
                        },
                        overrides: subnetConfig,
                    },
                ],
                iamFleetRole: spotFleetRole.roleArn,
                targetCapacity: options.defaultCapacitySize ?? 1,
                validFrom: options.validFrom,
                validUntil: options.validUntil,
                terminateInstancesWithExpiration: options.terminateInstancesWithExpiration ?? true,
            },
        });
        return fleet;
    }
    /**
     * Create AutoScaling Group
     * @param id AutoScaling Group ID
     * @param options AutoScaling Group options
     */
    createAutoScalingGroup(id, options) {
        const asg = new aws_cdk_lib_1.aws_autoscaling.AutoScalingGroup(this, id, {
            instanceType: this.defaultInstanceType,
            machineImage: new aws_cdk_lib_1.aws_ec2.AmazonLinuxImage(),
            vpc: options.vpc,
            minCapacity: options.defaultCapacitySize ?? 1,
            updatePolicy: aws_cdk_lib_1.aws_autoscaling.UpdatePolicy.replacingUpdate(),
        });
        const cfnInstanceProfile = asg.node.tryFindChild('InstanceProfile');
        asg.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        const lt = this.createLaunchTemplate(`LaunchTemplate${id}`, {
            instanceProfile: cfnInstanceProfile,
            instanceType: options.instanceType,
            machineImage: options.machineImage,
            spotOptions: options.spotOptions,
            userData: options.userData,
        });
        // property override
        const cfnAsg = asg.node.tryFindChild('ASG');
        cfnAsg.addPropertyDeletionOverride('LaunchConfigurationName');
        cfnAsg.addPropertyOverride('LaunchTemplate', {
            LaunchTemplateId: lt.ref,
            Version: lt.attrLatestVersionNumber,
        });
        return asg;
    }
    createInstance(id, optons) {
        return new spotone.SpotInstance(this, id, optons);
    }
}
exports.Provider = Provider;
_a = JSII_RTTI_SYMBOL_1;
Provider[_a] = { fqn: "cdk-ec2spot.Provider", version: "2.0.133" };
//# sourceMappingURL=data:application/json;base64,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