# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.data_type import DataType

class ColumnInfo(BaseModel):
    """
    Information on how to construct a file-read sql query  # noqa: E501
    """
    select: Optional[StrictBool] = Field(default=None, description="Should the column be used/selected?")
    type: Optional[DataType] = None
    name:  Optional[StrictStr] = Field(None,alias="name", description="The name of the column") 
    x_path:  Optional[StrictStr] = Field(None,alias="xPath", description="Xpath for the column (only applicable to XML defined columns)") 
    __properties = ["select", "type", "name", "xPath"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ColumnInfo:
        """Create an instance of ColumnInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if x_path (nullable) is None
        # and __fields_set__ contains the field
        if self.x_path is None and "x_path" in self.__fields_set__:
            _dict['xPath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ColumnInfo:
        """Create an instance of ColumnInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ColumnInfo.parse_obj(obj)

        _obj = ColumnInfo.parse_obj({
            "select": obj.get("select"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "x_path": obj.get("xPath")
        })
        return _obj

ColumnInfo.update_forward_refs()
