# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.filter_type import FilterType
from luminesce.models.type import Type

class FilterModel(BaseModel):
    """
    Representation of the data used in a filter for the where clause  # noqa: E501
    """
    filter_type: FilterType = Field(alias="filterType")
    type: Optional[Type] = None
    filter:  Optional[StrictStr] = Field(None,alias="filter", description="The filter value") 
    filter_to: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The upper bound filter value for the number filter type", alias="filterTo")
    values: Optional[List[StrictStr]] = Field(default=None, description="An array of possible values for the set filter type")
    date_from:  Optional[StrictStr] = Field(None,alias="dateFrom", description="A lower bound date for the date filter type") 
    date_to:  Optional[StrictStr] = Field(None,alias="dateTo", description="An upper bound date for the date filter type") 
    __properties = ["filterType", "type", "filter", "filterTo", "values", "dateFrom", "dateTo"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FilterModel:
        """Create an instance of FilterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if filter (nullable) is None
        # and __fields_set__ contains the field
        if self.filter is None and "filter" in self.__fields_set__:
            _dict['filter'] = None

        # set to None if filter_to (nullable) is None
        # and __fields_set__ contains the field
        if self.filter_to is None and "filter_to" in self.__fields_set__:
            _dict['filterTo'] = None

        # set to None if values (nullable) is None
        # and __fields_set__ contains the field
        if self.values is None and "values" in self.__fields_set__:
            _dict['values'] = None

        # set to None if date_from (nullable) is None
        # and __fields_set__ contains the field
        if self.date_from is None and "date_from" in self.__fields_set__:
            _dict['dateFrom'] = None

        # set to None if date_to (nullable) is None
        # and __fields_set__ contains the field
        if self.date_to is None and "date_to" in self.__fields_set__:
            _dict['dateTo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FilterModel:
        """Create an instance of FilterModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FilterModel.parse_obj(obj)

        _obj = FilterModel.parse_obj({
            "filter_type": obj.get("filterType"),
            "type": obj.get("type"),
            "filter": obj.get("filter"),
            "filter_to": obj.get("filterTo"),
            "values": obj.get("values"),
            "date_from": obj.get("dateFrom"),
            "date_to": obj.get("dateTo")
        })
        return _obj

FilterModel.update_forward_refs()
