# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.inlined_property_item import InlinedPropertyItem

class InlinedPropertyDesign(BaseModel):
    """
    Representation of a set of inlined properties for a given provider so that SQL can be generated to be able to inline properties into luminesce  # noqa: E501
    """
    provider_name:  Optional[StrictStr] = Field(None,alias="providerName", description="The provider name for which these properties are to be inlined") 
    provider_name_extension:  Optional[StrictStr] = Field(None,alias="providerNameExtension", description="The provider extension name for extended providers") 
    inlined_property_items: Optional[List[InlinedPropertyItem]] = Field(default=None, description="Collection of Inlined properties", alias="inlinedPropertyItems")
    __properties = ["providerName", "providerNameExtension", "inlinedPropertyItems"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InlinedPropertyDesign:
        """Create an instance of InlinedPropertyDesign from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in inlined_property_items (list)
        _items = []
        if self.inlined_property_items:
            for _item in self.inlined_property_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['inlinedPropertyItems'] = _items
        # set to None if provider_name (nullable) is None
        # and __fields_set__ contains the field
        if self.provider_name is None and "provider_name" in self.__fields_set__:
            _dict['providerName'] = None

        # set to None if provider_name_extension (nullable) is None
        # and __fields_set__ contains the field
        if self.provider_name_extension is None and "provider_name_extension" in self.__fields_set__:
            _dict['providerNameExtension'] = None

        # set to None if inlined_property_items (nullable) is None
        # and __fields_set__ contains the field
        if self.inlined_property_items is None and "inlined_property_items" in self.__fields_set__:
            _dict['inlinedPropertyItems'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InlinedPropertyDesign:
        """Create an instance of InlinedPropertyDesign from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InlinedPropertyDesign.parse_obj(obj)

        _obj = InlinedPropertyDesign.parse_obj({
            "provider_name": obj.get("providerName"),
            "provider_name_extension": obj.get("providerNameExtension"),
            "inlined_property_items": [InlinedPropertyItem.from_dict(_item) for _item in obj.get("inlinedPropertyItems")] if obj.get("inlinedPropertyItems") is not None else None
        })
        return _obj

InlinedPropertyDesign.update_forward_refs()
