# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.column_state_type import ColumnStateType
from luminesce.models.filter_model import FilterModel
from luminesce.models.table_meta import TableMeta

class TableView(BaseModel):
    """
    Representation of the table structure  # noqa: E501
    """
    header_names: Dict[str, Optional[StrictStr]] = Field(description="Mapping of column ids to aliases", alias="headerNames")
    column_state: List[ColumnStateType] = Field(description="Array of all columns in the dashboard", alias="columnState")
    filters: Optional[Dict[str, FilterModel]] = Field(default=None, description="Filters applied to columns in the dashboard")
    meta: TableMeta
    __properties = ["headerNames", "columnState", "filters", "meta"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableView:
        """Create an instance of TableView from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in column_state (list)
        _items = []
        if self.column_state:
            for _item in self.column_state:
                if _item:
                    _items.append(_item.to_dict())
            _dict['columnState'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in filters (dict)
        _field_dict = {}
        if self.filters:
            for _key in self.filters:
                if self.filters[_key]:
                    _field_dict[_key] = self.filters[_key].to_dict()
            _dict['filters'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # set to None if filters (nullable) is None
        # and __fields_set__ contains the field
        if self.filters is None and "filters" in self.__fields_set__:
            _dict['filters'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableView:
        """Create an instance of TableView from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TableView.parse_obj(obj)

        _obj = TableView.parse_obj({
            "header_names": obj.get("headerNames"),
            "column_state": [ColumnStateType.from_dict(_item) for _item in obj.get("columnState")] if obj.get("columnState") is not None else None,
            "filters": dict(
                (_k, FilterModel.from_dict(_v))
                for _k, _v in obj.get("filters").items()
            )
            if obj.get("filters") is not None
            else None,
            "meta": TableMeta.from_dict(obj.get("meta")) if obj.get("meta") is not None else None
        })
        return _obj

TableView.update_forward_refs()
