/* global angular */
(function () {
  'use strict';

  angular
    .module('flexget.directives')
    .directive('paletteBackground', paletteBackground);

  /* @ngInject */
  function paletteBackground(flexTheme) {
    var directive = {
      bindToController: true,
      link: link,
      restrict: 'A',
    };
    return directive;

    function link(scope, $element, attrs) {
      var splitColor = attrs.paletteBackground.split(':');
      var color = flexTheme.getPaletteColor(splitColor[0], splitColor[1]);

      if (angular.isDefined(color)) {
        $element.css({
          'background-color': flexTheme.rgba(color.value),
          'border-color': flexTheme.rgba(color.value),
          color: flexTheme.rgba(color.contrast),
        });
      }
    }
  }
})();
