# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .network_endpoint import NetworkEndpoint

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class EndpointConnection(pydantic.BaseModel):
    """
    The Endpoint Connection object contains information detailing a connection attempt to an endpoint.
    """

    code: typing.Optional[int] = pydantic.Field(default=None)
    """
    A numerical response status code providing details about the connection.
    """

    network_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    Provides characteristics of the network endpoint.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
